/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.i18n;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.MissingResourceException;
import java.util.Objects;
import org.forgerock.util.i18n.PreferredLocales;

public class LocalizableString {
    public static final String TRANSLATION_KEY_PREFIX = "i18n:";
    private final ClassLoader loader;
    private final String value;
    private final URI resource;
    private final LocalizableString defaultValue;

    public LocalizableString(String value2) {
        this(value2, (ClassLoader)null);
    }

    public LocalizableString(String value2, Class<?> type2) {
        this(value2.replace(":#", ":" + type2.getName().replace(".", "/") + "#"), type2.getClassLoader());
    }

    public LocalizableString(String value2, ClassLoader loader) {
        this(value2, loader, null);
    }

    public LocalizableString(String key2, ClassLoader loader, LocalizableString defaultValue) {
        this.loader = loader;
        this.value = key2;
        this.defaultValue = defaultValue;
        URI resource2 = null;
        if (this.value != null && this.value.startsWith(TRANSLATION_KEY_PREFIX) && loader != null) {
            try {
                resource2 = new URI(this.value);
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        this.resource = resource2;
    }

    public String toTranslatedString(PreferredLocales locales) {
        if (this.resource == null) {
            return this.value;
        }
        try {
            return locales.getBundleInPreferredLocale(this.resource.getSchemeSpecificPart(), this.loader).getString(this.resource.getFragment());
        }
        catch (MissingResourceException missingResourceException) {
            return this.defaultValue == null ? this.resource.getFragment() : this.defaultValue.toTranslatedString(locales);
        }
    }

    public String toString() {
        return this.defaultValue == null ? this.value : "[" + this.value + "], default [" + this.defaultValue + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalizableString that = (LocalizableString)o;
        return this.value.equals(that.value) && Objects.equals(this.defaultValue, that.defaultValue);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.defaultValue);
    }
}

