/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.query;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.query.QueryFilterVisitor;

public class MapFilterVisitor<F>
implements QueryFilterVisitor<Map<String, Object>, Void, F> {
    static final String OPERATOR = "operator";
    static final String FIELD = "field";
    static final String VALUE = "value";
    static final String SUBFILTERS = "subfilters";
    static final String SUBFILTER = "subfilter";

    @Override
    public Map<String, Object> visitAndFilter(Void parameters2, List<QueryFilter<F>> subFilters) {
        ArrayList filters = new ArrayList();
        for (QueryFilter<F> filter : subFilters) {
            filters.add(filter.accept(this, parameters2));
        }
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put(OPERATOR, "and");
        object.put(SUBFILTERS, filters);
        return object;
    }

    @Override
    public Map<String, Object> visitBooleanLiteralFilter(Void parameters2, boolean value2) {
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put(OPERATOR, value2);
        return object;
    }

    @Override
    public Map<String, Object> visitContainsFilter(Void parameters2, F field2, Object valueAssertion) {
        return this.object(field2, "co", valueAssertion);
    }

    @Override
    public Map<String, Object> visitEqualsFilter(Void parameters2, F field2, Object valueAssertion) {
        return this.object(field2, "eq", valueAssertion);
    }

    @Override
    public Map<String, Object> visitExtendedMatchFilter(Void parameters2, F field2, String operator, Object valueAssertion) {
        return this.object(field2, operator, valueAssertion);
    }

    @Override
    public Map<String, Object> visitGreaterThanFilter(Void parameters2, F field2, Object valueAssertion) {
        return this.object(field2, "gt", valueAssertion);
    }

    @Override
    public Map<String, Object> visitGreaterThanOrEqualToFilter(Void parameters2, F field2, Object valueAssertion) {
        return this.object(field2, "ge", valueAssertion);
    }

    @Override
    public Map<String, Object> visitLessThanFilter(Void parameters2, F field2, Object valueAssertion) {
        return this.object(field2, "lt", valueAssertion);
    }

    @Override
    public Map<String, Object> visitLessThanOrEqualToFilter(Void parameters2, F field2, Object valueAssertion) {
        return this.object(field2, "le", valueAssertion);
    }

    @Override
    public Map<String, Object> visitNotFilter(Void parameters2, QueryFilter<F> subFilter) {
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put(OPERATOR, "!");
        object.put(SUBFILTER, subFilter.accept(this, parameters2));
        return object;
    }

    @Override
    public Map<String, Object> visitOrFilter(Void parameters2, List<QueryFilter<F>> subFilters) {
        ArrayList filters = new ArrayList();
        for (QueryFilter<F> filter : subFilters) {
            filters.add(filter.accept(this, parameters2));
        }
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put(OPERATOR, "or");
        object.put(SUBFILTERS, filters);
        return object;
    }

    @Override
    public Map<String, Object> visitPresentFilter(Void parameters2, F field2) {
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put(OPERATOR, "pr");
        object.put(FIELD, field2.toString());
        return object;
    }

    @Override
    public Map<String, Object> visitStartsWithFilter(Void parameters2, F field2, Object valueAssertion) {
        return this.object(field2, "sw", valueAssertion);
    }

    private Map<String, Object> object(F field2, String operator, Object valueAssertion) {
        HashMap<String, Object> object = new HashMap<String, Object>();
        object.put(OPERATOR, operator);
        object.put(FIELD, field2.toString());
        if (valueAssertion == null || valueAssertion instanceof Number || valueAssertion instanceof Boolean) {
            object.put(VALUE, valueAssertion);
        } else {
            object.put(VALUE, String.valueOf(valueAssertion));
        }
        return object;
    }
}

