/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.util.time;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import org.forgerock.util.Reject;

public class Duration
implements Comparable<Duration> {
    public static final Duration UNLIMITED = new Duration();
    public static final Duration ZERO = new Duration(0L, TimeUnit.SECONDS);
    private static final Set<String> UNLIMITED_TOKENS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
    private static final Set<String> ZERO_TOKENS;
    private long number;
    private TimeUnit unit;
    private static final Map<String, TimeUnit> TIME_UNITS;

    static {
        UNLIMITED_TOKENS.addAll(Arrays.asList("unlimited", "indefinite", "infinity", "undefined", "none"));
        ZERO_TOKENS = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        ZERO_TOKENS.addAll(Arrays.asList("zero", "disabled"));
        TIME_UNITS = new HashMap<String, TimeUnit>();
        for (String days : Arrays.asList("days", "day", "d")) {
            TIME_UNITS.put(days, TimeUnit.DAYS);
        }
        for (String hours : Arrays.asList("hours", "hour", "h")) {
            TIME_UNITS.put(hours, TimeUnit.HOURS);
        }
        for (String minutes : Arrays.asList("minutes", "minute", "min", "m")) {
            TIME_UNITS.put(minutes, TimeUnit.MINUTES);
        }
        for (String seconds : Arrays.asList("seconds", "second", "sec", "s")) {
            TIME_UNITS.put(seconds, TimeUnit.SECONDS);
        }
        for (String ms : Arrays.asList("milliseconds", "millisecond", "millisec", "millis", "milli", "ms")) {
            TIME_UNITS.put(ms, TimeUnit.MILLISECONDS);
        }
        for (String us : Arrays.asList("microseconds", "microsecond", "microsec", "micros", "micro", "us", "\u03bcs", "\u00b5s")) {
            TIME_UNITS.put(us, TimeUnit.MICROSECONDS);
        }
        for (String ns : Arrays.asList("nanoseconds", "nanosecond", "nanosec", "nanos", "nano", "ns")) {
            TIME_UNITS.put(ns, TimeUnit.NANOSECONDS);
        }
    }

    private Duration() {
        this.number = Long.MAX_VALUE;
        this.unit = null;
    }

    @Deprecated
    public Duration(Long number, TimeUnit unit) {
        Reject.ifTrue(number < 0L, "Negative durations are not supported");
        this.number = number;
        this.unit = Reject.checkNotNull(unit);
    }

    public static Duration duration(long number, TimeUnit unit) {
        if (number == 0L) {
            return ZERO;
        }
        return new Duration(number, unit);
    }

    public static Duration duration(String value2) {
        ArrayList<Duration> composite = new ArrayList<Duration>();
        String[] fragments = value2.split(",| and ");
        if (fragments.length == 1) {
            String trimmed = fragments[0].trim();
            if (UNLIMITED_TOKENS.contains(trimmed)) {
                return UNLIMITED;
            }
            if (ZERO_TOKENS.contains(trimmed)) {
                return ZERO;
            }
        }
        String[] stringArray = fragments;
        int n = fragments.length;
        int n2 = 0;
        while (n2 < n) {
            String fragment = stringArray[n2];
            if ("".equals(fragment = fragment.trim())) {
                throw new IllegalArgumentException("Cannot parse empty duration, expecting '<value> <unit>' pattern");
            }
            int i2 = 0;
            StringBuilder numberSB = new StringBuilder();
            while (Character.isDigit(fragment.charAt(i2))) {
                numberSB.append(fragment.charAt(i2));
                ++i2;
            }
            while (Character.isWhitespace(fragment.charAt(i2))) {
                ++i2;
            }
            StringBuilder unitSB = new StringBuilder();
            while (i2 < fragment.length() && Character.isLetter(fragment.charAt(i2))) {
                unitSB.append(fragment.charAt(i2));
                ++i2;
            }
            Long number = Long.valueOf(numberSB.toString());
            TimeUnit unit = Duration.parseTimeUnit(unitSB.toString());
            composite.add(new Duration(number, unit));
            ++n2;
        }
        Duration duration = new Duration(0L, TimeUnit.DAYS);
        for (Duration elements : composite) {
            duration.merge(elements);
        }
        if (duration.number == 0L) {
            return ZERO;
        }
        return duration;
    }

    private void merge(Duration duration) {
        if (!this.isUnlimited() && !duration.isUnlimited()) {
            if (this.unit.ordinal() > duration.unit.ordinal()) {
                this.number = duration.unit.convert(this.number, this.unit) + duration.number;
                this.unit = duration.unit;
            } else {
                this.number = this.unit.convert(duration.number, duration.unit) + this.number;
            }
        }
    }

    private static TimeUnit parseTimeUnit(String unit) {
        String lowercase = unit.toLowerCase(Locale.ENGLISH);
        TimeUnit timeUnit = TIME_UNITS.get(lowercase);
        if (timeUnit != null) {
            return timeUnit;
        }
        throw new IllegalArgumentException(String.format("TimeUnit %s is not recognized", unit));
    }

    public long getValue() {
        return this.number;
    }

    public TimeUnit getUnit() {
        if (this.isUnlimited()) {
            return TimeUnit.DAYS;
        }
        return this.unit;
    }

    public Duration convertTo(TimeUnit targetUnit) {
        if (this.isUnlimited() || this.isZero()) {
            return this;
        }
        return new Duration(this.to(targetUnit), targetUnit);
    }

    public long to(TimeUnit targetUnit) {
        if (this.isUnlimited()) {
            return this.number;
        }
        return targetUnit.convert(this.number, this.unit);
    }

    public boolean isUnlimited() {
        return this == UNLIMITED;
    }

    public boolean isZero() {
        return this.number == 0L;
    }

    public String toString() {
        if (this.isUnlimited()) {
            return "UNLIMITED";
        }
        if (this.isZero()) {
            return "ZERO";
        }
        return String.valueOf(this.number) + " " + (Object)((Object)this.unit);
    }

    @Override
    public int compareTo(Duration that) {
        boolean biggestOverflowed;
        long thatConverted;
        long thisConverted;
        if (this.isUnlimited()) {
            if (that.isUnlimited()) {
                return 0;
            }
            return 1;
        }
        if (that.isUnlimited()) {
            return -1;
        }
        if (this.isZero()) {
            if (that.isZero()) {
                return 0;
            }
            return -1;
        }
        if (that.isZero()) {
            return 1;
        }
        int unitCompare = this.getUnit().compareTo(that.getUnit());
        if (unitCompare > 0) {
            thisConverted = this.convertTo(that.getUnit()).getValue();
            thatConverted = that.getValue();
            biggestOverflowed = thisConverted == Long.MAX_VALUE;
        } else if (unitCompare < 0) {
            thisConverted = this.getValue();
            thatConverted = that.convertTo(this.getUnit()).getValue();
            biggestOverflowed = thatConverted == Long.MAX_VALUE;
        } else {
            biggestOverflowed = false;
            thisConverted = this.getValue();
            thatConverted = that.getValue();
        }
        return !biggestOverflowed ? Long.compare(thisConverted, thatConverted) : unitCompare;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Duration)) {
            return false;
        }
        Duration duration = (Duration)other;
        return this.number == duration.number && this.unit == duration.unit;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.number, this.unit});
    }
}

