/*
 * Decompiled with CFR 0.152.
 */
package org.joni;

import java.util.Collections;
import java.util.Iterator;
import org.jcodings.CaseFoldCodeItem;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.util.BytesHash;
import org.joni.Analyser;
import org.joni.Matcher;
import org.joni.MatcherFactory;
import org.joni.MinMaxLen;
import org.joni.NameEntry;
import org.joni.OptAnchorInfo;
import org.joni.OptExactInfo;
import org.joni.OptMapInfo;
import org.joni.Option;
import org.joni.Region;
import org.joni.Search;
import org.joni.Syntax;
import org.joni.WarnCallback;
import org.joni.exception.InternalException;
import org.joni.exception.ValueException;

public final class Regex {
    int[] code;
    int codeLength;
    boolean requireStack;
    int numMem;
    int numRepeat;
    int numNullCheck;
    int numCombExpCheck;
    int numCall;
    int captureHistory;
    int btMemStart;
    int btMemEnd;
    int stackPopLevel;
    int[] repeatRangeLo;
    int[] repeatRangeHi;
    MatcherFactory factory;
    final Encoding enc;
    int options;
    int userOptions;
    Object userObject;
    final int caseFoldFlag;
    private BytesHash<NameEntry> nameTable;
    Search.Forward forward;
    Search.Backward backward;
    int thresholdLength;
    int anchor;
    int anchorDmin;
    int anchorDmax;
    int subAnchor;
    byte[] exact;
    int exactP;
    int exactEnd;
    byte[] map;
    int[] intMap;
    int[] intMapBackward;
    int dMin;
    int dMax;
    byte[][] templates;
    int templateNum;

    public Regex(CharSequence cs) {
        this(cs.toString());
    }

    public Regex(CharSequence cs, Encoding enc) {
        this(cs.toString(), enc);
    }

    public Regex(String str) {
        this(str.getBytes(), 0, str.length(), 0, UTF8Encoding.INSTANCE);
    }

    public Regex(String str, Encoding enc) {
        this(str.getBytes(), 0, str.length(), 0, enc);
    }

    public Regex(byte[] bytes2) {
        this(bytes2, 0, bytes2.length, 0, ASCIIEncoding.INSTANCE);
    }

    public Regex(byte[] bytes2, int p2, int end2) {
        this(bytes2, p2, end2, 0, ASCIIEncoding.INSTANCE);
    }

    public Regex(byte[] bytes2, int p2, int end2, int option) {
        this(bytes2, p2, end2, option, ASCIIEncoding.INSTANCE);
    }

    public Regex(byte[] bytes2, int p2, int end2, int option, Encoding enc) {
        this(bytes2, p2, end2, option, enc, Syntax.RUBY, WarnCallback.DEFAULT);
    }

    public Regex(byte[] bytes2, int p2, int end2, int option, Encoding enc, Syntax syntax) {
        this(bytes2, p2, end2, option, 0x40000000, enc, syntax, WarnCallback.DEFAULT);
    }

    public Regex(byte[] bytes2, int p2, int end2, int option, Encoding enc, WarnCallback warnings) {
        this(bytes2, p2, end2, option, enc, Syntax.RUBY, warnings);
    }

    public Regex(byte[] bytes2, int p2, int end2, int option, Encoding enc, Syntax syntax, WarnCallback warnings) {
        this(bytes2, p2, end2, option, 0x40000000, enc, syntax, warnings);
    }

    public Regex(byte[] bytes2, int p2, int end2, int option, int caseFoldFlag, Encoding enc, Syntax syntax, WarnCallback warnings) {
        if ((option & 0x180) == 384) {
            throw new ValueException("invalid combination of options");
        }
        if ((option & 0x40) != 0) {
            option |= syntax.options;
            option &= 0xFFFFFFF7;
        } else {
            option |= syntax.options;
        }
        this.enc = enc;
        this.options = option;
        this.caseFoldFlag = caseFoldFlag;
        new Analyser(this, syntax, bytes2, p2, end2, warnings).compile();
    }

    public Matcher matcher(byte[] bytes2) {
        return this.matcher(bytes2, 0, bytes2.length);
    }

    public Matcher matcherNoRegion(byte[] bytes2) {
        return this.matcherNoRegion(bytes2, 0, bytes2.length);
    }

    public Matcher matcher(byte[] bytes2, int p2, int end2) {
        return this.factory.create(this, this.numMem == 0 ? null : new Region(this.numMem + 1), bytes2, p2, end2);
    }

    public Matcher matcherNoRegion(byte[] bytes2, int p2, int end2) {
        return this.factory.create(this, null, bytes2, p2, end2);
    }

    public int numberOfCaptures() {
        return this.numMem;
    }

    public int numberOfCaptureHistories() {
        return 0;
    }

    private NameEntry nameFind(byte[] name2, int nameP, int nameEnd) {
        if (this.nameTable != null) {
            return this.nameTable.get(name2, nameP, nameEnd);
        }
        return null;
    }

    void renumberNameTable(int[] map2) {
        if (this.nameTable != null) {
            for (NameEntry e : this.nameTable) {
                if (e.backNum > 1) {
                    for (int i2 = 0; i2 < e.backNum; ++i2) {
                        e.backRefs[i2] = map2[e.backRefs[i2]];
                    }
                    continue;
                }
                if (e.backNum != 1) continue;
                e.backRef1 = map2[e.backRef1];
            }
        }
    }

    void nameAdd(byte[] name2, int nameP, int nameEnd, int backRef, Syntax syntax) {
        if (nameEnd - nameP <= 0) {
            throw new ValueException("group name is empty");
        }
        NameEntry e = null;
        if (this.nameTable == null) {
            this.nameTable = new BytesHash();
        } else {
            e = this.nameFind(name2, nameP, nameEnd);
        }
        if (e == null) {
            e = new NameEntry(name2, nameP, nameEnd);
            this.nameTable.putDirect(name2, nameP, nameEnd, e);
        } else if (e.backNum >= 1 && !syntax.allowMultiplexDefinitionName()) {
            throw new ValueException("multiplex defined name <%n>", new String(name2, nameP, nameEnd - nameP));
        }
        e.addBackref(backRef);
    }

    NameEntry nameToGroupNumbers(byte[] name2, int nameP, int nameEnd) {
        return this.nameFind(name2, nameP, nameEnd);
    }

    public int nameToBackrefNumber(byte[] name2, int nameP, int nameEnd, Region region) {
        NameEntry e = this.nameToGroupNumbers(name2, nameP, nameEnd);
        if (e == null) {
            throw new ValueException("undefined name <%n> reference", new String(name2, nameP, nameEnd - nameP));
        }
        switch (e.backNum) {
            case 0: {
                throw new InternalException("internal parser error (bug)");
            }
            case 1: {
                return e.backRef1;
            }
        }
        if (region != null) {
            for (int i2 = e.backNum - 1; i2 >= 0; --i2) {
                if (region.beg[e.backRefs[i2]] == -1) continue;
                return e.backRefs[i2];
            }
        }
        return e.backRefs[e.backNum - 1];
    }

    String nameTableToString() {
        StringBuilder sb = new StringBuilder();
        if (this.nameTable != null) {
            sb.append("name table\n");
            for (NameEntry ne : this.nameTable) {
                sb.append("  " + ne + "\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public Iterator<NameEntry> namedBackrefIterator() {
        return this.nameTable == null ? Collections.emptyIterator() : this.nameTable.iterator();
    }

    public int numberOfNames() {
        return this.nameTable == null ? 0 : this.nameTable.size();
    }

    public boolean noNameGroupIsActive(Syntax syntax) {
        if (Option.isDontCaptureGroup(this.options)) {
            return false;
        }
        return this.numberOfNames() <= 0 || !syntax.captureOnlyNamedGroup() || Option.isCaptureGroup(this.options);
    }

    boolean setupBMSkipMap(boolean ignoreCase) {
        int clen;
        int i2;
        byte[] bytes2 = this.exact;
        int s2 = this.exactP;
        int end2 = this.exactEnd;
        int len = end2 - s2;
        CaseFoldCodeItem[] items = CaseFoldCodeItem.EMPTY_FOLD_CODES;
        byte[] buf = new byte[234];
        int ilen = len;
        if (this.map == null) {
            this.map = new byte[256];
        }
        for (i2 = 0; i2 < 256; ++i2) {
            this.map[i2] = (byte)(len + 1);
        }
        for (i2 = 0; i2 < ilen; i2 += clen) {
            if (ignoreCase) {
                items = this.enc.caseFoldCodesByString(this.caseFoldFlag, bytes2, s2 + i2, end2);
            }
            if ((clen = this.setupBMSkipMapCheck(bytes2, s2 + i2, end2, items, buf)) == 0) {
                return true;
            }
            for (int j = 0; j < clen; ++j) {
                this.map[bytes2[s2 + i2 + j] & 0xFF] = (byte)(ilen - i2 - j);
                for (int k = 0; k < items.length; ++k) {
                    this.map[buf[k * 13 + j] & 0xFF] = (byte)(ilen - i2 - j);
                }
            }
        }
        return false;
    }

    private int setupBMSkipMapCheck(byte[] bytes2, int p2, int end2, CaseFoldCodeItem[] items, byte[] buf) {
        int clen = this.enc.length(bytes2, p2, end2);
        if (p2 + clen > end2) {
            clen = end2 - p2;
        }
        for (int j = 0; j < items.length; ++j) {
            if (items[j].code.length != 1 || items[j].byteLen != clen) {
                return 0;
            }
            int flen = this.enc.codeToMbc(items[j].code[0], buf, j * 13);
            if (flen == clen) continue;
            return 0;
        }
        return clen;
    }

    void setOptimizeExactInfo(OptExactInfo e) {
        if (e.length == 0) {
            return;
        }
        this.exact = e.bytes;
        this.exactP = 0;
        this.exactEnd = e.length;
        boolean allowReverse = this.enc.isReverseMatchAllowed(this.exact, this.exactP, this.exactEnd);
        if (e.ignoreCase > 0) {
            this.forward = e.length >= 3 || e.length >= 2 && allowReverse ? (this.enc.toLowerCaseTable() != null ? Search.SLOW_IC_SB_FORWARD : Search.SLOW_IC_FORWARD) : (this.enc.toLowerCaseTable() != null ? Search.SLOW_IC_SB_FORWARD : Search.SLOW_IC_FORWARD);
            this.backward = this.enc.toLowerCaseTable() != null ? Search.SLOW_IC_SB_BACKWARD : Search.SLOW_IC_BACKWARD;
        } else {
            this.forward = e.length >= 3 || e.length >= 2 && allowReverse ? (!this.setupBMSkipMap(false) ? (allowReverse ? Search.BM_FORWARD : Search.BM_NOT_REV_FORWARD) : (this.enc.isSingleByte() ? Search.SLOW_SB_FORWARD : Search.SLOW_FORWARD)) : (this.enc.isSingleByte() ? Search.SLOW_SB_FORWARD : Search.SLOW_FORWARD);
            this.backward = this.enc.isSingleByte() ? Search.SLOW_SB_BACKWARD : Search.SLOW_BACKWARD;
        }
        this.dMin = e.mmd.min;
        this.dMax = e.mmd.max;
        if (this.dMin != Integer.MAX_VALUE) {
            this.thresholdLength = this.dMin + (this.exactEnd - this.exactP);
        }
    }

    void setOptimizeMapInfo(OptMapInfo m3) {
        this.map = m3.map;
        if (this.enc.isSingleByte()) {
            this.forward = Search.MAP_SB_FORWARD;
            this.backward = Search.MAP_SB_BACKWARD;
        } else {
            this.forward = Search.MAP_FORWARD;
            this.backward = Search.MAP_BACKWARD;
        }
        this.dMin = m3.mmd.min;
        this.dMax = m3.mmd.max;
        if (this.dMin != Integer.MAX_VALUE) {
            this.thresholdLength = this.dMin + 1;
        }
    }

    void setSubAnchor(OptAnchorInfo anc) {
        this.subAnchor |= anc.leftAnchor & 2;
        this.subAnchor |= anc.rightAnchor & 0x20;
    }

    void clearOptimizeInfo() {
        this.forward = null;
        this.backward = null;
        this.anchor = 0;
        this.anchorDmax = 0;
        this.anchorDmin = 0;
        this.subAnchor = 0;
        this.exact = null;
        this.exactEnd = 0;
        this.exactP = 0;
    }

    public String optimizeInfoToString() {
        String s2 = "";
        s2 = s2 + "optimize: " + (this.forward != null ? this.forward.getName() : "NONE") + "\n";
        s2 = s2 + "  anchor:     " + OptAnchorInfo.anchorToString(this.anchor);
        if ((this.anchor & 0x18) != 0) {
            s2 = s2 + MinMaxLen.distanceRangeToString(this.anchorDmin, this.anchorDmax);
        }
        s2 = s2 + "\n";
        if (this.forward != null) {
            s2 = s2 + "  sub anchor: " + OptAnchorInfo.anchorToString(this.subAnchor) + "\n";
        }
        s2 = s2 + "dmin: " + this.dMin + " dmax: " + this.dMax + "\n";
        s2 = s2 + "threshold length: " + this.thresholdLength + "\n";
        if (this.exact != null) {
            s2 = s2 + "exact: [" + new String(this.exact, this.exactP, this.exactEnd - this.exactP) + "]: length: " + (this.exactEnd - this.exactP) + "\n";
        } else if (this.forward == Search.MAP_FORWARD || this.forward == Search.MAP_SB_FORWARD) {
            int n = 0;
            for (int i2 = 0; i2 < 256; ++i2) {
                if (this.map[i2] == 0) continue;
                ++n;
            }
            s2 = s2 + "map: n = " + n + "\n";
            if (n > 0) {
                int c = 0;
                s2 = s2 + "[";
                for (int i3 = 0; i3 < 256; ++i3) {
                    if (this.map[i3] == 0) continue;
                    if (c > 0) {
                        s2 = s2 + ", ";
                    }
                    ++c;
                    s2 = this.enc.maxLength() == 1 && this.enc.isPrint(i3) ? s2 + (char)i3 : s2 + i3;
                }
                s2 = s2 + "]\n";
            }
        }
        return s2;
    }

    public Encoding getEncoding() {
        return this.enc;
    }

    public int getOptions() {
        return this.options;
    }

    public void setUserOptions(int options2) {
        this.userOptions = options2;
    }

    public int getUserOptions() {
        return this.userOptions;
    }

    public void setUserObject(Object object) {
        this.userObject = object;
    }

    public Object getUserObject() {
        return this.userObject;
    }
}

