/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.ffi;

import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyModule;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.ffi.AbstractMemory;
import org.jruby.ext.ffi.Buffer;
import org.jruby.ext.ffi.MemoryIO;
import org.jruby.ext.ffi.MemoryObject;
import org.jruby.ext.ffi.MemoryPointer;
import org.jruby.ext.ffi.ReifyingAllocator;
import org.jruby.ext.ffi.StructLayout;
import org.jruby.ext.ffi.Util;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.util.cli.Options;

@JRubyClass(name={"FFI::Struct"}, parent="Object")
public class Struct
extends MemoryObject
implements StructLayout.Storage {
    private StructLayout layout;
    private AbstractMemory memory;
    private volatile Object[] referenceCache;
    private volatile IRubyObject[] valueCache;
    private static final AtomicReferenceFieldUpdater<Struct, IRubyObject[]> valueCacheUpdater = AtomicReferenceFieldUpdater.newUpdater(Struct.class, IRubyObject[].class, "valueCache");
    private static final AtomicReferenceFieldUpdater<Struct, Object[]> referenceCacheUpdater = AtomicReferenceFieldUpdater.newUpdater(Struct.class, Object[].class, "referenceCache");

    public static RubyClass createStructClass(Ruby runtime2, RubyModule module) {
        RubyClass structClass = runtime2.defineClassUnder("Struct", runtime2.getObject(), Options.REIFY_FFI.load() != false ? new ReifyingAllocator(Struct.class) : Struct::new, module);
        structClass.defineAnnotatedMethods(Struct.class);
        structClass.defineAnnotatedConstants(Struct.class);
        structClass.setReifiedClass(Struct.class);
        structClass.kindOf = new RubyModule.KindOf(){

            @Override
            public boolean isKindOf(IRubyObject obj, RubyModule type2) {
                return obj instanceof Struct && super.isKindOf(obj, type2);
            }
        };
        return structClass;
    }

    Struct(Ruby runtime2) {
        this(runtime2, runtime2.getFFI().structClass);
    }

    public Struct(Ruby runtime2, RubyClass klass) {
        this(runtime2, klass, Struct.getStructLayout(runtime2, klass), null);
    }

    Struct(Ruby runtime2, RubyClass klass, StructLayout layout2, IRubyObject memory) {
        super(runtime2, klass);
        this.layout = layout2;
        if (memory != null && !(memory instanceof AbstractMemory)) {
            throw runtime2.newTypeError("wrong argument type " + memory.getMetaClass().getName() + " (expected Pointer or Buffer)");
        }
        this.memory = (AbstractMemory)memory;
    }

    static final boolean isStruct(Ruby runtime2, RubyClass klass) {
        return klass.isKindOfModule(runtime2.getFFI().structClass);
    }

    static final int getStructSize(Ruby runtime2, IRubyObject structClass) {
        return Struct.getStructLayout(runtime2, structClass).getSize();
    }

    static final StructLayout getStructLayout(Ruby runtime2, IRubyObject structClass) {
        try {
            Object layout2 = ((RubyClass)structClass).getFFIHandle();
            if (layout2 instanceof StructLayout) {
                return (StructLayout)layout2;
            }
            for (RubyClass klass = (RubyClass)structClass; klass != runtime2.getObject() && !((layout2 = klass.getInstanceVariable("@layout")) instanceof StructLayout); klass = klass.getSuperClass()) {
            }
            if (!(layout2 instanceof StructLayout)) {
                throw runtime2.newRuntimeError("no valid struct layout for " + ((RubyClass)structClass).getName());
            }
            ((RubyClass)structClass).setFFIHandle(layout2);
            return (StructLayout)layout2;
        }
        catch (ClassCastException ex) {
            if (!(structClass instanceof RubyClass)) {
                throw runtime2.newTypeError("wrong argument type " + structClass.getMetaClass().getName() + " (expected subclass of Struct)");
            }
            throw runtime2.newRuntimeError("invalid layout set for struct " + ((RubyClass)structClass).getName());
        }
    }

    @Override
    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context) {
        this.memory = MemoryPointer.allocate(context.runtime, this.layout.getSize(), 1, true);
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject ptr) {
        if (!(ptr instanceof AbstractMemory)) {
            if (ptr.isNil()) {
                return this.initialize(context);
            }
            throw context.runtime.newTypeError("wrong argument type " + ptr.getMetaClass().getName() + " (expected Pointer or Buffer)");
        }
        if (((AbstractMemory)ptr).getSize() < (long)this.layout.getSize()) {
            throw context.runtime.newArgumentError("memory object has insufficient space for " + this.getMetaClass().getName());
        }
        this.memory = (AbstractMemory)ptr;
        this.setMemoryIO(this.memory.getMemoryIO());
        return this;
    }

    @JRubyMethod(name={"initialize"}, visibility=Visibility.PRIVATE, rest=true)
    public IRubyObject initialize(ThreadContext context, IRubyObject[] args2) {
        switch (args2.length) {
            default: {
                IRubyObject result2 = this.getMetaClass().callMethod(context, "layout", args2[1] instanceof RubyArray ? ((RubyArray)args2[1]).toJavaArrayUnsafe() : Arrays.copyOfRange(args2, 1, args2.length));
                if (!(result2 instanceof StructLayout)) {
                    throw context.runtime.newTypeError("Struct.layout did not return a FFI::StructLayout instance");
                }
                this.layout = (StructLayout)result2;
            }
            case 1: {
                return this.initialize(context, args2[0]);
            }
            case 0: 
        }
        return this.initialize(context);
    }

    @JRubyMethod(name={"initialize_copy"}, visibility=Visibility.PRIVATE)
    public IRubyObject initialize_copy(ThreadContext context, IRubyObject other) {
        if (other == this) {
            return this;
        }
        if (!(other instanceof Struct)) {
            throw context.runtime.newTypeError("not an instance of Struct");
        }
        Struct orig = (Struct)other;
        this.memory = (AbstractMemory)orig.getMemory().slice(context.runtime, 0L, this.layout.getSize()).dup();
        if (orig.referenceCache != null) {
            this.referenceCache = new Object[this.layout.getReferenceFieldCount()];
            System.arraycopy(orig.referenceCache, 0, this.referenceCache, 0, this.referenceCache.length);
        }
        this.setMemoryIO(this.memory.getMemoryIO());
        return this;
    }

    private static final Struct allocateStruct(ThreadContext context, IRubyObject klass, int flags2) {
        Ruby runtime2 = context.runtime;
        StructLayout layout2 = Struct.getStructLayout(runtime2, klass);
        return new Struct(runtime2, (RubyClass)klass, layout2, new Buffer(runtime2, layout2.getSize(), flags2));
    }

    @JRubyMethod(name={"new_in", "alloc_in"}, meta=true)
    public static IRubyObject allocateIn(ThreadContext context, IRubyObject klass) {
        return Struct.allocateStruct(context, klass, 1);
    }

    @JRubyMethod(name={"new_in", "alloc_in"}, meta=true)
    public static IRubyObject allocateIn(ThreadContext context, IRubyObject klass, IRubyObject clearArg) {
        return Struct.allocateStruct(context, klass, 1);
    }

    @JRubyMethod(name={"new_out", "alloc_out"}, meta=true)
    public static IRubyObject allocateOut(ThreadContext context, IRubyObject klass) {
        return Struct.allocateStruct(context, klass, 2);
    }

    @JRubyMethod(name={"new_out", "alloc_out"}, meta=true)
    public static IRubyObject allocateOut(ThreadContext context, IRubyObject klass, IRubyObject clearArg) {
        return Struct.allocateStruct(context, klass, 2);
    }

    @JRubyMethod(name={"new_inout", "alloc_inout"}, meta=true)
    public static IRubyObject allocateInOut(ThreadContext context, IRubyObject klass) {
        return Struct.allocateStruct(context, klass, 3);
    }

    @JRubyMethod(name={"new_inout", "alloc_inout"}, meta=true)
    public static IRubyObject allocateInOut(ThreadContext context, IRubyObject klass, IRubyObject clearArg) {
        return Struct.allocateStruct(context, klass, 3);
    }

    @JRubyMethod(name={"size"}, meta=true)
    public static IRubyObject size(ThreadContext context, IRubyObject structClass) {
        if (!(structClass instanceof RubyClass)) {
            throw context.runtime.newTypeError(structClass, context.runtime.getClassClass());
        }
        RubyClass klass = (RubyClass)structClass;
        Object obj = klass.getFFIHandle();
        if (obj instanceof StructLayout) {
            return ((StructLayout)obj).size(context);
        }
        obj = ((RubyClass)structClass).getInstanceVariable("@layout");
        if (obj instanceof StructLayout) {
            return ((StructLayout)obj).size(context);
        }
        obj = ((RubyClass)structClass).getInstanceVariable("@size");
        return obj instanceof RubyFixnum ? (RubyFixnum)obj : RubyFixnum.zero(context.runtime);
    }

    @JRubyMethod(name={"alignment", "align"}, meta=true)
    public static IRubyObject alignment(ThreadContext context, IRubyObject structClass) {
        return Struct.getStructLayout(context.runtime, structClass).alignment(context);
    }

    @JRubyMethod(name={"layout="}, meta=true)
    public static IRubyObject set_layout(ThreadContext context, IRubyObject structClass, IRubyObject layout2) {
        if (!(structClass instanceof RubyClass)) {
            throw context.runtime.newTypeError(structClass, context.runtime.getClassClass());
        }
        if (!(layout2 instanceof StructLayout)) {
            throw context.runtime.newTypeError(layout2, context.runtime.getModule("FFI").getClass("StructLayout"));
        }
        RubyClass klass = (RubyClass)structClass;
        klass.setFFIHandle(layout2);
        klass.setInstanceVariable("@layout", layout2);
        return structClass;
    }

    @JRubyMethod(name={"members"}, meta=true)
    public static IRubyObject members(ThreadContext context, IRubyObject structClass) {
        return Struct.getStructLayout(context.runtime, structClass).members(context);
    }

    @JRubyMethod(name={"offsets"}, meta=true)
    public static IRubyObject offsets(ThreadContext context, IRubyObject structClass) {
        return Struct.getStructLayout(context.runtime, structClass).offsets(context);
    }

    @JRubyMethod(name={"offset_of"}, meta=true)
    public static IRubyObject offset_of(ThreadContext context, IRubyObject structClass, IRubyObject fieldName) {
        return Struct.getStructLayout(context.runtime, structClass).offset_of(context, fieldName);
    }

    @JRubyMethod(name={"[]"})
    public IRubyObject getFieldValue(ThreadContext context, IRubyObject fieldName) {
        return this.layout.getMember(context.runtime, fieldName).get(context, this, this.getMemory());
    }

    @JRubyMethod(name={"[]="})
    public IRubyObject setFieldValue(ThreadContext context, IRubyObject fieldName, IRubyObject fieldValue) {
        this.layout.getMember(context.runtime, fieldName).put(context, this, this.getMemory(), fieldValue);
        return fieldValue;
    }

    @JRubyMethod(name={"cspec", "layout"})
    public IRubyObject getLayout(ThreadContext context) {
        return this.layout;
    }

    @JRubyMethod(name={"pointer", "to_ptr"})
    public IRubyObject pointer(ThreadContext context) {
        return this.getMemory();
    }

    @JRubyMethod(name={"members"})
    public IRubyObject members(ThreadContext context) {
        return this.layout.members(context);
    }

    @JRubyMethod(name={"values"})
    public IRubyObject values(ThreadContext context) {
        IRubyObject[] values2 = new IRubyObject[this.layout.getFieldCount()];
        int i2 = 0;
        for (StructLayout.Member m3 : this.layout.getMembers()) {
            values2[i2++] = m3.get(context, this, this.getMemory());
        }
        return RubyArray.newArrayMayCopy(context.runtime, values2);
    }

    @JRubyMethod(name={"offsets"})
    public IRubyObject offsets(ThreadContext context) {
        return this.layout.offsets(context);
    }

    @JRubyMethod(name={"offset_of"})
    public IRubyObject offset_of(ThreadContext context, IRubyObject fieldName) {
        return this.layout.offset_of(context, fieldName);
    }

    @JRubyMethod(name={"size"})
    public IRubyObject size(ThreadContext context) {
        return this.layout.size(context);
    }

    @JRubyMethod(name={"alignment"})
    public IRubyObject alignment(ThreadContext context) {
        return this.layout.alignment(context);
    }

    @JRubyMethod(name={"null?"})
    public IRubyObject null_p(ThreadContext context) {
        return RubyBoolean.newBoolean(context, this.getMemory().getMemoryIO().isNull());
    }

    @JRubyMethod(name={"order"}, required=0)
    public final IRubyObject order(ThreadContext context) {
        return context.runtime.newSymbol(this.getMemoryIO().order().equals(ByteOrder.LITTLE_ENDIAN) ? "little" : "big");
    }

    @JRubyMethod(name={"order"}, required=1)
    public final IRubyObject order(ThreadContext context, IRubyObject byte_order) {
        ByteOrder order2 = Util.parseByteOrder(context.runtime, byte_order);
        return new Struct(context.runtime, this.getMetaClass(), this.layout, this.getMemory().order(context.runtime, order2));
    }

    @JRubyMethod(name={"clear"})
    public IRubyObject clear(ThreadContext context) {
        this.getMemoryIO().setMemory(0L, this.layout.size, (byte)0);
        return this;
    }

    public final AbstractMemory getMemory() {
        return this.memory != null ? this.memory : (this.memory = MemoryPointer.allocate(this.getRuntime(), this.layout.getSize(), 1, true));
    }

    @Override
    protected final MemoryIO allocateMemoryIO() {
        return this.getMemory().getMemoryIO();
    }

    @Override
    public final IRubyObject getCachedValue(StructLayout.Member member) {
        return this.valueCache != null ? this.valueCache[this.layout.getCacheableFieldIndex(member)] : null;
    }

    @Override
    public final void putCachedValue(StructLayout.Member member, IRubyObject value2) {
        this.getValueCacheForWrite()[this.layout.getCacheableFieldIndex((StructLayout.Member)member)] = value2;
    }

    private IRubyObject[] getValueCacheForWrite() {
        return this.valueCache != null ? this.valueCache : this.initValueCache();
    }

    private IRubyObject[] initValueCache() {
        valueCacheUpdater.compareAndSet(this, null, new IRubyObject[this.layout.getCacheableFieldCount()]);
        return this.valueCache;
    }

    private Object[] getReferenceCache() {
        return this.referenceCache != null ? this.referenceCache : this.initReferenceCache();
    }

    private Object[] initReferenceCache() {
        referenceCacheUpdater.compareAndSet(this, null, new Object[this.layout.getReferenceFieldCount()]);
        return this.referenceCache;
    }

    @Override
    public void putReference(StructLayout.Member member, Object value2) {
        this.getReferenceCache()[this.layout.getReferenceFieldIndex((StructLayout.Member)member)] = value2;
    }
}

