/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.platform;

import java.lang.reflect.Method;
import org.jruby.platform.Platform;
import org.jruby.runtime.builtin.IRubyObject;

public class SolarisPlatform
extends Platform {
    private final Class systemClass;
    private final Object system;
    private final Method groupsMethod;

    protected SolarisPlatform() {
        Class<?> sClass = null;
        Object s2 = null;
        Method g2 = null;
        try {
            sClass = Class.forName("com.sun.security.auth.module.SolarisSystem");
            s2 = sClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            g2 = sClass.getDeclaredMethod("getGroups", new Class[0]);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException(e.getMessage(), e);
        }
        this.systemClass = sClass;
        this.system = s2;
        this.groupsMethod = g2;
    }

    @Override
    public long[] getGroups(IRubyObject recv2) {
        if (this.groupsMethod == null) {
            throw recv2.getRuntime().newNotImplementedError("groups() function is unimplemented on this platform");
        }
        try {
            return (long[])this.groupsMethod.invoke(this.system, new Object[0]);
        }
        catch (Exception e) {
            throw new UnsupportedOperationException("groups() function is unimplemented on this platform", e);
        }
    }
}

