/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.runtime;

import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.Array;
import java.net.BindException;
import java.net.PortUnreachableException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.NotYetConnectedException;
import java.nio.charset.Charset;
import java.nio.file.AccessDeniedException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystemLoopException;
import java.nio.file.NoSuchFileException;
import java.nio.file.NotDirectoryException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.regex.Pattern;
import jnr.constants.platform.Errno;
import org.jcodings.Encoding;
import org.jcodings.specific.ASCIIEncoding;
import org.jcodings.specific.USASCIIEncoding;
import org.jcodings.specific.UTF8Encoding;
import org.jcodings.unicode.UnicodeEncoding;
import org.jruby.AbstractRubyMethod;
import org.jruby.MetaClass;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyBasicObject;
import org.jruby.RubyBignum;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyEncoding;
import org.jruby.RubyException;
import org.jruby.RubyFixnum;
import org.jruby.RubyHash;
import org.jruby.RubyKernel;
import org.jruby.RubyLocalJumpError;
import org.jruby.RubyMatchData;
import org.jruby.RubyModule;
import org.jruby.RubyProc;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.RubySymbol;
import org.jruby.ast.ArgsNode;
import org.jruby.ast.ArgumentNode;
import org.jruby.ast.MultipleAsgnNode;
import org.jruby.ast.Node;
import org.jruby.ast.RequiredKeywordArgumentValueNode;
import org.jruby.ast.RestArgNode;
import org.jruby.ast.UnnamedRestArgNode;
import org.jruby.ast.types.INameNode;
import org.jruby.ast.util.ArgsUtil;
import org.jruby.common.IRubyWarnings;
import org.jruby.exceptions.RaiseException;
import org.jruby.exceptions.Unrescuable;
import org.jruby.internal.runtime.methods.DynamicMethod;
import org.jruby.internal.runtime.methods.IRMethodArgs;
import org.jruby.internal.runtime.methods.MethodArgs2;
import org.jruby.ir.IRScope;
import org.jruby.ir.IRScopeType;
import org.jruby.ir.Interp;
import org.jruby.ir.JIT;
import org.jruby.ir.operands.UndefinedValue;
import org.jruby.ir.runtime.IRRuntimeHelpers;
import org.jruby.javasupport.JavaClass;
import org.jruby.javasupport.JavaUtil;
import org.jruby.javasupport.proxy.InternalJavaProxy;
import org.jruby.parser.StaticScope;
import org.jruby.runtime.ArgumentDescriptor;
import org.jruby.runtime.ArgumentType;
import org.jruby.runtime.Arity;
import org.jruby.runtime.Block;
import org.jruby.runtime.CallSite;
import org.jruby.runtime.CallType;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.DynamicScope;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.Signature;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.backtrace.BacktraceData;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.callsite.CacheEntry;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.util.ArraySupport;
import org.jruby.util.ByteList;
import org.jruby.util.CodegenUtils;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.StringSupport;
import org.jruby.util.TypeConverter;
import org.jruby.util.io.EncodingUtils;

public class Helpers {
    public static final Pattern SEMICOLON_PATTERN = Pattern.compile(";");
    public static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    public static final int MAX_SPECIFIC_ARITY_OBJECT_ARRAY = 10;
    public static final int MAX_SPECIFIC_ARITY_HASH = 5;

    public static RubyClass getSingletonClass(Ruby runtime2, IRubyObject receiver2) {
        if (receiver2 instanceof RubyFixnum || receiver2 instanceof RubySymbol) {
            throw runtime2.newTypeError("can't define singleton");
        }
        return receiver2.getSingletonClass();
    }

    @Deprecated
    public static IRubyObject invokeMethodMissing(IRubyObject receiver2, String name2, IRubyObject[] args2) {
        ThreadContext context = receiver2.getRuntime().getCurrentContext();
        context.setLastCallStatusAndVisibility(CallType.FUNCTIONAL, Visibility.PUBLIC);
        if (name2.equals("method_missing")) {
            return RubyKernel.method_missing(context, receiver2, args2, Block.NULL_BLOCK);
        }
        IRubyObject[] newArgs = Helpers.prepareMethodMissingArgs(args2, context, name2);
        return Helpers.invoke(context, receiver2, "method_missing", newArgs, Block.NULL_BLOCK);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass klass, Visibility visibility, String name2, CallType callType, IRubyObject[] args2, Block block) {
        return Helpers.selectMethodMissing(context, klass, visibility, name2, callType).call(context, self2, (RubyModule)klass, name2, args2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject[] args2, Block block) {
        RubyClass klass = RubyBasicObject.getMetaClass(receiver2);
        return Helpers.selectMethodMissing(context, klass, visibility, name2, callType).call(context, receiver2, (RubyModule)klass, name2, args2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass klass, Visibility visibility, String name2, CallType callType, IRubyObject arg0, Block block) {
        return Helpers.selectMethodMissing(context, klass, visibility, name2, callType).call(context, self2, (RubyModule)klass, name2, arg0, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject arg0, Block block) {
        RubyClass klass = RubyBasicObject.getMetaClass(receiver2);
        return Helpers.selectMethodMissing(context, klass, visibility, name2, callType).call(context, receiver2, (RubyModule)klass, name2, arg0, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass klass, Visibility visibility, String name2, CallType callType, IRubyObject arg0, IRubyObject arg1, Block block) {
        return Helpers.selectMethodMissing(context, klass, visibility, name2, callType).call(context, self2, (RubyModule)klass, name2, arg0, arg1, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject arg0, IRubyObject arg1, Block block) {
        RubyClass klass = RubyBasicObject.getMetaClass(receiver2);
        return Helpers.selectMethodMissing(context, klass, visibility, name2, callType).call(context, receiver2, (RubyModule)klass, name2, arg0, arg1, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass klass, Visibility visibility, String name2, CallType callType, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return Helpers.selectMethodMissing(context, klass, visibility, name2, callType).call(context, self2, klass, name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        RubyClass klass = RubyBasicObject.getMetaClass(receiver2);
        return Helpers.selectMethodMissing(context, klass, visibility, name2, callType).call(context, receiver2, klass, name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject self2, RubyClass klass, Visibility visibility, String name2, CallType callType, Block block) {
        return Helpers.selectMethodMissing(context, klass, visibility, name2, callType).call(context, self2, (RubyModule)klass, name2, block);
    }

    public static IRubyObject callMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType, Block block) {
        RubyClass klass = RubyBasicObject.getMetaClass(receiver2);
        return Helpers.selectMethodMissing(context, klass, visibility, name2, callType).call(context, receiver2, (RubyModule)klass, name2, block);
    }

    public static DynamicMethod selectMethodMissing(ThreadContext context, IRubyObject receiver2, Visibility visibility, String name2, CallType callType) {
        Ruby runtime2 = context.runtime;
        if (name2.equals("method_missing")) {
            return Helpers.selectInternalMM(runtime2, visibility, callType);
        }
        CacheEntry entry = receiver2.getMetaClass().searchWithCache("method_missing");
        DynamicMethod methodMissing = entry.method;
        if (methodMissing.isUndefined() || methodMissing.equals(runtime2.getDefaultMethodMissing())) {
            return Helpers.selectInternalMM(runtime2, visibility, callType);
        }
        return new MethodMissingMethod(entry, visibility, callType);
    }

    public static DynamicMethod selectMethodMissing(ThreadContext context, RubyClass selfClass, Visibility visibility, String name2, CallType callType) {
        Ruby runtime2 = context.runtime;
        if (name2.equals("method_missing")) {
            return Helpers.selectInternalMM(runtime2, visibility, callType);
        }
        CacheEntry entry = selfClass.searchWithCache("method_missing");
        DynamicMethod methodMissing = entry.method;
        if (methodMissing.isUndefined() || methodMissing.equals(runtime2.getDefaultMethodMissing())) {
            return Helpers.selectInternalMM(runtime2, visibility, callType);
        }
        return new MethodMissingMethod(entry, visibility, callType);
    }

    public static DynamicMethod selectMethodMissing(RubyClass selfClass, Visibility visibility, String name2, CallType callType) {
        Ruby runtime2 = selfClass.getClassRuntime();
        if (name2.equals("method_missing")) {
            return Helpers.selectInternalMM(runtime2, visibility, callType);
        }
        CacheEntry entry = selfClass.searchWithCache("method_missing");
        DynamicMethod methodMissing = entry.method;
        if (methodMissing.isUndefined() || methodMissing.equals(runtime2.getDefaultMethodMissing())) {
            return Helpers.selectInternalMM(runtime2, visibility, callType);
        }
        return new MethodMissingMethod(entry, visibility, callType);
    }

    public static final Map<String, String> map(String ... keyValues) {
        HashMap<String, String> map2 = new HashMap<String, String>(keyValues.length / 2 + 1, 1.0f);
        int i2 = 0;
        while (i2 < keyValues.length) {
            map2.put(keyValues[i2++], keyValues[i2++]);
        }
        return map2;
    }

    public static boolean additionOverflowed(long original, long other, long result2) {
        return ((original ^ other ^ 0xFFFFFFFFFFFFFFFFL) & (original ^ result2) & Long.MIN_VALUE) != 0L;
    }

    public static boolean subtractionOverflowed(long original, long other, long result2) {
        return ((original ^ (other ^ 0xFFFFFFFFFFFFFFFFL) ^ 0xFFFFFFFFFFFFFFFFL) & (original ^ result2) & Long.MIN_VALUE) != 0L;
    }

    public static Errno errnoFromException(Throwable t) {
        try {
            throw t;
        }
        catch (FileNotFoundException fnfe) {
            return Errno.ENOENT;
        }
        catch (EOFException eofe) {
            return Errno.EPIPE;
        }
        catch (AtomicMoveNotSupportedException amnse) {
            return Errno.EXDEV;
        }
        catch (ClosedChannelException cce) {
            return Errno.EBADF;
        }
        catch (PortUnreachableException pue) {
            return Errno.ECONNREFUSED;
        }
        catch (FileAlreadyExistsException faee) {
            return Errno.EEXIST;
        }
        catch (FileSystemLoopException fsle) {
            return Errno.ELOOP;
        }
        catch (NoSuchFileException nsfe) {
            return Errno.ENOENT;
        }
        catch (NotDirectoryException nde) {
            return Errno.ENOTDIR;
        }
        catch (AccessDeniedException ade) {
            return Errno.EACCES;
        }
        catch (DirectoryNotEmptyException dnee) {
            return Helpers.errnoFromMessage(dnee);
        }
        catch (BindException be) {
            return Helpers.errnoFromMessage(be);
        }
        catch (NotYetConnectedException nyce) {
            return Errno.ENOTCONN;
        }
        catch (NonReadableChannelException | NonWritableChannelException nrce) {
            return Errno.EINVAL;
        }
        catch (IllegalArgumentException nrce) {
            return Errno.EINVAL;
        }
        catch (IOException ioe) {
            String message2 = ioe.getMessage();
            if (message2.endsWith("The system cannot find the file specified")) {
                return Errno.ENOENT;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return Helpers.errnoFromMessage(t);
    }

    private static Errno errnoFromMessage(Throwable t) {
        String errorMessage = t.getMessage();
        if (errorMessage != null) {
            switch (errorMessage) {
                case "Bad file descriptor": {
                    return Errno.EBADF;
                }
                case "File not open": {
                    return null;
                }
                case "An established connection was aborted by the software in your host machine": 
                case "connection was aborted": {
                    return Errno.ECONNABORTED;
                }
                case "Broken pipe": {
                    return Errno.EPIPE;
                }
                case "Connection reset by peer": 
                case "An existing connection was forcibly closed by the remote host": {
                    return Errno.ECONNRESET;
                }
                case "Too many levels of symbolic links": {
                    return Errno.ELOOP;
                }
                case "Too many open files": {
                    return Errno.EMFILE;
                }
                case "Too many open files in system": {
                    return Errno.ENFILE;
                }
                case "Network is unreachable": {
                    return Errno.ENETUNREACH;
                }
                case "Address already in use": {
                    return Errno.EADDRINUSE;
                }
                case "Cannot assign requested address": 
                case "Can't assign requested address": {
                    return Errno.EADDRNOTAVAIL;
                }
                case "No space left on device": {
                    return Errno.ENOSPC;
                }
                case "Message too large": 
                case "Message too long": {
                    return Errno.EMSGSIZE;
                }
                case "Is a directory": {
                    return Errno.EISDIR;
                }
                case "Operation timed out": {
                    return Errno.ETIMEDOUT;
                }
                case "No route to host": {
                    return Errno.EHOSTUNREACH;
                }
                case "permission denied": 
                case "Permission denied": {
                    return Errno.EACCES;
                }
                case "Protocol family not supported": {
                    return Errno.EPFNOSUPPORT;
                }
            }
        }
        return null;
    }

    public static RaiseException newIOErrorFromException(Ruby runtime2, IOException ex) {
        return (RaiseException)Helpers.newErrorFromException(runtime2, ex, t -> runtime2.newRuntimeError("unexpected Java exception: " + ex.toString()));
    }

    public static Throwable newErrorFromException(Ruby runtime2, Throwable t, Function<Throwable, Throwable> els) {
        if (t instanceof RaiseException) {
            return t;
        }
        Errno errno2 = Helpers.errnoFromException(t);
        if (errno2 != null) {
            return runtime2.newErrnoFromErrno(errno2, t.getLocalizedMessage());
        }
        if (t instanceof IOException) {
            return runtime2.newIOError(t.getLocalizedMessage());
        }
        return els.apply(t);
    }

    public static Throwable newErrorFromException(Ruby runtime2, Throwable t) {
        return Helpers.newErrorFromException(runtime2, t, t0 -> t0);
    }

    public static void throwErrorFromException(Ruby runtime2, Throwable t) {
        Helpers.throwException(Helpers.newErrorFromException(runtime2, t));
    }

    public static RubyModule getNthScopeModule(StaticScope scope, int depth) {
        int n = depth;
        while (n > 0) {
            if ((scope = scope.getEnclosingScope()).getScopeType() == null) continue;
            --n;
        }
        return scope.getModule();
    }

    public static RubyArray viewArgsArray(ThreadContext context, RubyArray rubyArray, int preArgsCount, int postArgsCount) {
        int n = rubyArray.getLength();
        if (preArgsCount + postArgsCount >= n) {
            return RubyArray.newEmptyArray(context.runtime);
        }
        return (RubyArray)rubyArray.subseq(context.runtime.getArray(), preArgsCount, n - preArgsCount - postArgsCount, true);
    }

    public static Class[] getStaticMethodParams(Class target, int args2) {
        switch (args2) {
            case 0: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, Block.class};
            }
            case 1: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class};
            }
            case 2: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class};
            }
            case 3: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class};
            }
            case 4: {
                return new Class[]{target, ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class};
            }
        }
        throw new RuntimeException("unsupported arity: " + args2);
    }

    public static String getStaticMethodSignature(String classname, int args2) {
        switch (args2) {
            case 0: {
                return CodegenUtils.sig(IRubyObject.class, "L" + classname + ";", ThreadContext.class, IRubyObject.class, Block.class);
            }
            case 1: {
                return CodegenUtils.sig(IRubyObject.class, "L" + classname + ";", ThreadContext.class, IRubyObject.class, IRubyObject.class, Block.class);
            }
            case 2: {
                return CodegenUtils.sig(IRubyObject.class, "L" + classname + ";", ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class);
            }
            case 3: {
                return CodegenUtils.sig(IRubyObject.class, "L" + classname + ";", ThreadContext.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, IRubyObject.class, Block.class);
            }
            case 4: {
                return CodegenUtils.sig(IRubyObject.class, "L" + classname + ";", ThreadContext.class, IRubyObject.class, IRubyObject[].class, Block.class);
            }
        }
        throw new RuntimeException("unsupported arity: " + args2);
    }

    public static int calculateBufferLength(int length2) {
        int newLength;
        if (length2 > 0x7FFFFFF7) {
            throw new OutOfMemoryError("Requested array size exceeds VM limit");
        }
        try {
            newLength = Math.addExact(length2, length2 >>> 1);
        }
        catch (ArithmeticException e) {
            newLength = 0x7FFFFFF7;
        }
        return newLength;
    }

    public static int calculateBufferLength(Ruby runtime2, int length2) {
        int newLength;
        if (length2 > 0x7FFFFFF7) {
            throw runtime2.newArgumentError("argument too big");
        }
        try {
            newLength = Math.addExact(length2, length2 >>> 1);
        }
        catch (ArithmeticException e) {
            newLength = 0x7FFFFFF7;
        }
        return newLength;
    }

    public static int multiplyBufferLength(Ruby runtime2, int base, int multiplier) {
        try {
            int newSize = Math.multiplyExact(base, multiplier);
            if (newSize <= 0x7FFFFFF7) {
                return newSize;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        throw runtime2.newArgumentError("argument too big");
    }

    public static int addBufferLength(Ruby runtime2, int base, int extra) {
        try {
            int newSize = Math.addExact(base, extra);
            if (newSize <= 0x7FFFFFF7) {
                return newSize;
            }
            if (extra > 0) {
                return 0x7FFFFFF7;
            }
        }
        catch (ArithmeticException arithmeticException) {
            // empty catch block
        }
        throw runtime2.newArgumentError("argument too big");
    }

    public static int validateBufferLength(Ruby runtime2, int length2) {
        if (length2 < 0) {
            throw runtime2.newArgumentError("negative argument");
        }
        if (length2 > 0x7FFFFFF7) {
            throw runtime2.newArgumentError("argument too big");
        }
        return length2;
    }

    private static DynamicMethod selectInternalMM(Ruby runtime2, Visibility visibility, CallType callType) {
        if (visibility == Visibility.PRIVATE) {
            return runtime2.getPrivateMethodMissing();
        }
        if (visibility == Visibility.PROTECTED) {
            return runtime2.getProtectedMethodMissing();
        }
        if (callType == CallType.VARIABLE) {
            return runtime2.getVariableMethodMissing();
        }
        if (callType == CallType.SUPER) {
            return runtime2.getSuperMethodMissing();
        }
        return runtime2.getNormalMethodMissing();
    }

    private static IRubyObject[] prepareMethodMissingArgs(IRubyObject[] args2, ThreadContext context, String name2) {
        return ArraySupport.newCopy(context.runtime.newSymbol(name2), args2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, Block block) {
        return self2.getMetaClass().finvoke(context, self2, name2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, Block block) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0, arg1, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        return self2.getMetaClass().finvoke(context, self2, name2, args2, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2) {
        return self2.getMetaClass().finvoke(context, self2, name2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0, arg1);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2) {
        return self2.getMetaClass().finvoke(context, self2, name2, arg0, arg1, arg2);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject ... args2) {
        return self2.getMetaClass().finvoke(context, self2, name2, args2);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self2, String name2, IRubyObject[] args2, Block block) {
        return asClass.finvoke(context, self2, name2, args2, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self2, String name2, Block block) {
        return asClass.finvoke(context, self2, name2, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self2, String name2, IRubyObject arg0, Block block) {
        return asClass.finvoke(context, self2, name2, arg0, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, Block block) {
        return asClass.finvoke(context, self2, name2, arg0, arg1, block);
    }

    public static IRubyObject invokeAs(ThreadContext context, RubyClass asClass, IRubyObject self2, String name2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        return asClass.finvoke(context, self2, name2, arg0, arg1, arg2, block);
    }

    public static IRubyObject invokePublic(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2) {
        return RubyBasicObject.getMetaClass(self2).invokePublic(context, self2, name2, arg2);
    }

    public static IRubyObject invokeChecked(ThreadContext context, IRubyObject self2, String name2) {
        return RubyBasicObject.getMetaClass(self2).finvokeChecked(context, self2, name2);
    }

    public static IRubyObject invokeChecked(ThreadContext context, IRubyObject self2, JavaSites.CheckedSites sites) {
        return RubyBasicObject.getMetaClass(self2).finvokeChecked(context, self2, sites);
    }

    public static IRubyObject invokeChecked(ThreadContext context, IRubyObject self2, String name2, IRubyObject ... args2) {
        return RubyBasicObject.getMetaClass(self2).finvokeChecked(context, self2, name2, args2);
    }

    public static IRubyObject invokeChecked(ThreadContext context, IRubyObject self2, JavaSites.CheckedSites sites, IRubyObject arg0) {
        return RubyBasicObject.getMetaClass(self2).finvokeChecked(context, self2, sites, arg0);
    }

    public static IRubyObject invokeChecked(ThreadContext context, IRubyObject self2, JavaSites.CheckedSites sites, IRubyObject ... args2) {
        return RubyBasicObject.getMetaClass(self2).finvokeChecked(context, self2, sites, args2);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, IRubyObject[] args2, Block block) {
        return Helpers.invokeSuper(context, self2, context.getFrameKlazz(), context.getFrameName(), args2, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, RubyModule klass, String name2, IRubyObject[] args2, Block block) {
        Helpers.checkSuperDisabledOrOutOfMethod(context, klass, name2);
        RubyClass selfClass = RubyBasicObject.getMetaClass(self2);
        RubyClass superClass = klass.getSuperClass();
        CacheEntry entry = superClass != null ? superClass.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, selfClass, method2.getVisibility(), name2, CallType.SUPER, args2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, args2, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, RubyModule klass, String name2, IRubyObject arg0, Block block) {
        Helpers.checkSuperDisabledOrOutOfMethod(context, klass, name2);
        RubyClass selfClass = RubyBasicObject.getMetaClass(self2);
        RubyClass superClass = klass.getSuperClass();
        CacheEntry entry = superClass != null ? superClass.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, selfClass, method2.getVisibility(), name2, CallType.SUPER, arg0, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, Block block) {
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfClass = RubyBasicObject.getMetaClass(self2);
        RubyClass superClass = klazz.getSuperClass();
        CacheEntry entry = superClass != null ? superClass.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, selfClass, method2.getVisibility(), name2, CallType.SUPER, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, IRubyObject arg0, Block block) {
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfClass = RubyBasicObject.getMetaClass(self2);
        RubyClass superClass = klazz.getSuperClass();
        CacheEntry entry = superClass != null ? superClass.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, selfClass, method2.getVisibility(), name2, CallType.SUPER, arg0, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, Block block) {
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfClass = RubyBasicObject.getMetaClass(self2);
        RubyClass superClass = klazz.getSuperClass();
        CacheEntry entry = superClass != null ? superClass.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, selfClass, method2.getVisibility(), name2, CallType.SUPER, arg0, arg1, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, block);
    }

    public static IRubyObject invokeSuper(ThreadContext context, IRubyObject self2, IRubyObject arg0, IRubyObject arg1, IRubyObject arg2, Block block) {
        Helpers.checkSuperDisabledOrOutOfMethod(context);
        RubyModule klazz = context.getFrameKlazz();
        String name2 = context.getFrameName();
        RubyClass selfClass = RubyBasicObject.getMetaClass(self2);
        RubyClass superClass = klazz.getSuperClass();
        CacheEntry entry = superClass != null ? superClass.searchWithCache(name2) : CacheEntry.NULL_CACHE;
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined()) {
            return Helpers.callMethodMissing(context, self2, selfClass, method2.getVisibility(), name2, CallType.SUPER, arg0, arg1, arg2, block);
        }
        return method2.call(context, self2, entry.sourceModule, name2, arg0, arg1, arg2, block);
    }

    @Deprecated
    public static RubyArray ensureRubyArray(IRubyObject value2) {
        return Helpers.ensureRubyArray(value2.getRuntime(), value2);
    }

    public static RubyArray ensureRubyArray(Ruby runtime2, IRubyObject value2) {
        return value2 instanceof RubyArray ? (RubyArray)value2 : RubyArray.newArray(runtime2, value2);
    }

    @Deprecated
    public static IRubyObject nullToNil(IRubyObject value2, ThreadContext context) {
        return value2 != null ? value2 : context.nil;
    }

    @Deprecated
    public static IRubyObject nullToNil(IRubyObject value2, Ruby runtime2) {
        return value2 != null ? value2 : runtime2.getNil();
    }

    public static IRubyObject nullToNil(IRubyObject value2, IRubyObject nil) {
        return value2 != null ? value2 : nil;
    }

    public static void handleArgumentSizes(ThreadContext context, Ruby runtime2, int given, int required, int opt, int rest2) {
        if (opt == 0) {
            if (rest2 < 0 ? given != required : given < required) {
                throw runtime2.newArgumentError(given, required);
            }
        } else if (rest2 < 0) {
            if (given < required) {
                throw runtime2.newArgumentError(given, required);
            }
            if (given > required + opt) {
                throw runtime2.newArgumentError(given, required + opt);
            }
        } else if (given < required) {
            throw runtime2.newArgumentError(given, required);
        }
    }

    public static String getLocalJumpTypeOrRethrow(RaiseException re) {
        RubyException exception2 = re.getException();
        Ruby runtime2 = exception2.getRuntime();
        if (runtime2.getLocalJumpError().isInstance(exception2)) {
            RubyLocalJumpError jumpError = (RubyLocalJumpError)re.getException();
            IRubyObject reason2 = jumpError.reason();
            return reason2.asJavaString();
        }
        throw re;
    }

    public static IRubyObject unwrapLocalJumpErrorValue(RaiseException re) {
        return ((RubyLocalJumpError)re.getException()).exit_value();
    }

    public static Block getBlockFromBlockPassBody(Ruby runtime2, IRubyObject proc2, Block currentBlock) {
        if (proc2.isNil()) {
            return Block.NULL_BLOCK;
        }
        if (!(proc2 instanceof RubyProc)) {
            proc2 = Helpers.coerceProc(proc2, runtime2);
        }
        return Helpers.getBlockFromProc(currentBlock, proc2);
    }

    private static IRubyObject coerceProc(IRubyObject maybeProc, Ruby runtime2) throws RaiseException {
        IRubyObject proc2 = TypeConverter.convertToType(maybeProc, runtime2.getProc(), "to_proc", false);
        if (!(proc2 instanceof RubyProc)) {
            throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, "wrong argument type ", RubyStringBuilder.types(runtime2, maybeProc.getMetaClass()), " (expected Proc)"));
        }
        return proc2;
    }

    private static Block getBlockFromProc(Block currentBlock, IRubyObject proc2) {
        RubyProc procObject;
        if (currentBlock != null && currentBlock.isGiven() && (procObject = currentBlock.getProcObject()) != null && procObject == proc2) {
            return currentBlock;
        }
        return ((RubyProc)proc2).getBlock();
    }

    public static Block getBlockFromBlockPassBody(IRubyObject proc2, Block currentBlock) {
        return Helpers.getBlockFromBlockPassBody(proc2.getRuntime(), proc2, currentBlock);
    }

    public static IRubyObject backref(ThreadContext context) {
        return RubyRegexp.getBackRef(context);
    }

    public static IRubyObject backrefLastMatch(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.last_match(backref);
    }

    public static IRubyObject backrefMatchPre(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.match_pre(backref);
    }

    public static IRubyObject backrefMatchPost(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.match_post(backref);
    }

    public static IRubyObject backrefMatchLast(ThreadContext context) {
        IRubyObject backref = context.getBackRef();
        return RubyRegexp.match_last(backref);
    }

    public static IRubyObject[] appendToObjectArray(IRubyObject[] array2, IRubyObject add3) {
        return ArraySupport.newCopy(array2, add3);
    }

    public static IRubyObject breakLocalJumpError(Ruby runtime2, IRubyObject value2) {
        throw runtime2.newLocalJumpError(RubyLocalJumpError.Reason.BREAK, value2, "unexpected break");
    }

    public static IRubyObject[] concatObjectArrays(IRubyObject[] array2, IRubyObject[] add3) {
        return Helpers.toArray(array2, add3);
    }

    public static IRubyObject[] toArray(IRubyObject[] array2, IRubyObject ... rest2) {
        int len = array2.length;
        Object[] newArray = new IRubyObject[len + rest2.length];
        ArraySupport.copy(array2, newArray, 0, len);
        ArraySupport.copy(rest2, newArray, len, rest2.length);
        return newArray;
    }

    public static IRubyObject[] toArray(IRubyObject obj, IRubyObject ... rest2) {
        return ArraySupport.newCopy(obj, rest2);
    }

    public static IRubyObject[] toArray(IRubyObject obj0, IRubyObject obj1, IRubyObject ... rest2) {
        Object[] newArray = new IRubyObject[2 + rest2.length];
        newArray[0] = obj0;
        newArray[1] = obj1;
        ArraySupport.copy(rest2, newArray, 2, rest2.length);
        return newArray;
    }

    public static IRubyObject[] toArray(IRubyObject obj0, IRubyObject obj1, IRubyObject obj2, IRubyObject ... rest2) {
        Object[] newArray = new IRubyObject[3 + rest2.length];
        newArray[0] = obj0;
        newArray[1] = obj1;
        newArray[2] = obj2;
        ArraySupport.copy(rest2, newArray, 3, rest2.length);
        return newArray;
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject[] exceptions, ThreadContext context) {
        for (int i2 = 0; i2 < exceptions.length; ++i2) {
            IRubyObject result2 = Helpers.isExceptionHandled(currentException, exceptions[i2], context);
            if (!result2.isTrue()) continue;
            return result2;
        }
        return context.fals;
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject exception2, ThreadContext context) {
        return Helpers.isExceptionHandled((IRubyObject)currentException, exception2, context);
    }

    public static IRubyObject isExceptionHandled(IRubyObject currentException, IRubyObject exception2, ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (!runtime2.getModule().isInstance(exception2)) {
            throw runtime2.newTypeError("class or module required for rescue clause");
        }
        IRubyObject result2 = Helpers.invoke(context, exception2, "===", currentException);
        if (result2.isTrue()) {
            return result2;
        }
        return runtime2.getFalse();
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject exception0, IRubyObject exception1, ThreadContext context) {
        IRubyObject result2 = Helpers.isExceptionHandled(currentException, exception0, context);
        if (result2.isTrue()) {
            return result2;
        }
        return Helpers.isExceptionHandled(currentException, exception1, context);
    }

    public static IRubyObject isExceptionHandled(RubyException currentException, IRubyObject exception0, IRubyObject exception1, IRubyObject exception2, ThreadContext context) {
        IRubyObject result2 = Helpers.isExceptionHandled(currentException, exception0, context);
        if (result2.isTrue()) {
            return result2;
        }
        return Helpers.isExceptionHandled(currentException, exception1, exception2, context);
    }

    public static boolean checkJavaException(IRubyObject wrappedEx, Throwable ex, IRubyObject catchable, ThreadContext context) {
        Ruby runtime2 = context.runtime;
        if (runtime2.getException() == catchable || runtime2.getObject() == catchable || runtime2.getStandardError() == catchable) {
            if (ex instanceof RaiseException) {
                return Helpers.isExceptionHandled(((RaiseException)ex).getException(), catchable, context).isTrue();
            }
            return Helpers.isExceptionHandled(wrappedEx, catchable, context).isTrue();
        }
        if (runtime2.getNativeException() == catchable) {
            return true;
        }
        if (catchable instanceof RubyClass && JavaClass.isProxyType(context, (RubyClass)catchable)) {
            IRubyObject target;
            if (ex instanceof InternalJavaProxy && (target = ((InternalJavaProxy)((Object)ex)).___getInvocationHandler().getOrig()) != null) {
                return ((RubyClass)catchable).isInstance(target);
            }
            return ((RubyClass)catchable).isInstance(wrappedEx);
        }
        if (catchable instanceof RubyModule) {
            IRubyObject result2 = Helpers.invoke(context, catchable, "===", wrappedEx);
            return result2.isTrue();
        }
        return false;
    }

    public static boolean checkJavaException(Throwable ex, IRubyObject catchable, ThreadContext context) {
        return Helpers.checkJavaException(Helpers.wrapJavaException(context.runtime, ex), ex, catchable, context);
    }

    public static IRubyObject wrapJavaException(Ruby runtime2, Throwable ex) {
        return JavaUtil.convertJavaToUsableRubyObject(runtime2, ex);
    }

    @Deprecated
    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject[] throwables, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwables, context);
        }
        if (throwables.length == 0) {
            return context.tru;
        }
        for (int i2 = 0; i2 < throwables.length; ++i2) {
            if (!Helpers.checkJavaException(currentThrowable, throwables[i2], context)) continue;
            return context.tru;
        }
        return context.fals;
    }

    @Deprecated
    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject throwable, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwable, context);
        }
        if (Helpers.checkJavaException(currentThrowable, throwable, context)) {
            return context.tru;
        }
        return context.fals;
    }

    @Deprecated
    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject throwable0, IRubyObject throwable1, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwable0, throwable1, context);
        }
        if (Helpers.checkJavaException(currentThrowable, throwable0, context)) {
            return context.tru;
        }
        if (Helpers.checkJavaException(currentThrowable, throwable1, context)) {
            return context.tru;
        }
        return context.fals;
    }

    @Deprecated
    public static IRubyObject isJavaExceptionHandled(Throwable currentThrowable, IRubyObject throwable0, IRubyObject throwable1, IRubyObject throwable2, ThreadContext context) {
        if (currentThrowable instanceof Unrescuable) {
            Helpers.throwException(currentThrowable);
        }
        if (currentThrowable instanceof RaiseException) {
            return Helpers.isExceptionHandled(((RaiseException)currentThrowable).getException(), throwable0, throwable1, throwable2, context);
        }
        if (Helpers.checkJavaException(currentThrowable, throwable0, context)) {
            return context.tru;
        }
        if (Helpers.checkJavaException(currentThrowable, throwable1, context)) {
            return context.tru;
        }
        if (Helpers.checkJavaException(currentThrowable, throwable2, context)) {
            return context.tru;
        }
        return context.fals;
    }

    @Deprecated
    public static void storeExceptionInErrorInfo(Throwable currentThrowable, ThreadContext context) {
        IRubyObject exception2 = currentThrowable instanceof RaiseException ? ((RaiseException)currentThrowable).getException() : JavaUtil.convertJavaToUsableRubyObject(context.runtime, currentThrowable);
        context.setErrorInfo(exception2);
    }

    public static void clearErrorInfo(ThreadContext context) {
        context.setErrorInfo(context.nil);
    }

    public static void checkSuperDisabledOrOutOfMethod(ThreadContext context) {
        Helpers.checkSuperDisabledOrOutOfMethod(context, context.getFrameKlazz(), context.getFrameName());
    }

    public static void checkSuperDisabledOrOutOfMethod(ThreadContext context, RubyModule klass, String name2) {
        if (klass == null && name2 != null) {
            Ruby runtime2 = context.runtime;
            throw runtime2.newNameError(RubyStringBuilder.str(runtime2, "superclass method '", RubyStringBuilder.ids(runtime2, name2), "' disabled"), name2);
        }
        if (name2 == null) {
            throw context.runtime.newNoMethodError("super called outside of method", null, context.nil);
        }
    }

    public static RubyModule findImplementerIfNecessary(RubyModule clazz, RubyModule implementationClass) {
        if (implementationClass.needsImplementer()) {
            return clazz.findImplementer(implementationClass);
        }
        return implementationClass.getMethodLocation();
    }

    public static RubyArray createSubarray(RubyArray input, int start2) {
        return (RubyArray)input.subseqLight(start2, input.size() - start2);
    }

    public static RubyArray createSubarray(RubyArray input, int start2, int post) {
        return (RubyArray)input.subseqLight(start2, input.size() - post - start2);
    }

    public static RubyArray createSubarray(IRubyObject[] input, Ruby runtime2, int start2) {
        if (start2 >= input.length) {
            return RubyArray.newEmptyArray(runtime2);
        }
        return RubyArray.newArrayMayCopy(runtime2, input, start2);
    }

    public static RubyArray createSubarray(IRubyObject[] input, Ruby runtime2, int start2, int exclude) {
        int length2 = input.length - exclude - start2;
        if (length2 <= 0) {
            return RubyArray.newEmptyArray(runtime2);
        }
        return RubyArray.newArrayMayCopy(runtime2, input, start2, length2);
    }

    public static IRubyObject elementOrNull(IRubyObject[] input, int element) {
        if (element >= input.length) {
            return null;
        }
        return input[element];
    }

    public static IRubyObject optElementOrNull(IRubyObject[] input, int element, int postCount) {
        if (element + postCount >= input.length) {
            return null;
        }
        return input[element];
    }

    public static IRubyObject elementOrNil(IRubyObject[] input, int element, IRubyObject nil) {
        if (element >= input.length) {
            return nil;
        }
        return input[element];
    }

    public static IRubyObject setConstantInModule(ThreadContext context, String name2, IRubyObject value2, IRubyObject module) {
        if (!(module instanceof RubyModule)) {
            throw context.runtime.newTypeError(RubyStringBuilder.str(context.runtime, RubyStringBuilder.ids(context.runtime, module), " is not a class/module"));
        }
        ((RubyModule)module).setConstant(name2, value2);
        return value2;
    }

    public static IRubyObject[] anewarrayIRubyObjects(int size2) {
        return new IRubyObject[size2];
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, int start2) {
        ary[start2] = one;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        ary[start2 + 5] = six;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        ary[start2 + 5] = six;
        ary[start2 + 6] = seven;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        ary[start2 + 5] = six;
        ary[start2 + 6] = seven;
        ary[start2 + 7] = eight;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        ary[start2 + 5] = six;
        ary[start2 + 6] = seven;
        ary[start2 + 7] = eight;
        ary[start2 + 8] = nine;
        return ary;
    }

    public static IRubyObject[] aastoreIRubyObjects(IRubyObject[] ary, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, IRubyObject ten, int start2) {
        ary[start2] = one;
        ary[start2 + 1] = two;
        ary[start2 + 2] = three;
        ary[start2 + 3] = four;
        ary[start2 + 4] = five;
        ary[start2 + 5] = six;
        ary[start2 + 6] = seven;
        ary[start2 + 7] = eight;
        ary[start2 + 8] = nine;
        ary[start2 + 9] = ten;
        return ary;
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one) {
        return new IRubyObject[]{one};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two) {
        return new IRubyObject[]{one, two};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three) {
        return new IRubyObject[]{one, two, three};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four) {
        return new IRubyObject[]{one, two, three, four};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five) {
        return new IRubyObject[]{one, two, three, four, five};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six) {
        return new IRubyObject[]{one, two, three, four, five, six};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven) {
        return new IRubyObject[]{one, two, three, four, five, six, seven};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight) {
        return new IRubyObject[]{one, two, three, four, five, six, seven, eight};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine) {
        return new IRubyObject[]{one, two, three, four, five, six, seven, eight, nine};
    }

    public static IRubyObject[] constructObjectArray(IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, IRubyObject ten) {
        return new IRubyObject[]{one, two, three, four, five, six, seven, eight, nine, ten};
    }

    public static RubyArray constructRubyArray(Ruby runtime2, IRubyObject one) {
        return RubyArray.newArrayLight(runtime2, one);
    }

    public static RubyArray constructRubyArray(Ruby runtime2, IRubyObject one, IRubyObject two) {
        return RubyArray.newArrayLight(runtime2, one, two);
    }

    public static RubyArray constructRubyArray(Ruby runtime2, IRubyObject one, IRubyObject two, IRubyObject three) {
        return RubyArray.newArrayLight(runtime2, one, two, three);
    }

    public static RubyArray constructRubyArray(Ruby runtime2, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four) {
        return RubyArray.newArrayLight(runtime2, one, two, three, four);
    }

    public static RubyArray constructRubyArray(Ruby runtime2, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five) {
        return RubyArray.newArrayLight(runtime2, one, two, three, four, five);
    }

    public static RubyArray constructRubyArray(Ruby runtime2, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six) {
        return RubyArray.newArrayLight(runtime2, one, two, three, four, five, six);
    }

    public static RubyArray constructRubyArray(Ruby runtime2, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven) {
        return RubyArray.newArrayLight(runtime2, one, two, three, four, five, six, seven);
    }

    public static RubyArray constructRubyArray(Ruby runtime2, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight) {
        return RubyArray.newArrayLight(runtime2, one, two, three, four, five, six, seven, eight);
    }

    public static RubyArray constructRubyArray(Ruby runtime2, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine) {
        return RubyArray.newArrayLight(runtime2, one, two, three, four, five, six, seven, eight, nine);
    }

    public static RubyArray constructRubyArray(Ruby runtime2, IRubyObject one, IRubyObject two, IRubyObject three, IRubyObject four, IRubyObject five, IRubyObject six, IRubyObject seven, IRubyObject eight, IRubyObject nine, IRubyObject ten) {
        return RubyArray.newArrayLight(runtime2, one, two, three, four, five, six, seven, eight, nine, ten);
    }

    public static String[] constructStringArray(String one) {
        return new String[]{one};
    }

    public static String[] constructStringArray(String one, String two) {
        return new String[]{one, two};
    }

    public static String[] constructStringArray(String one, String two, String three) {
        return new String[]{one, two, three};
    }

    public static String[] constructStringArray(String one, String two, String three, String four) {
        return new String[]{one, two, three, four};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five) {
        return new String[]{one, two, three, four, five};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six) {
        return new String[]{one, two, three, four, five, six};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven) {
        return new String[]{one, two, three, four, five, six, seven};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight) {
        return new String[]{one, two, three, four, five, six, seven, eight};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight, String nine) {
        return new String[]{one, two, three, four, five, six, seven, eight, nine};
    }

    public static String[] constructStringArray(String one, String two, String three, String four, String five, String six, String seven, String eight, String nine, String ten) {
        return new String[]{one, two, three, four, five, six, seven, eight, nine, ten};
    }

    public static RubyHash constructHash(Ruby runtime2, IRubyObject key1, IRubyObject value1, boolean prepareString1) {
        RubyHash hash2 = RubyHash.newHash(runtime2);
        hash2.fastASet(runtime2, key1, value1, prepareString1);
        return hash2;
    }

    public static RubyHash constructHash(Ruby runtime2, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2) {
        RubyHash hash2 = RubyHash.newHash(runtime2);
        hash2.fastASet(runtime2, key1, value1, prepareString1);
        hash2.fastASet(runtime2, key2, value2, prepareString2);
        return hash2;
    }

    public static RubyHash constructHash(Ruby runtime2, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3) {
        RubyHash hash2 = RubyHash.newHash(runtime2);
        hash2.fastASet(runtime2, key1, value1, prepareString1);
        hash2.fastASet(runtime2, key2, value2, prepareString2);
        hash2.fastASet(runtime2, key3, value3, prepareString3);
        return hash2;
    }

    public static RubyHash constructHash(Ruby runtime2, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3, IRubyObject key4, IRubyObject value4, boolean prepareString4) {
        RubyHash hash2 = RubyHash.newHash(runtime2);
        hash2.fastASet(runtime2, key1, value1, prepareString1);
        hash2.fastASet(runtime2, key2, value2, prepareString2);
        hash2.fastASet(runtime2, key3, value3, prepareString3);
        hash2.fastASet(runtime2, key4, value4, prepareString4);
        return hash2;
    }

    public static RubyHash constructHash(Ruby runtime2, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3, IRubyObject key4, IRubyObject value4, boolean prepareString4, IRubyObject key5, IRubyObject value5, boolean prepareString5) {
        RubyHash hash2 = RubyHash.newHash(runtime2);
        hash2.fastASet(runtime2, key1, value1, prepareString1);
        hash2.fastASet(runtime2, key2, value2, prepareString2);
        hash2.fastASet(runtime2, key3, value3, prepareString3);
        hash2.fastASet(runtime2, key4, value4, prepareString4);
        hash2.fastASet(runtime2, key5, value5, prepareString5);
        return hash2;
    }

    public static RubyHash constructSmallHash(Ruby runtime2, IRubyObject key1, IRubyObject value1, boolean prepareString1) {
        RubyHash hash2 = RubyHash.newSmallHash(runtime2);
        hash2.fastASetSmall(runtime2, key1, value1, prepareString1);
        return hash2;
    }

    public static RubyHash constructSmallHash(Ruby runtime2, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2) {
        RubyHash hash2 = RubyHash.newSmallHash(runtime2);
        hash2.fastASetSmall(runtime2, key1, value1, prepareString1);
        hash2.fastASetSmall(runtime2, key2, value2, prepareString2);
        return hash2;
    }

    public static RubyHash constructSmallHash(Ruby runtime2, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3) {
        RubyHash hash2 = RubyHash.newSmallHash(runtime2);
        hash2.fastASetSmall(runtime2, key1, value1, prepareString1);
        hash2.fastASetSmall(runtime2, key2, value2, prepareString2);
        hash2.fastASetSmall(runtime2, key3, value3, prepareString3);
        return hash2;
    }

    public static RubyHash constructSmallHash(Ruby runtime2, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3, IRubyObject key4, IRubyObject value4, boolean prepareString4) {
        RubyHash hash2 = RubyHash.newSmallHash(runtime2);
        hash2.fastASetSmall(runtime2, key1, value1, prepareString1);
        hash2.fastASetSmall(runtime2, key2, value2, prepareString2);
        hash2.fastASetSmall(runtime2, key3, value3, prepareString3);
        hash2.fastASetSmall(runtime2, key4, value4, prepareString4);
        return hash2;
    }

    public static RubyHash constructSmallHash(Ruby runtime2, IRubyObject key1, IRubyObject value1, boolean prepareString1, IRubyObject key2, IRubyObject value2, boolean prepareString2, IRubyObject key3, IRubyObject value3, boolean prepareString3, IRubyObject key4, IRubyObject value4, boolean prepareString4, IRubyObject key5, IRubyObject value5, boolean prepareString5) {
        RubyHash hash2 = RubyHash.newSmallHash(runtime2);
        hash2.fastASetSmall(runtime2, key1, value1, prepareString1);
        hash2.fastASetSmall(runtime2, key2, value2, prepareString2);
        hash2.fastASetSmall(runtime2, key3, value3, prepareString3);
        hash2.fastASetSmall(runtime2, key4, value4, prepareString4);
        hash2.fastASetSmall(runtime2, key5, value5, prepareString5);
        return hash2;
    }

    public static IRubyObject negate(IRubyObject value2, Ruby runtime2) {
        if (value2.isTrue()) {
            return runtime2.getFalse();
        }
        return runtime2.getTrue();
    }

    @Deprecated
    public static IRubyObject stringOrNil(ByteList value2, ThreadContext context) {
        if (value2 == null) {
            return context.nil;
        }
        return RubyString.newStringShared(context.runtime, value2);
    }

    public static StaticScope preLoad(ThreadContext context, String[] varNames) {
        StaticScope staticScope = context.runtime.getStaticScopeFactory().newLocalScope(null, varNames);
        Helpers.preLoadCommon(context, staticScope, false);
        return staticScope;
    }

    public static void preLoadCommon(ThreadContext context, StaticScope staticScope, boolean wrap2) {
        RubyModule objectClass = context.runtime.getObject();
        if (wrap2) {
            objectClass = RubyModule.newModule(context.runtime);
        }
        staticScope.setModule(objectClass);
        DynamicScope scope = DynamicScope.newDynamicScope(staticScope);
        context.preScopedBody(scope);
        context.preNodeEval(context.runtime.getTopSelf());
    }

    public static void postLoad(ThreadContext context) {
        context.postNodeEval();
        context.postScopedBody();
    }

    @Deprecated
    public static void registerEndBlock(Block block, Ruby runtime2) {
        runtime2.pushExitBlock(runtime2.newProc(Block.Type.LAMBDA, block));
    }

    @Deprecated
    public static IRubyObject match3(RubyRegexp regexp2, IRubyObject value2, ThreadContext context) {
        if (value2 instanceof RubyString) {
            return regexp2.op_match(context, value2);
        }
        return value2.callMethod(context, "=~", regexp2);
    }

    @Deprecated
    public static IRubyObject getErrorInfo(Ruby runtime2) {
        return runtime2.getCurrentContext().getErrorInfo();
    }

    @Deprecated
    public static void setErrorInfo(Ruby runtime2, IRubyObject error2) {
        runtime2.getCurrentContext().setErrorInfo(error2);
    }

    public static IRubyObject setLastLine(Ruby runtime2, ThreadContext context, IRubyObject value2) {
        return context.setLastLine(value2);
    }

    public static IRubyObject getLastLine(Ruby runtime2, ThreadContext context) {
        return context.getLastLine();
    }

    public static IRubyObject setBackref(Ruby runtime2, ThreadContext context, IRubyObject value2) {
        if (!value2.isNil() && !(value2 instanceof RubyMatchData)) {
            throw runtime2.newTypeError(value2, runtime2.getMatchData());
        }
        return context.setBackRef(value2);
    }

    public static IRubyObject getBackref(Ruby runtime2, ThreadContext context) {
        return Helpers.backref(context);
    }

    public static RubyArray arrayValue(IRubyObject value2) {
        Ruby runtime2 = value2.getRuntime();
        return Helpers.arrayValue(runtime2.getCurrentContext(), runtime2, value2);
    }

    public static RubyArray arrayValue(ThreadContext context, Ruby runtime2, IRubyObject value2) {
        IRubyObject tmp = value2.checkArrayType();
        if (tmp.isNil()) {
            if (value2.respondsTo("to_a")) {
                IRubyObject avalue = value2.callMethod(context, "to_a");
                if (!(avalue instanceof RubyArray)) {
                    if (avalue.isNil()) {
                        return runtime2.newArray(value2);
                    }
                    throw runtime2.newTypeError("`to_a' did not return Array");
                }
                return (RubyArray)avalue;
            }
            CacheEntry entry = value2.getMetaClass().searchWithCache("method_missing");
            DynamicMethod methodMissing = entry.method;
            if (methodMissing.isUndefined() || runtime2.isDefaultMethodMissing(methodMissing)) {
                return runtime2.newArray(value2);
            }
            IRubyObject avalue = methodMissing.call(context, value2, entry.sourceModule, "to_a", new IRubyObject[]{runtime2.newSymbol("to_a")}, Block.NULL_BLOCK);
            if (!(avalue instanceof RubyArray)) {
                if (avalue.isNil()) {
                    return runtime2.newArray(value2);
                }
                throw runtime2.newTypeError("`to_a' did not return Array");
            }
            return (RubyArray)avalue;
        }
        RubyArray arr = (RubyArray)tmp;
        return arr.aryDup();
    }

    @Deprecated
    public static RubyArray asArray(ThreadContext context, IRubyObject value2) {
        return TypeConverter.rb_Array(context, value2);
    }

    @Deprecated
    public static IRubyObject aryToAry(IRubyObject value2) {
        return Helpers.aryToAry(value2.getRuntime().getCurrentContext(), value2);
    }

    public static IRubyObject aryToAry(ThreadContext context, IRubyObject value2) {
        if (value2 instanceof RubyArray) {
            return value2;
        }
        if (value2.respondsTo("to_ary")) {
            return TypeConverter.convertToType(context, value2, context.runtime.getArray(), "to_ary", false);
        }
        return context.runtime.newArray(value2);
    }

    public static IRubyObject aryOrToAry(ThreadContext context, IRubyObject value2) {
        if (value2 instanceof RubyArray) {
            return value2;
        }
        if (value2.respondsTo("to_ary")) {
            return TypeConverter.convertToType(context, value2, context.runtime.getArray(), "to_ary", false);
        }
        return context.nil;
    }

    @Deprecated
    public static IRubyObject aValueSplat(IRubyObject value2) {
        if (!(value2 instanceof RubyArray) || ((RubyArray)value2).length().getLongValue() == 0L) {
            return value2.getRuntime().getNil();
        }
        RubyArray array2 = (RubyArray)value2;
        return array2.getLength() == 1 ? array2.first() : array2;
    }

    @Deprecated
    public static IRubyObject aValueSplat19(IRubyObject value2) {
        if (!(value2 instanceof RubyArray)) {
            return value2.getRuntime().getNil();
        }
        return (RubyArray)value2;
    }

    @Deprecated
    public static RubyArray splatValue(IRubyObject value2) {
        if (value2.isNil()) {
            return value2.getRuntime().newArray(value2);
        }
        return Helpers.arrayValue(value2);
    }

    @Deprecated
    public static RubyArray splatValue19(IRubyObject value2) {
        if (value2.isNil()) {
            return value2.getRuntime().newEmptyArray();
        }
        return Helpers.arrayValue(value2);
    }

    @Deprecated
    public static IRubyObject unsplatValue19(IRubyObject argsResult) {
        Object newResult;
        RubyArray array2;
        if (argsResult instanceof RubyArray && (array2 = (RubyArray)argsResult).size() == 1 && (!((newResult = array2.eltInternal(0)) instanceof RubyArray) || ((RubyArray)newResult).size() != 0)) {
            argsResult = newResult;
        }
        return argsResult;
    }

    @Deprecated
    public static IRubyObject[] splatToArguments(IRubyObject value2) {
        if (value2.isNil()) {
            return value2.getRuntime().getSingleNilArray();
        }
        IRubyObject tmp = value2.checkArrayType();
        if (tmp.isNil()) {
            return Helpers.convertSplatToJavaArray(value2.getRuntime(), value2);
        }
        return ((RubyArray)tmp).toJavaArrayMaybeUnsafe();
    }

    private static IRubyObject[] convertSplatToJavaArray(Ruby runtime2, IRubyObject value2) {
        RubyClass metaClass = value2.getMetaClass();
        CacheEntry entry = metaClass.searchWithCache("to_a");
        DynamicMethod method2 = entry.method;
        if (method2.isUndefined() || method2.isImplementedBy(runtime2.getKernel())) {
            return new IRubyObject[]{value2};
        }
        IRubyObject avalue = method2.call(runtime2.getCurrentContext(), value2, entry.sourceModule, "to_a");
        if (!(avalue instanceof RubyArray)) {
            if (avalue.isNil()) {
                return new IRubyObject[]{value2};
            }
            throw runtime2.newTypeError("`to_a' did not return Array");
        }
        return ((RubyArray)avalue).toJavaArray();
    }

    @Deprecated
    public static IRubyObject[] argsCatToArguments(IRubyObject[] args2, IRubyObject cat) {
        IRubyObject[] ary = Helpers.splatToArguments(cat);
        if (ary.length > 0) {
            IRubyObject[] newArgs = new IRubyObject[args2.length + ary.length];
            System.arraycopy(args2, 0, newArgs, 0, args2.length);
            System.arraycopy(ary, 0, newArgs, args2.length, ary.length);
            return newArgs;
        }
        return args2;
    }

    @Deprecated
    public static RubySymbol addInstanceMethod(RubyModule containingClass, String name2, DynamicMethod method2, Visibility visibility, ThreadContext context, Ruby runtime2) {
        return Helpers.addInstanceMethod(containingClass, runtime2.fastNewSymbol(name2), method2, visibility, context, runtime2);
    }

    public static RubySymbol addInstanceMethod(RubyModule containingClass, RubySymbol symbol, DynamicMethod method2, Visibility visibility, ThreadContext context, Ruby runtime2) {
        containingClass.addMethod(symbol.idString(), method2);
        if (!containingClass.isRefinement()) {
            Helpers.callNormalMethodHook(containingClass, context, symbol);
        }
        if (visibility == Visibility.MODULE_FUNCTION) {
            Helpers.addModuleMethod(containingClass, method2, context, symbol);
        }
        return symbol;
    }

    private static void addModuleMethod(RubyModule containingClass, DynamicMethod method2, ThreadContext context, RubySymbol sym) {
        DynamicMethod singletonMethod = method2.dup();
        singletonMethod.setImplementationClass(containingClass.getSingletonClass());
        singletonMethod.setVisibility(Visibility.PUBLIC);
        containingClass.getSingletonClass().addMethod(sym.idString(), singletonMethod);
        containingClass.callMethod(context, "singleton_method_added", (IRubyObject)sym);
    }

    private static void callNormalMethodHook(RubyModule containingClass, ThreadContext context, RubySymbol name2) {
        if (containingClass.isSingleton()) {
            Helpers.callSingletonMethodHook(((MetaClass)containingClass).getAttached(), context, name2);
        } else {
            containingClass.callMethod(context, "method_added", (IRubyObject)name2);
        }
    }

    private static void callSingletonMethodHook(RubyBasicObject receiver2, ThreadContext context, RubySymbol name2) {
        receiver2.callMethod(context, "singleton_method_added", (IRubyObject)name2);
    }

    static String encodeScope(StaticScope scope) {
        StringBuilder namesBuilder = new StringBuilder(scope.getType().name());
        namesBuilder.append(',');
        boolean first2 = true;
        for (String name2 : scope.getVariables()) {
            if (!first2) {
                namesBuilder.append(';');
            }
            first2 = false;
            namesBuilder.append(name2);
        }
        namesBuilder.append(',').append(scope.getSignature().encode());
        namesBuilder.append(',').append((Object)scope.getScopeType());
        return namesBuilder.toString();
    }

    static StaticScope decodeScope(ThreadContext context, StaticScope parent, String scopeString) {
        String[][] decodedScope = Helpers.decodeScopeDescriptor(scopeString);
        String scopeTypeName = decodedScope[0][0];
        String[] names2 = decodedScope[1];
        StaticScope scope = null;
        switch (StaticScope.Type.valueOf(scopeTypeName)) {
            case BLOCK: {
                scope = context.runtime.getStaticScopeFactory().newBlockScope(parent, names2);
                break;
            }
            case EVAL: {
                scope = context.runtime.getStaticScopeFactory().newEvalScope(parent, names2);
                break;
            }
            case LOCAL: {
                scope = context.runtime.getStaticScopeFactory().newLocalScope(parent, names2);
            }
        }
        Helpers.setAritiesFromDecodedScope(scope, decodedScope[0][2]);
        scope.setScopeType(IRScopeType.valueOf(decodedScope[0][3]));
        return scope;
    }

    private static String[][] decodeScopeDescriptor(String scopeString) {
        String[] scopeElements = scopeString.split(",");
        String[] scopeNames = scopeElements[1].length() == 0 ? StringSupport.EMPTY_STRING_ARRAY : Helpers.getScopeNames(scopeElements[1]);
        return new String[][]{scopeElements, scopeNames};
    }

    private static void setAritiesFromDecodedScope(StaticScope scope, String encodedSignature) {
        scope.setSignature(Signature.decode(Long.parseLong(encodedSignature)));
    }

    public static StaticScope decodeScopeAndDetermineModule(ThreadContext context, StaticScope parent, String scopeString) {
        StaticScope scope = Helpers.decodeScope(context, parent, scopeString);
        scope.determineModule();
        return scope;
    }

    public static Visibility performNormalMethodChecksAndDetermineVisibility(Ruby runtime2, RubyModule clazz, RubySymbol symbol, Visibility visibility) throws RaiseException {
        String name2 = symbol.asJavaString();
        if (clazz == runtime2.getDummy()) {
            throw runtime2.newTypeError("no class/module to add method");
        }
        if (clazz == runtime2.getObject() && "initialize".equals(name2)) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, "redefining Object#initialize may cause infinite loop");
        }
        if ("__id__".equals(name2) || "__send__".equals(name2)) {
            runtime2.getWarnings().warn(IRubyWarnings.ID.REDEFINING_DANGEROUS, RubyStringBuilder.str(runtime2, "redefining `", RubyStringBuilder.ids(runtime2, symbol), "' may cause serious problem"));
        }
        if ("initialize".equals(name2) || "initialize_copy".equals(name2) || name2.equals("initialize_dup") || name2.equals("initialize_clone") || name2.equals("respond_to_missing?") || visibility == Visibility.MODULE_FUNCTION) {
            visibility = Visibility.PRIVATE;
        }
        return visibility;
    }

    public static RubyClass performSingletonMethodChecks(Ruby runtime2, IRubyObject receiver2, String name2) throws RaiseException {
        if (receiver2 instanceof RubyFixnum || receiver2 instanceof RubySymbol) {
            throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, "can't define singleton method \"", RubyStringBuilder.ids(runtime2, name2), "\" for ", RubyStringBuilder.types(runtime2, receiver2.getMetaClass())));
        }
        if (receiver2.isFrozen()) {
            throw runtime2.newFrozenError("object");
        }
        RubyClass rubyClass = receiver2.getSingletonClass();
        return rubyClass;
    }

    @Deprecated
    public static IRubyObject arrayEntryOrNil(RubyArray array2, int index2) {
        if (index2 < array2.getLength()) {
            return array2.eltInternal(index2);
        }
        return array2.getRuntime().getNil();
    }

    @Deprecated
    public static IRubyObject arrayEntryOrNilZero(RubyArray array2) {
        if (0 < array2.getLength()) {
            return array2.eltInternal(0);
        }
        return array2.getRuntime().getNil();
    }

    @Deprecated
    public static IRubyObject arrayEntryOrNilOne(RubyArray array2) {
        if (1 < array2.getLength()) {
            return array2.eltInternal(1);
        }
        return array2.getRuntime().getNil();
    }

    @Deprecated
    public static IRubyObject arrayEntryOrNilTwo(RubyArray array2) {
        if (2 < array2.getLength()) {
            return array2.eltInternal(2);
        }
        return array2.getRuntime().getNil();
    }

    @Deprecated
    public static IRubyObject arrayPostOrNil(RubyArray array2, int pre, int post, int index2) {
        if (pre + post < array2.getLength()) {
            return array2.eltInternal(array2.getLength() - post + index2);
        }
        if (pre + index2 < array2.getLength()) {
            return array2.eltInternal(pre + index2);
        }
        return array2.getRuntime().getNil();
    }

    @Deprecated
    public static IRubyObject arrayPostOrNilZero(RubyArray array2, int pre, int post) {
        if (pre + post < array2.getLength()) {
            return array2.eltInternal(array2.getLength() - post + 0);
        }
        if (pre + 0 < array2.getLength()) {
            return array2.eltInternal(pre + 0);
        }
        return array2.getRuntime().getNil();
    }

    @Deprecated
    public static IRubyObject arrayPostOrNilOne(RubyArray array2, int pre, int post) {
        if (pre + post < array2.getLength()) {
            return array2.eltInternal(array2.getLength() - post + 1);
        }
        if (pre + 1 < array2.getLength()) {
            return array2.eltInternal(pre + 1);
        }
        return array2.getRuntime().getNil();
    }

    @Deprecated
    public static IRubyObject arrayPostOrNilTwo(RubyArray array2, int pre, int post) {
        if (pre + post < array2.getLength()) {
            return array2.eltInternal(array2.getLength() - post + 2);
        }
        if (pre + 2 < array2.getLength()) {
            return array2.eltInternal(pre + 2);
        }
        return array2.getRuntime().getNil();
    }

    @Deprecated
    public static RubyArray subarrayOrEmpty(RubyArray array2, Ruby runtime2, int index2) {
        if (index2 < array2.getLength()) {
            return Helpers.createSubarray(array2, index2);
        }
        return RubyArray.newEmptyArray(runtime2);
    }

    @Deprecated
    public static RubyArray subarrayOrEmpty(RubyArray array2, Ruby runtime2, int index2, int post) {
        if (index2 + post < array2.getLength()) {
            return Helpers.createSubarray(array2, index2, post);
        }
        return RubyArray.newEmptyArray(runtime2);
    }

    public static RubyModule checkIsModule(IRubyObject maybeModule) {
        if (maybeModule instanceof RubyModule) {
            return (RubyModule)maybeModule;
        }
        Ruby runtime2 = maybeModule.getRuntime();
        throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, RubyStringBuilder.ids(runtime2, maybeModule), " is not a class/module"));
    }

    public static IRubyObject getGlobalVariable(Ruby runtime2, String name2) {
        return runtime2.getGlobalVariables().get(name2);
    }

    public static IRubyObject setGlobalVariable(IRubyObject value2, Ruby runtime2, String name2) {
        return runtime2.getGlobalVariables().set(name2, value2);
    }

    public static IRubyObject getInstanceVariable(IRubyObject self2, Ruby runtime2, String internedName) {
        IRubyObject result2 = self2.getInstanceVariables().getInstanceVariable(internedName);
        if (result2 != null) {
            return result2;
        }
        if (runtime2.isVerbose()) {
            Helpers.warnAboutUninitializedIvar(runtime2, internedName);
        }
        return runtime2.getNil();
    }

    public static IRubyObject getInstanceVariableNoWarn(IRubyObject self2, ThreadContext context, String internedName) {
        IRubyObject result2 = self2.getInstanceVariables().getInstanceVariable(internedName);
        if (result2 != null) {
            return result2;
        }
        return context.nil;
    }

    private static void warnAboutUninitializedIvar(Ruby runtime2, String id2) {
        runtime2.getWarnings().warning(IRubyWarnings.ID.IVAR_NOT_INITIALIZED, RubyStringBuilder.str(runtime2, "instance variable ", RubyStringBuilder.ids(runtime2, id2), " not initialized"));
    }

    public static IRubyObject setInstanceVariable(IRubyObject value2, IRubyObject self2, String name2) {
        return self2.getInstanceVariables().setInstanceVariable(name2, value2);
    }

    public static RubyProc newLiteralLambda(ThreadContext context, Block block, IRubyObject self2) {
        return RubyProc.newProc(context.runtime, block, Block.Type.LAMBDA);
    }

    public static void fillNil(IRubyObject[] arr, int from, int to, Ruby runtime2) {
        if (arr.length == 0) {
            return;
        }
        Object[] nils = runtime2.getNilPrefilledArray();
        int i2 = from;
        while (i2 + 128 < to) {
            System.arraycopy(nils, 0, arr, i2, 128);
            i2 += 128;
        }
        ArraySupport.copy(nils, arr, i2, to - i2);
    }

    public static void fillNil(IRubyObject[] arr, Ruby runtime2) {
        Helpers.fillNil(arr, 0, arr.length, runtime2);
    }

    public static Block getBlock(ThreadContext context, IRubyObject self2, Node node) {
        throw new RuntimeException("Should not be called");
    }

    public static Block getBlock(Ruby runtime2, ThreadContext context, IRubyObject self2, Node node, Block aBlock) {
        throw new RuntimeException("Should not be called");
    }

    public static RubyBoolean rbEqual(ThreadContext context, IRubyObject a, IRubyObject b2) {
        if (a == b2) {
            return context.tru;
        }
        IRubyObject res = Helpers.sites((ThreadContext)context).op_equal.call(context, a, a, b2);
        return RubyBoolean.newBoolean(context, res.isTrue());
    }

    public static RubyBoolean rbEqual(ThreadContext context, IRubyObject a, IRubyObject b2, CallSite equal) {
        if (a == b2) {
            return context.tru;
        }
        IRubyObject res = equal.call(context, a, a, b2);
        return RubyBoolean.newBoolean(context, res.isTrue());
    }

    public static RubyBoolean rbEql(ThreadContext context, IRubyObject a, IRubyObject b2) {
        if (a == b2) {
            return context.tru;
        }
        IRubyObject res = Helpers.invokedynamic(context, a, MethodNames.EQL, b2);
        return RubyBoolean.newBoolean(context, res.isTrue());
    }

    public static void checkArgumentCount(ThreadContext context, IRubyObject[] args2, int min2, int max2) {
        Helpers.checkArgumentCount(context, args2.length, min2, max2);
    }

    public static void checkArgumentCount(ThreadContext context, IRubyObject[] args2, int req) {
        Helpers.checkArgumentCount(context, args2.length, req, req);
    }

    public static void checkArgumentCount(ThreadContext context, int length2, int min2, int max2) {
        int expected = 0;
        if (length2 < min2) {
            expected = min2;
        } else if (max2 > -1 && length2 > max2) {
            expected = max2;
        } else {
            return;
        }
        throw context.runtime.newArgumentError(length2, expected);
    }

    public static boolean isModuleAndHasConstant(IRubyObject left2, String name2) {
        return left2 instanceof RubyModule && ((RubyModule)left2).getConstantFromNoConstMissing(name2, false) != null;
    }

    @JIT
    @Interp
    public static IRubyObject getDefinedConstantOrBoundMethod(IRubyObject left2, String name2, IRubyObject definedConstantMessage, IRubyObject definedMethodMessage) {
        if (Helpers.isModuleAndHasConstant(left2, name2)) {
            return definedConstantMessage;
        }
        if (left2.getMetaClass().isMethodBound(name2, true)) {
            return definedMethodMessage;
        }
        return null;
    }

    public static RubyModule getSuperClassForDefined(Ruby runtime2, RubyModule klazz) {
        RubyClass superklazz = klazz.getSuperClass();
        if (superklazz == null && klazz.isModule()) {
            superklazz = runtime2.getObject();
        }
        return superklazz;
    }

    public static String[] getScopeNames(String scopeNames) {
        StringTokenizer toker = new StringTokenizer(scopeNames, ";");
        ArrayList<String> list2 = new ArrayList<String>(10);
        while (toker.hasMoreTokens()) {
            list2.add(toker.nextToken().intern());
        }
        return list2.toArray(new String[list2.size()]);
    }

    public static RubyClass metaclass(IRubyObject object) {
        return object instanceof RubyBasicObject ? ((RubyBasicObject)object).getMetaClass() : object.getMetaClass();
    }

    public static String rawBytesToString(byte[] bytes2) {
        char[] chars2 = new char[bytes2.length];
        for (int i2 = 0; i2 < bytes2.length; ++i2) {
            chars2[i2] = (char)bytes2[i2];
        }
        return new String(chars2);
    }

    public static byte[] stringToRawBytes(String string2) {
        char[] chars2 = string2.toCharArray();
        byte[] bytes2 = new byte[chars2.length];
        for (int i2 = 0; i2 < chars2.length; ++i2) {
            bytes2[i2] = (byte)chars2[i2];
        }
        return bytes2;
    }

    public static String encodeCaptureOffsets(int[] scopeOffsets) {
        char[] encoded = new char[scopeOffsets.length * 2];
        for (int i2 = 0; i2 < scopeOffsets.length; ++i2) {
            int offDepth = scopeOffsets[i2];
            char off = (char)(offDepth & 0xFFFF);
            char depth = (char)(offDepth >> 16);
            encoded[2 * i2] = off;
            encoded[2 * i2 + 1] = depth;
        }
        return new String(encoded);
    }

    public static int[] decodeCaptureOffsets(String encoded) {
        char[] chars2 = encoded.toCharArray();
        int[] scopeOffsets = new int[chars2.length / 2];
        for (int i2 = 0; i2 < scopeOffsets.length; ++i2) {
            char off = chars2[2 * i2];
            char depth = chars2[2 * i2 + 1];
            scopeOffsets[i2] = depth << 16 | off;
        }
        return scopeOffsets;
    }

    @Deprecated
    public static IRubyObject match2AndUpdateScope(IRubyObject receiver2, ThreadContext context, IRubyObject value2, String scopeOffsets) {
        IRubyObject match2 = ((RubyRegexp)receiver2).op_match(context, value2);
        Helpers.updateScopeWithCaptures(context, Helpers.decodeCaptureOffsets(scopeOffsets), match2);
        return match2;
    }

    public static void updateScopeWithCaptures(ThreadContext context, int[] scopeOffsets, IRubyObject result2) {
        Ruby runtime2 = context.runtime;
        if (result2.isNil()) {
            IRubyObject nil = runtime2.getNil();
            for (int i2 = 0; i2 < scopeOffsets.length; ++i2) {
                context.getCurrentScope().setValue(nil, scopeOffsets[i2], 0);
            }
        } else {
            RubyMatchData matchData = (RubyMatchData)context.getBackRef();
            IRubyObject[] namedValues = matchData.getNamedBackrefValues(runtime2);
            for (int i3 = 0; i3 < scopeOffsets.length; ++i3) {
                context.getCurrentScope().setValue(namedValues[i3], scopeOffsets[i3] & 0xFFFF, scopeOffsets[i3] >> 16);
            }
        }
    }

    @Deprecated
    public static RubyArray argsPush(ThreadContext context, RubyArray first2, IRubyObject second2) {
        return ((RubyArray)first2.dup()).append(second2);
    }

    @JIT
    public static RubyArray argsPush(IRubyObject first2, IRubyObject second2) {
        return ((RubyArray)first2.dup()).append(second2);
    }

    public static RubyArray argsCat(ThreadContext context, IRubyObject first2, IRubyObject second2) {
        RubyArray secondArgs = IRRuntimeHelpers.irSplat(context, second2);
        return ((RubyArray)Helpers.ensureRubyArray(context.runtime, first2).dup()).concat(secondArgs);
    }

    @Deprecated
    public static RubyArray argsCat(IRubyObject first2, IRubyObject second2) {
        return Helpers.argsCat(first2.getRuntime().getCurrentContext(), first2, second2);
    }

    public static ArgumentDescriptor[] argsNodeToArgumentDescriptors(ArgsNode argsNode) {
        int keywordsCount;
        int postCount;
        RestArgNode restArg;
        int optCount;
        ArrayList<ArgumentDescriptor> descs = new ArrayList<ArgumentDescriptor>();
        Node[] args2 = argsNode.getArgs();
        int preCount = argsNode.getPreCount();
        if (preCount > 0) {
            for (int i2 = 0; i2 < preCount; ++i2) {
                if (args2[i2] instanceof MultipleAsgnNode) {
                    descs.add(new ArgumentDescriptor(ArgumentType.anonreq));
                    continue;
                }
                descs.add(new ArgumentDescriptor(ArgumentType.req, ((ArgumentNode)args2[i2]).getName()));
            }
        }
        if ((optCount = argsNode.getOptionalArgsCount()) > 0) {
            int optIndex = argsNode.getOptArgIndex();
            for (int i3 = 0; i3 < optCount; ++i3) {
                Node optNode = args2[optIndex + i3];
                if (optNode instanceof INameNode) {
                    descs.add(new ArgumentDescriptor(ArgumentType.opt, ((INameNode)((Object)optNode)).getName()));
                    continue;
                }
                descs.add(new ArgumentDescriptor(ArgumentType.anonopt));
            }
        }
        if ((restArg = argsNode.getRestArgNode()) != null) {
            if (restArg instanceof UnnamedRestArgNode) {
                if (((UnnamedRestArgNode)restArg).isStar()) {
                    descs.add(new ArgumentDescriptor(ArgumentType.anonrest));
                }
            } else {
                descs.add(new ArgumentDescriptor(ArgumentType.rest, restArg.getName()));
            }
        }
        if ((postCount = argsNode.getPostCount()) > 0) {
            int postIndex = argsNode.getPostIndex();
            for (int i4 = 0; i4 < postCount; ++i4) {
                Node postNode = args2[postIndex + i4];
                if (postNode instanceof MultipleAsgnNode) {
                    descs.add(new ArgumentDescriptor(ArgumentType.anonreq));
                    continue;
                }
                descs.add(new ArgumentDescriptor(ArgumentType.req, ((ArgumentNode)postNode).getName()));
            }
        }
        if ((keywordsCount = argsNode.getKeywordCount()) > 0) {
            int keywordsIndex = argsNode.getKeywordsIndex();
            for (int i5 = 0; i5 < keywordsCount; ++i5) {
                Node keyWordNode = args2[keywordsIndex + i5];
                for (Node asgnNode : keyWordNode.childNodes()) {
                    ArgumentType type2 = Helpers.isRequiredKeywordArgumentValueNode(asgnNode) ? ArgumentType.keyreq : ArgumentType.key;
                    descs.add(new ArgumentDescriptor(type2, ((INameNode)((Object)asgnNode)).getName()));
                }
            }
        }
        if (argsNode.getKeyRest() != null) {
            RubySymbol argName = argsNode.getKeyRest().getName();
            ArgumentType type3 = argName == null || argName.getBytes().length() == 0 ? ArgumentType.anonkeyrest : ArgumentType.keyrest;
            descs.add(new ArgumentDescriptor(type3, argName));
        }
        if (argsNode.getBlock() != null) {
            descs.add(new ArgumentDescriptor(ArgumentType.block, argsNode.getBlock().getName()));
        }
        return descs.toArray(new ArgumentDescriptor[descs.size()]);
    }

    public static ArgumentDescriptor[] parameterListToArgumentDescriptors(Ruby runtime2, String[] parameterList, boolean isLambda) {
        String param;
        ArgumentDescriptor[] parms = new ArgumentDescriptor[parameterList.length];
        for (int i2 = 0; i2 < parameterList.length && !(param = parameterList[i2]).equals("NONE"); ++i2) {
            ArgumentType type2;
            if (param.equals("nil")) {
                param = "n";
            }
            if ((type2 = ArgumentType.valueOf(param.charAt(0))) == ArgumentType.req && !isLambda) {
                type2 = ArgumentType.opt;
            }
            parms[i2] = param.length() > 1 ? new ArgumentDescriptor(type2, runtime2.newSymbol(param.substring(1))) : new ArgumentDescriptor(type2.anonymousForm());
        }
        return parms;
    }

    public static RubyArray argumentDescriptorsToParameters(Ruby runtime2, ArgumentDescriptor[] argsDesc, boolean isLambda) {
        if (argsDesc == null) {
            Thread.dumpStack();
        }
        RubyArray params2 = RubyArray.newBlankArray(runtime2, argsDesc.length);
        for (int i2 = 0; i2 < argsDesc.length; ++i2) {
            ArgumentDescriptor param = argsDesc[i2];
            params2.store(i2, param.toArrayForm(runtime2, isLambda));
        }
        return params2;
    }

    public static ArgumentDescriptor[] methodToArgumentDescriptors(DynamicMethod method2) {
        if ((method2 = method2.getRealMethod()) instanceof MethodArgs2) {
            return Helpers.parameterListToArgumentDescriptors(method2.getImplementationClass().getRuntime(), ((MethodArgs2)((Object)method2)).getParameterList(), true);
        }
        if (method2 instanceof IRMethodArgs) {
            return ((IRMethodArgs)((Object)method2)).getArgumentDescriptors();
        }
        return new ArgumentDescriptor[]{new ArgumentDescriptor(ArgumentType.anonrest)};
    }

    public static IRubyObject methodToParameters(Ruby runtime2, AbstractRubyMethod recv2) {
        DynamicMethod method2 = recv2.getMethod().getRealMethod();
        return Helpers.argumentDescriptorsToParameters(runtime2, Helpers.methodToArgumentDescriptors(method2), true);
    }

    public static IRubyObject getDefinedCall(ThreadContext context, IRubyObject self2, IRubyObject receiver2, String name2, IRubyObject definedMessage) {
        RubyClass metaClass = receiver2.getMetaClass();
        DynamicMethod method2 = metaClass.searchMethod(name2);
        Visibility visibility = method2.getVisibility();
        if (visibility != Visibility.PRIVATE && (visibility != Visibility.PROTECTED || metaClass.getRealClass().isInstance(self2)) && !method2.isUndefined()) {
            return definedMessage;
        }
        if (receiver2.callMethod(context, "respond_to_missing?", new IRubyObject[]{context.runtime.newSymbol(name2), context.fals}).isTrue()) {
            return definedMessage;
        }
        return null;
    }

    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self2, MethodNames method2) {
        RubyClass metaclass = self2.getMetaClass();
        String name2 = method2.realName();
        CacheEntry entry = Helpers.getMethodCached(context, metaclass, method2.ordinal(), name2);
        return entry.method.call(context, self2, entry.sourceModule, name2);
    }

    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self2, MethodNames method2, IRubyObject arg0) {
        RubyClass metaclass = self2.getMetaClass();
        String name2 = method2.realName();
        CacheEntry entry = Helpers.getMethodCached(context, metaclass, method2.ordinal(), name2);
        return entry.method.call(context, self2, entry.sourceModule, name2, arg0);
    }

    private static CacheEntry getMethodCached(ThreadContext context, RubyClass metaclass, int index2, String name2) {
        if (metaclass.getClassIndex() == ClassIndex.NO_INDEX) {
            return metaclass.searchWithCache(name2);
        }
        return context.runtimeCache.getMethodEntry(context, metaclass, metaclass.getClassIndex().ordinal() * (index2 + 1), name2);
    }

    @Deprecated
    public static IRubyObject lastElement(IRubyObject[] ary) {
        return ary[ary.length - 1];
    }

    @Deprecated
    public static RubyString appendAsString(RubyString target, IRubyObject other) {
        return target.append(other.asString());
    }

    static IRubyObject[] restructureBlockArgs(ThreadContext context, IRubyObject value2, Signature signature, Block.Type type2, boolean needsSplat) {
        IRubyObject ary;
        if (!type2.checkArity && signature == Signature.NO_ARGUMENTS) {
            return IRubyObject.NULL_ARRAY;
        }
        if (value2 == null) {
            return IRubyObject.NULL_ARRAY;
        }
        if (needsSplat && (ary = Helpers.aryToAry(context, value2)) instanceof RubyArray) {
            return ((RubyArray)ary).toJavaArrayMaybeUnsafe();
        }
        return new IRubyObject[]{value2};
    }

    @Deprecated
    public static RubyString appendByteList(RubyString target, ByteList source2) {
        target.getByteList().append(source2);
        return target;
    }

    @JIT
    public static boolean BNE(ThreadContext context, IRubyObject value1, IRubyObject value2) {
        boolean eql2 = value2 == context.nil || value2 == UndefinedValue.UNDEFINED ? value1 == value2 : value1.op_equal(context, value2).isTrue();
        return !eql2;
    }

    public static void irCheckArgsArrayArity(ThreadContext context, RubyArray args2, int required, int opt, boolean rest2) {
        int numArgs = args2.size();
        if (numArgs < required || !rest2 && numArgs > required + opt) {
            Arity.raiseArgumentError(context.runtime, numArgs, required, required + opt);
        }
    }

    @Deprecated
    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self2, int index2) {
        return Helpers.invokedynamic(context, self2, MethodNames.values()[index2]);
    }

    @Deprecated
    public static IRubyObject invokedynamic(ThreadContext context, IRubyObject self2, int index2, IRubyObject arg0) {
        return Helpers.invokedynamic(context, self2, MethodNames.values()[index2], arg0);
    }

    public static boolean extractExceptionOnlyArg(ThreadContext context, RubyHash opts) {
        return ArgsUtil.extractKeywordArg(context, opts, "exception") != context.fals;
    }

    public static boolean extractExceptionOnlyArg(ThreadContext context, IRubyObject opts, boolean defValue) {
        IRubyObject hash2 = TypeConverter.checkHashType(context.runtime, opts);
        if (hash2 != context.nil) {
            return Helpers.extractExceptionOnlyArg(context, (RubyHash)opts);
        }
        return defValue;
    }

    public static boolean extractExceptionOnlyArg(ThreadContext context, IRubyObject[] args2, boolean defValue) {
        if (args2.length == 0) {
            return defValue;
        }
        return Helpers.extractExceptionOnlyArg(context, args2[args2.length - 1], defValue);
    }

    public static void throwException(Throwable e) {
        Helpers.throwsUnchecked(e);
    }

    public static <T> T tryThrow(Callable<T> call2) {
        try {
            return call2.call();
        }
        catch (Throwable t) {
            Helpers.throwException(t);
            return null;
        }
    }

    private static <T extends Throwable> void throwsUnchecked(Throwable e) throws T {
        throw e;
    }

    public static String symbolBytesToString(ByteList value2) {
        Encoding encoding2 = value2.getEncoding();
        if (encoding2 == USASCIIEncoding.INSTANCE || encoding2 == ASCIIEncoding.INSTANCE) {
            return value2.toString();
        }
        if (encoding2 instanceof UnicodeEncoding) {
            return new String(value2.getUnsafeBytes(), value2.getBegin(), value2.getRealSize(), EncodingUtils.charsetForEncoding(value2.getEncoding()));
        }
        return value2.toString();
    }

    public static String decodeByteList(Ruby runtime2, ByteList value2) {
        byte[] unsafeBytes = value2.getUnsafeBytes();
        int begin2 = value2.getBegin();
        int length2 = value2.length();
        Encoding encoding2 = value2.getEncoding();
        if (encoding2 == UTF8Encoding.INSTANCE) {
            return RubyEncoding.decodeUTF8(unsafeBytes, begin2, length2);
        }
        Charset charset = runtime2.getEncodingService().charsetForEncoding(encoding2);
        if (charset == null) {
            Encoding utf16 = EncodingUtils.getUTF16ForPlatform();
            return EncodingUtils.strConvEnc(runtime2.getCurrentContext(), value2, value2.getEncoding(), utf16).toString();
        }
        return RubyEncoding.decode(unsafeBytes, begin2, length2, charset);
    }

    public static String byteListToString(ByteList bytes2) {
        Encoding encoding2 = bytes2.getEncoding();
        if (encoding2 == UTF8Encoding.INSTANCE || encoding2 == USASCIIEncoding.INSTANCE) {
            return RubyEncoding.decodeUTF8(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getRealSize());
        }
        Charset charset = EncodingUtils.charsetForEncoding(encoding2);
        if (charset != null) {
            return new String(bytes2.getUnsafeBytes(), bytes2.getBegin(), bytes2.getRealSize(), charset);
        }
        return bytes2.toString();
    }

    public static IRubyObject rewriteStackTraceAndThrow(ThreadContext context, Throwable t) {
        Ruby runtime2 = context.runtime;
        StackTraceElement[] javaTrace = t.getStackTrace();
        BacktraceData backtraceData = runtime2.getInstanceConfig().getTraceType().getIntegratedBacktrace(context, javaTrace);
        t.setStackTrace(RaiseException.javaTraceFromRubyTrace(backtraceData.getBacktrace(runtime2)));
        Helpers.throwException(t);
        return null;
    }

    @Deprecated
    public static void rewriteStackTrace(Ruby runtime2, Throwable e) {
        StackTraceElement[] javaTrace = e.getStackTrace();
        BacktraceData backtraceData = runtime2.getInstanceConfig().getTraceType().getIntegratedBacktrace(runtime2.getCurrentContext(), javaTrace);
        e.setStackTrace(RaiseException.javaTraceFromRubyTrace(backtraceData.getBacktrace(runtime2)));
    }

    public static <T> T[] arrayOf(T ... values2) {
        return values2;
    }

    public static IRubyObject[] arrayOf(IRubyObject first2, IRubyObject ... values2) {
        IRubyObject[] newValues = new IRubyObject[values2.length + 1];
        newValues[0] = first2;
        System.arraycopy(values2, 0, newValues, 1, values2.length);
        return newValues;
    }

    public static <T> T[] arrayOf(Class<T> t, int size2, T fill2) {
        Object[] ary = (Object[])Array.newInstance(t, size2);
        Arrays.fill(ary, fill2);
        return ary;
    }

    public static int memchr(boolean[] ary, int start2, int len, boolean find2) {
        for (int i2 = 0; i2 < len; ++i2) {
            if (ary[i2 + start2] != find2) continue;
            return i2 + start2;
        }
        return -1;
    }

    public static boolean isRequiredKeywordArgumentValueNode(Node asgnNode) {
        return asgnNode.childNodes().get(0) instanceof RequiredKeywordArgumentValueNode;
    }

    public static long hashStart(Ruby runtime2, long value2) {
        long hash2 = value2 + (runtime2.isSiphashEnabled() ? runtime2.getHashSeedK1() : runtime2.getHashSeedK0());
        return hash2;
    }

    public static long hashEnd(long value2) {
        value2 = Helpers.murmur_step(value2, 10L);
        value2 = Helpers.murmur_step(value2, 17L);
        return value2;
    }

    public static RubyFixnum safeHash(ThreadContext context, IRubyObject obj) {
        Ruby runtime2 = context.runtime;
        IRubyObject hval = context.safeRecurse(Helpers.sites((ThreadContext)context).recursive_hash, runtime2, obj, "hash", true);
        while (!(hval instanceof RubyFixnum)) {
            if (hval instanceof RubyBignum) {
                return ((RubyBignum)hval).hash();
            }
            hval = hval.convertToInteger();
        }
        return (RubyFixnum)hval;
    }

    public static long multAndMix(long seed2, long hash2) {
        long hm1 = seed2 >> 32;
        long hm2 = hash2 >> 32;
        long lm1 = seed2;
        long lm2 = hash2;
        long v64_128 = hm1 * hm2;
        long v32_96 = hm1 * lm2 + lm1 * hm2;
        long v1_32 = lm1 * lm2;
        return v64_128 + (v32_96 >> 32) ^ (v32_96 << 32) + v1_32;
    }

    public static long murmurCombine(long h2, long i2) {
        long v = 0L;
        v = Helpers.murmur1(v + (h2 += i2));
        v = Helpers.murmur1(v + (h2 >>> 32));
        return v;
    }

    public static long murmur(long h2, long k, int r) {
        long m3 = 1540483477L;
        h2 += k;
        h2 *= m3;
        h2 ^= h2 >> r;
        return h2;
    }

    public static long murmur_finish(long h2) {
        h2 = Helpers.murmur(h2, 0L, 10);
        h2 = Helpers.murmur(h2, 0L, 17);
        return h2;
    }

    public static long murmur_step(long h2, long k) {
        return Helpers.murmur(h2, k, 16);
    }

    public static long murmur1(long h2) {
        return Helpers.murmur_step(h2, 16L);
    }

    private static JavaSites.HelpersSites sites(ThreadContext context) {
        return context.sites.Helpers;
    }

    @Deprecated
    public static String encodeParameterList(List<String[]> args2) {
        if (args2.size() == 0) {
            return "NONE";
        }
        StringBuilder builder = new StringBuilder();
        boolean added = false;
        for (String[] desc : args2) {
            if (added) {
                builder.append(';');
            }
            builder.append(desc[0]).append(desc[1]);
            added = true;
        }
        return builder.toString();
    }

    public static byte[] subseq(byte[] ary, int start2, int len) {
        byte[] newAry = new byte[len];
        System.arraycopy(ary, start2, newAry, 0, len);
        return newAry;
    }

    public static boolean respondsToMethod(DynamicMethod method2, boolean checkVisibility) {
        if (method2.isUndefined() || method2.isNotImplemented()) {
            return false;
        }
        return !checkVisibility || method2.getVisibility() != Visibility.PRIVATE && method2.getVisibility() != Visibility.PROTECTED;
    }

    public static StaticScope getStaticScope(IRScope scope) {
        return scope.getStaticScope();
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject[] args2, CallType callType, Block block) {
        return self2.getMetaClass().invoke(context, self2, name2, args2, callType, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, IRubyObject arg2, CallType callType, Block block) {
        return self2.getMetaClass().invoke(context, self2, name2, arg2, callType, block);
    }

    public static IRubyObject invoke(ThreadContext context, IRubyObject self2, String name2, CallType callType) {
        return Helpers.invoke(context, self2, name2, IRubyObject.NULL_ARRAY, callType, Block.NULL_BLOCK);
    }

    @Deprecated
    public static IRubyObject invokeFrom(ThreadContext context, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject[] args2, CallType callType, Block block) {
        return self2.getMetaClass().invokeFrom(context, callType, caller2, self2, name2, args2, block);
    }

    @Deprecated
    public static IRubyObject invokeFrom(ThreadContext context, IRubyObject caller2, IRubyObject self2, String name2, IRubyObject arg2, CallType callType, Block block) {
        return self2.getMetaClass().invokeFrom(context, callType, caller2, self2, name2, arg2, block);
    }

    @Deprecated
    public static IRubyObject invokeFrom(ThreadContext context, IRubyObject caller2, IRubyObject self2, String name2, CallType callType) {
        return self2.getMetaClass().invokeFrom(context, callType, caller2, self2, name2, IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
    }

    public static class MethodMissingMethod
    extends DynamicMethod {
        public final CacheEntry entry;
        private final CallType lastCallStatus;
        private final Visibility lastVisibility;

        public MethodMissingMethod(CacheEntry entry, Visibility lastVisibility, CallType lastCallStatus) {
            super(entry.method.getImplementationClass(), lastVisibility, entry.method.getName());
            this.entry = entry;
            this.lastCallStatus = lastCallStatus;
            this.lastVisibility = lastVisibility;
        }

        @Override
        public IRubyObject call(ThreadContext context, IRubyObject self2, RubyModule clazz, String name2, IRubyObject[] args2, Block block) {
            context.setLastCallStatusAndVisibility(this.lastCallStatus, this.lastVisibility);
            return this.entry.method.call(context, self2, this.entry.sourceModule, "method_missing", Helpers.prepareMethodMissingArgs(args2, context, name2), block);
        }

        @Override
        public DynamicMethod dup() {
            return this;
        }
    }
}

