/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.ParsePosition;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.GJChronology;
import org.joda.time.chrono.JulianChronology;
import org.jruby.util.TimeOutputFormatter;

@Deprecated
public class RubyDateFormat
extends DateFormat {
    private static final long serialVersionUID = -250429218019023997L;
    private final List<Token> compiledPattern;
    private final DateFormatSymbols formatSymbols;
    private static final int FORMAT_STRING = 0;
    private static final int FORMAT_WEEK_LONG = 1;
    private static final int FORMAT_WEEK_SHORT = 2;
    private static final int FORMAT_MONTH_LONG = 3;
    private static final int FORMAT_MONTH_SHORT = 4;
    private static final int FORMAT_DAY = 5;
    private static final int FORMAT_DAY_S = 6;
    private static final int FORMAT_HOUR = 7;
    private static final int FORMAT_HOUR_M = 8;
    private static final int FORMAT_HOUR_S = 9;
    private static final int FORMAT_DAY_YEAR = 10;
    private static final int FORMAT_MINUTES = 11;
    private static final int FORMAT_MONTH = 12;
    private static final int FORMAT_MERIDIAN = 13;
    private static final int FORMAT_MERIDIAN_LOWER_CASE = 14;
    private static final int FORMAT_SECONDS = 15;
    private static final int FORMAT_WEEK_YEAR_S = 16;
    private static final int FORMAT_WEEK_YEAR_M = 17;
    private static final int FORMAT_DAY_WEEK = 18;
    private static final int FORMAT_YEAR_LONG = 19;
    private static final int FORMAT_YEAR_SHORT = 20;
    private static final int FORMAT_COLON_ZONE_OFF = 21;
    private static final int FORMAT_ZONE_ID = 22;
    private static final int FORMAT_CENTURY = 23;
    private static final int FORMAT_HOUR_BLANK = 24;
    private static final int FORMAT_MILLISEC = 25;
    private static final int FORMAT_EPOCH = 26;
    private static final int FORMAT_DAY_WEEK2 = 27;
    private static final int FORMAT_WEEK_WEEKYEAR = 28;
    private static final int FORMAT_NANOSEC = 29;
    private static final int FORMAT_WEEKYEAR = 30;
    private static final int FORMAT_OUTPUT = 31;
    private static final int FORMAT_WEEKYEAR_SHORT = 32;
    private static final int FORMAT_MICROSEC_EPOCH = 33;
    private static final int FORMAT_DATE_1 = 34;
    private DateTime dt;
    private long nsec;

    public RubyDateFormat() {
        this("", new DateFormatSymbols());
    }

    public RubyDateFormat(String pattern, Locale aLocale) {
        this(pattern, new DateFormatSymbols(aLocale));
    }

    public RubyDateFormat(String pattern, Locale aLocale, boolean ruby_1_9) {
        this(pattern, aLocale);
    }

    public RubyDateFormat(String pattern, DateFormatSymbols formatSymbols) {
        this.formatSymbols = formatSymbols;
        this.compiledPattern = new LinkedList<Token>();
        this.applyPattern(pattern);
    }

    public void applyPattern(String pattern) {
        this.applyPattern(pattern, false);
    }

    public void applyPattern(String pattern, boolean dateLibrary) {
        this.compilePattern(pattern, dateLibrary);
    }

    private void compilePattern(String pattern, boolean dateLibrary) {
        this.compiledPattern.clear();
        int len = pattern.length();
        boolean ignoredModifier = false;
        int i2 = 0;
        while (i2 < len) {
            block68: {
                block67: {
                    if (pattern.charAt(i2) == '%') break block67;
                    if (!ignoredModifier) break block68;
                    ignoredModifier = false;
                    if (false) break block68;
                }
                if (++i2 == len) {
                    this.compiledPattern.add(new Token(0, "%"));
                    continue;
                }
                i2 = this.addOutputFormatter(pattern, i2);
                block0 : switch (pattern.charAt(i2)) {
                    case 'A': {
                        this.compiledPattern.add(new Token(1));
                        break;
                    }
                    case 'a': {
                        this.compiledPattern.add(new Token(2));
                        break;
                    }
                    case 'B': {
                        this.compiledPattern.add(new Token(3));
                        break;
                    }
                    case 'b': 
                    case 'h': {
                        this.compiledPattern.add(new Token(4));
                        break;
                    }
                    case 'C': {
                        this.compiledPattern.add(new Token(23));
                        break;
                    }
                    case 'c': {
                        this.compiledPattern.add(new Token(2));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(4));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(6));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(7));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(11));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(15));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(19));
                        break;
                    }
                    case 'D': {
                        this.compiledPattern.add(new Token(12));
                        this.compiledPattern.add(new Token(0, "/"));
                        this.compiledPattern.add(new Token(5));
                        this.compiledPattern.add(new Token(0, "/"));
                        this.compiledPattern.add(new Token(20));
                        break;
                    }
                    case 'd': {
                        this.compiledPattern.add(new Token(5));
                        break;
                    }
                    case 'E': {
                        int next2 = 0;
                        if (i2 + 1 < len) {
                            next2 = pattern.charAt(i2 + 1);
                        }
                        switch (next2) {
                            case 67: 
                            case 88: 
                            case 89: 
                            case 99: 
                            case 120: 
                            case 121: {
                                ignoredModifier = true;
                                --i2;
                                break block0;
                            }
                        }
                        this.compiledPattern.add(new Token(0, "%E"));
                        break;
                    }
                    case 'e': {
                        this.compiledPattern.add(new Token(6));
                        break;
                    }
                    case 'F': {
                        this.compiledPattern.add(new Token(19));
                        this.compiledPattern.add(new Token(0, "-"));
                        this.compiledPattern.add(new Token(12));
                        this.compiledPattern.add(new Token(0, "-"));
                        this.compiledPattern.add(new Token(5));
                        break;
                    }
                    case 'G': {
                        this.compiledPattern.add(new Token(30));
                        break;
                    }
                    case 'g': {
                        this.compiledPattern.add(new Token(32));
                        break;
                    }
                    case 'H': {
                        this.compiledPattern.add(new Token(7));
                        break;
                    }
                    case 'I': {
                        this.compiledPattern.add(new Token(8));
                        break;
                    }
                    case 'j': {
                        this.compiledPattern.add(new Token(10));
                        break;
                    }
                    case 'k': {
                        this.compiledPattern.add(new Token(24));
                        break;
                    }
                    case 'L': {
                        this.compiledPattern.add(new Token(25));
                        break;
                    }
                    case 'l': {
                        this.compiledPattern.add(new Token(9));
                        break;
                    }
                    case 'M': {
                        this.compiledPattern.add(new Token(11));
                        break;
                    }
                    case 'm': {
                        this.compiledPattern.add(new Token(12));
                        break;
                    }
                    case 'N': {
                        this.compiledPattern.add(new Token(29));
                        break;
                    }
                    case 'n': {
                        this.compiledPattern.add(new Token(0, "\n"));
                        break;
                    }
                    case 'O': {
                        int next2 = 0;
                        if (i2 + 1 < len) {
                            next2 = pattern.charAt(i2 + 1);
                        }
                        switch (next2) {
                            case 72: 
                            case 73: 
                            case 77: 
                            case 83: 
                            case 85: 
                            case 86: 
                            case 87: 
                            case 100: 
                            case 101: 
                            case 107: 
                            case 108: 
                            case 109: 
                            case 117: 
                            case 119: 
                            case 121: {
                                ignoredModifier = true;
                                --i2;
                                break block0;
                            }
                        }
                        this.compiledPattern.add(new Token(0, "%O"));
                        break;
                    }
                    case 'p': {
                        this.compiledPattern.add(new Token(13));
                        break;
                    }
                    case 'P': {
                        this.compiledPattern.add(new Token(14));
                        break;
                    }
                    case 'Q': {
                        if (dateLibrary) {
                            this.compiledPattern.add(new Token(33));
                            break;
                        }
                        this.compiledPattern.add(new Token(0, "%Q"));
                        break;
                    }
                    case 'R': {
                        this.compiledPattern.add(new Token(7));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(11));
                        break;
                    }
                    case 'r': {
                        this.compiledPattern.add(new Token(8));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(11));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(15));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(13));
                        break;
                    }
                    case 's': {
                        this.compiledPattern.add(new Token(26));
                        break;
                    }
                    case 'S': {
                        this.compiledPattern.add(new Token(15));
                        break;
                    }
                    case 'T': {
                        this.compiledPattern.add(new Token(7));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(11));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(15));
                        break;
                    }
                    case 't': {
                        this.compiledPattern.add(new Token(0, "\t"));
                        break;
                    }
                    case 'u': {
                        this.compiledPattern.add(new Token(27));
                        break;
                    }
                    case 'U': {
                        this.compiledPattern.add(new Token(16));
                        break;
                    }
                    case 'v': {
                        this.compiledPattern.add(new Token(6));
                        this.compiledPattern.add(new Token(0, "-"));
                        if (!dateLibrary) {
                            this.compiledPattern.add(new Token(31, new TimeOutputFormatter("^", 0)));
                        }
                        this.compiledPattern.add(new Token(4));
                        this.compiledPattern.add(new Token(0, "-"));
                        this.compiledPattern.add(new Token(19));
                        break;
                    }
                    case 'V': {
                        this.compiledPattern.add(new Token(28));
                        break;
                    }
                    case 'W': {
                        this.compiledPattern.add(new Token(17));
                        break;
                    }
                    case 'w': {
                        this.compiledPattern.add(new Token(18));
                        break;
                    }
                    case 'X': {
                        this.compiledPattern.add(new Token(7));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(11));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(15));
                        break;
                    }
                    case 'x': {
                        this.compiledPattern.add(new Token(12));
                        this.compiledPattern.add(new Token(0, "/"));
                        this.compiledPattern.add(new Token(5));
                        this.compiledPattern.add(new Token(0, "/"));
                        this.compiledPattern.add(new Token(20));
                        break;
                    }
                    case 'Y': {
                        this.compiledPattern.add(new Token(19));
                        break;
                    }
                    case 'y': {
                        this.compiledPattern.add(new Token(20));
                        break;
                    }
                    case 'Z': {
                        if (dateLibrary) {
                            this.compiledPattern.add(new Token(31, new TimeOutputFormatter(":", 0)));
                            this.compiledPattern.add(new Token(21));
                            break;
                        }
                        this.compiledPattern.add(new Token(22));
                        break;
                    }
                    case 'z': {
                        this.compiledPattern.add(new Token(21));
                        break;
                    }
                    case '+': {
                        if (!dateLibrary) {
                            this.compiledPattern.add(new Token(0, "%+"));
                            break;
                        }
                        this.compiledPattern.add(new Token(2));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(4));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(6));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(7));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(11));
                        this.compiledPattern.add(new Token(0, ":"));
                        this.compiledPattern.add(new Token(15));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(31, new TimeOutputFormatter(":", 0)));
                        this.compiledPattern.add(new Token(21));
                        this.compiledPattern.add(new Token(0, " "));
                        this.compiledPattern.add(new Token(19));
                        break;
                    }
                    case '%': {
                        this.compiledPattern.add(new Token(0, "%"));
                        break;
                    }
                    default: {
                        this.compiledPattern.add(new Token(0, "%" + pattern.charAt(i2)));
                    }
                }
                ++i2;
                continue;
            }
            StringBuilder sb = new StringBuilder();
            while (i2 < len && pattern.charAt(i2) != '%') {
                sb.append(pattern.charAt(i2));
                ++i2;
            }
            this.compiledPattern.add(new Token(0, sb.toString()));
        }
    }

    private int addOutputFormatter(String pattern, int index2) {
        TimeOutputFormatter outputFormatter = TimeOutputFormatter.getFormatter(pattern.substring(index2 - 1));
        if (outputFormatter != null) {
            index2 += outputFormatter.getFormat().length();
            this.compiledPattern.add(new Token(31, outputFormatter));
        }
        return index2;
    }

    public void setDateTime(DateTime dt) {
        this.dt = dt;
    }

    public void setNSec(long nsec2) {
        this.nsec = nsec2;
    }

    @Override
    public StringBuffer format(Date ignored, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        TimeOutputFormatter formatter = TimeOutputFormatter.DEFAULT_FORMATTER;
        block34: for (Token token : this.compiledPattern) {
            String output = null;
            long value2 = 0L;
            FieldType type2 = FieldType.TEXT;
            int format = token.getFormat();
            switch (format) {
                case 31: {
                    formatter = (TimeOutputFormatter)token.getData();
                    continue block34;
                }
                case 0: {
                    output = token.getData().toString();
                    break;
                }
                case 1: {
                    int v = (this.dt.getDayOfWeek() + 1) % 8;
                    if (v == 0) {
                        ++v;
                    }
                    output = this.formatSymbols.getWeekdays()[v];
                    break;
                }
                case 2: {
                    int v = (this.dt.getDayOfWeek() + 1) % 8;
                    if (v == 0) {
                        ++v;
                    }
                    output = this.formatSymbols.getShortWeekdays()[v];
                    break;
                }
                case 3: {
                    output = this.formatSymbols.getMonths()[this.dt.getMonthOfYear() - 1];
                    break;
                }
                case 4: {
                    output = this.formatSymbols.getShortMonths()[this.dt.getMonthOfYear() - 1];
                    break;
                }
                case 5: {
                    type2 = FieldType.NUMERIC2;
                    value2 = this.dt.getDayOfMonth();
                    break;
                }
                case 6: {
                    type2 = FieldType.NUMERIC2BLANK;
                    value2 = this.dt.getDayOfMonth();
                    break;
                }
                case 7: {
                    type2 = FieldType.NUMERIC2;
                    value2 = this.dt.getHourOfDay();
                    break;
                }
                case 24: {
                    type2 = FieldType.NUMERIC2BLANK;
                    value2 = this.dt.getHourOfDay();
                    break;
                }
                case 8: 
                case 9: {
                    value2 = this.dt.getHourOfDay();
                    if (value2 == 0L) {
                        value2 = 12L;
                    } else if (value2 > 12L) {
                        value2 -= 12L;
                    }
                    type2 = format == 8 ? FieldType.NUMERIC2 : FieldType.NUMERIC2BLANK;
                    break;
                }
                case 10: {
                    type2 = FieldType.NUMERIC3;
                    value2 = this.dt.getDayOfYear();
                    break;
                }
                case 11: {
                    type2 = FieldType.NUMERIC2;
                    value2 = this.dt.getMinuteOfHour();
                    break;
                }
                case 12: {
                    type2 = FieldType.NUMERIC2;
                    value2 = this.dt.getMonthOfYear();
                    break;
                }
                case 13: {
                    output = this.dt.getHourOfDay() < 12 ? "AM" : "PM";
                    break;
                }
                case 14: {
                    output = this.dt.getHourOfDay() < 12 ? "am" : "pm";
                    break;
                }
                case 15: {
                    type2 = FieldType.NUMERIC2;
                    value2 = this.dt.getSecondOfMinute();
                    break;
                }
                case 17: {
                    type2 = FieldType.NUMERIC2;
                    value2 = this.formatWeekYear(2);
                    break;
                }
                case 16: {
                    type2 = FieldType.NUMERIC2;
                    value2 = this.formatWeekYear(1);
                    break;
                }
                case 18: {
                    type2 = FieldType.NUMERIC;
                    value2 = this.dt.getDayOfWeek() % 7;
                    break;
                }
                case 27: {
                    type2 = FieldType.NUMERIC;
                    value2 = this.dt.getDayOfWeek();
                    break;
                }
                case 19: {
                    value2 = this.year(this.dt.getYear());
                    type2 = value2 >= 0L ? FieldType.NUMERIC4 : FieldType.NUMERIC5;
                    break;
                }
                case 20: {
                    type2 = FieldType.NUMERIC2;
                    value2 = this.year(this.dt.getYear()) % 100;
                    break;
                }
                case 21: {
                    value2 = this.dt.getZone().getOffset(this.dt.getMillis()) / 1000;
                    int colons = formatter.getNumberOfColons();
                    output = this.formatZone(colons, (int)value2, formatter);
                    break;
                }
                case 22: {
                    output = this.dt.getZone().getShortName(this.dt.getMillis());
                    break;
                }
                case 23: {
                    type2 = FieldType.NUMERIC;
                    value2 = this.year(this.dt.getYear()) / 100;
                    break;
                }
                case 26: {
                    type2 = FieldType.NUMERIC;
                    value2 = this.dt.getMillis() / 1000L;
                    break;
                }
                case 28: {
                    type2 = FieldType.NUMERIC2;
                    value2 = this.dt.getWeekOfWeekyear();
                    break;
                }
                case 25: 
                case 29: {
                    value2 = (long)this.dt.getMillisOfSecond() * 1000000L + this.nsec;
                    output = TimeOutputFormatter.formatNumber(value2, 9, '0');
                    int defaultWidth = format == 29 ? 9 : 3;
                    int width = formatter.getWidth(defaultWidth);
                    if (width < 9) {
                        output = output.substring(0, width);
                    } else {
                        while (output.length() < width) {
                            output = output + "0";
                        }
                    }
                    formatter = TimeOutputFormatter.DEFAULT_FORMATTER;
                    break;
                }
                case 30: {
                    value2 = this.year(this.dt.getWeekyear());
                    type2 = value2 >= 0L ? FieldType.NUMERIC4 : FieldType.NUMERIC5;
                    break;
                }
                case 32: {
                    type2 = FieldType.NUMERIC2;
                    value2 = this.year(this.dt.getWeekyear()) % 100;
                    break;
                }
                case 33: {
                    type2 = FieldType.NUMERIC;
                    value2 = this.dt.getMillis();
                }
            }
            output = formatter.format(output, value2, type2);
            formatter = TimeOutputFormatter.DEFAULT_FORMATTER;
            toAppendTo.append(output);
        }
        return toAppendTo;
    }

    private int year(int year2) {
        Chronology c;
        if (year2 < 0 && ((c = this.dt.getChronology()) instanceof JulianChronology || c instanceof GJChronology && ((GJChronology)c).getGregorianCutover().isAfter(this.dt))) {
            return year2 + 1;
        }
        return year2;
    }

    private int formatWeekYear(int firstDayOfWeek) {
        GregorianCalendar dtCalendar = this.dt.toGregorianCalendar();
        dtCalendar.setFirstDayOfWeek(firstDayOfWeek);
        dtCalendar.setMinimalDaysInFirstWeek(7);
        int value2 = dtCalendar.get(3);
        if ((value2 == 52 || value2 == 53) && dtCalendar.get(2) == 0) {
            value2 = 0;
        }
        return value2;
    }

    private String formatZone(int colons, int value2, TimeOutputFormatter formatter) {
        int seconds = Math.abs(value2);
        int hours = seconds / 3600;
        int minutes = (seconds %= 3600) / 60;
        seconds %= 60;
        if (value2 < 0 && hours != 0) {
            hours = -hours;
        }
        String mm3 = TimeOutputFormatter.formatNumber(minutes, 2, '0');
        String ss = TimeOutputFormatter.formatNumber(seconds, 2, '0');
        char padder = formatter.getPadder('0');
        int defaultWidth = -1;
        String after = null;
        switch (colons) {
            case 0: {
                defaultWidth = 5;
                after = mm3;
                break;
            }
            case 1: {
                defaultWidth = 6;
                after = ":" + mm3;
                break;
            }
            case 2: {
                defaultWidth = 9;
                after = ":" + mm3 + ":" + ss;
                break;
            }
            case 3: {
                if (minutes == 0) {
                    if (seconds == 0) {
                        defaultWidth = 3;
                        after = "";
                        break;
                    }
                    return this.formatZone(1, value2, formatter);
                }
                return this.formatZone(2, value2, formatter);
            }
        }
        int minWidth = defaultWidth - 1;
        int width = formatter.getWidth(defaultWidth);
        if (width < minWidth) {
            width = minWidth;
        }
        String before = TimeOutputFormatter.formatSignedNumber(hours, width -= after.length(), padder);
        if (value2 < 0 && hours == 0) {
            before = before.replace('+', '-');
        }
        return before + after;
    }

    @Override
    public Date parse(String source2, ParsePosition pos2) {
        throw new UnsupportedOperationException();
    }

    static enum FieldType {
        NUMERIC('0', 0),
        NUMERIC2('0', 2),
        NUMERIC2BLANK(' ', 2),
        NUMERIC3('0', 3),
        NUMERIC4('0', 4),
        NUMERIC5('0', 5),
        TEXT(' ', 0);

        char defaultPadder;
        int defaultWidth;

        private FieldType(char padder, int width) {
            this.defaultPadder = padder;
            this.defaultWidth = width;
        }
    }

    private static class Token {
        private final int format;
        private final Object data;

        public Token(int format) {
            this(format, null);
        }

        public Token(int format, Object data2) {
            this.format = format;
            this.data = data2;
        }

        public Object getData() {
            return this.data;
        }

        public int getFormat() {
            return this.format;
        }
    }
}

