/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.util;

import java.nio.ByteOrder;
import org.jruby.util.unsafe.UnsafeHolder;
import sun.misc.Unsafe;

public class SipHashInline {
    public static long hash24(long k0, long k1, byte[] data2) {
        return SipHashInline.hash24(k0, k1, data2, 0, data2.length);
    }

    public static long hash24(long k0, long k1, byte[] src, int offset2, int length2) {
        int j;
        long m3;
        long v0 = 0x736F6D6570736575L ^ k0;
        long v1 = 0x646F72616E646F6DL ^ k1;
        long v2 = 0x6C7967656E657261L ^ k0;
        long v3 = 0x7465646279746573L ^ k1;
        int last2 = offset2 + length2 / 8 * 8;
        int i2 = offset2;
        if (offset2 < 0) {
            throw new ArrayIndexOutOfBoundsException(offset2);
        }
        if (offset2 + length2 > src.length) {
            throw new ArrayIndexOutOfBoundsException(src.length);
        }
        while (i2 < last2) {
            m3 = LongReader.INSTANCE.getLong(src, i2);
            i2 += 8;
            v0 += v1;
            v2 += (v3 ^= m3);
            v1 = v1 << 13 | v1 >>> 51;
            v3 = v3 << 16 | v3 >>> 48;
            v1 ^= v0;
            v3 ^= v2;
            v0 = v0 << 32 | v0 >>> 32;
            v2 += v1;
            v0 += v3;
            v1 = v1 << 17 | v1 >>> 47;
            v3 = v3 << 21 | v3 >>> 43;
            v1 ^= v2;
            v3 ^= v0;
            v2 = v2 << 32 | v2 >>> 32;
            v0 += v1;
            v2 += v3;
            v1 = v1 << 13 | v1 >>> 51;
            v3 = v3 << 16 | v3 >>> 48;
            v1 ^= v0;
            v3 ^= v2;
            v0 = v0 << 32 | v0 >>> 32;
            v2 += v1;
            v0 += v3;
            v1 = v1 << 17 | v1 >>> 47;
            v3 = v3 << 21 | v3 >>> 43;
            v1 ^= v2;
            v3 ^= v0;
            v2 = v2 << 32 | v2 >>> 32;
            v0 ^= m3;
        }
        m3 = 0L;
        for (i2 = offset2 + length2 - 1; i2 >= last2; --i2) {
            m3 <<= 8;
            m3 |= (long)src[i2];
        }
        v3 ^= (m3 |= (long)length2 << 56);
        for (j = 0; j < 2; ++j) {
            v0 += v1;
            v2 += v3;
            v1 = v1 << 13 | v1 >>> 51;
            v3 = v3 << 16 | v3 >>> 48;
            v1 ^= v0;
            v3 ^= v2;
            v0 = v0 << 32 | v0 >>> 32;
            v2 += v1;
            v0 += v3;
            v1 = v1 << 17 | v1 >>> 47;
            v3 = v3 << 21 | v3 >>> 43;
            v1 ^= v2;
            v3 ^= v0;
            v2 = v2 << 32 | v2 >>> 32;
        }
        v0 ^= m3;
        v2 ^= 0xFFL;
        for (j = 0; j < 4; ++j) {
            v0 += v1;
            v2 += v3;
            v1 = v1 << 13 | v1 >>> 51;
            v3 = v3 << 16 | v3 >>> 48;
            v1 ^= v0;
            v3 ^= v2;
            v0 = v0 << 32 | v0 >>> 32;
            v2 += v1;
            v0 += v3;
            v1 = v1 << 17 | v1 >>> 47;
            v3 = v3 << 21 | v3 >>> 43;
            v1 ^= v2;
            v3 ^= v0;
            v2 = v2 << 32 | v2 >>> 32;
        }
        return v0 ^ v1 ^ v2 ^ v3;
    }

    private static abstract class LongReader {
        public static final LongReader INSTANCE = LongReader.createBestLongReader();

        private LongReader() {
        }

        public abstract long getLong(byte[] var1, int var2);

        private static LongReader createBestLongReader() {
            try {
                if (UnsafeHolder.U != null && ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN) {
                    return new UnsafeLongReader(UnsafeHolder.U);
                }
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return new FallbackLongReader();
        }

        private static final class UnsafeLongReader
        extends LongReader {
            final Unsafe unsafe;
            final int byteArrayBaseOffset;

            public UnsafeLongReader(Unsafe unsafe) {
                this.unsafe = unsafe;
                this.byteArrayBaseOffset = unsafe.arrayBaseOffset(byte[].class);
            }

            @Override
            public final long getLong(byte[] src, int offset2) {
                return this.unsafe.getLong(src, (long)this.byteArrayBaseOffset + (long)offset2);
            }
        }

        private static final class FallbackLongReader
        extends LongReader {
            private FallbackLongReader() {
            }

            @Override
            public long getLong(byte[] src, int offset2) {
                return (long)src[offset2++] | (long)src[offset2++] << 8 | (long)src[offset2++] << 16 | (long)src[offset2++] << 24 | (long)src[offset2++] << 32 | (long)src[offset2++] << 40 | (long)src[offset2++] << 48 | (long)src[offset2++] << 56;
            }
        }
    }
}

