/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.env;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.constructor.AbstractConstruct;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.MissingEnvironmentVariableException;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.Tag;

public class EnvScalarConstructor
extends Constructor {
    public static final Tag ENV_TAG = new Tag("!ENV");
    public static final Pattern ENV_FORMAT = Pattern.compile("^\\$\\{\\s*((?<name>\\w+)((?<separator>:?(-|\\?))(?<value>\\w+)?)?)\\s*\\}$");

    public EnvScalarConstructor() {
        this.yamlConstructors.put(ENV_TAG, new ConstructEnv());
    }

    public String apply(String name2, String separator, String value2, String environment) {
        if (environment != null && !environment.isEmpty()) {
            return environment;
        }
        if (separator != null) {
            if (separator.equals("?") && environment == null) {
                throw new MissingEnvironmentVariableException("Missing mandatory variable " + name2 + ": " + value2);
            }
            if (separator.equals(":?")) {
                if (environment == null) {
                    throw new MissingEnvironmentVariableException("Missing mandatory variable " + name2 + ": " + value2);
                }
                if (environment.isEmpty()) {
                    throw new MissingEnvironmentVariableException("Empty mandatory variable " + name2 + ": " + value2);
                }
            }
            if (separator.startsWith(":") ? environment == null || environment.isEmpty() : environment == null) {
                return value2;
            }
        }
        return "";
    }

    public String getEnv(String key2) {
        return System.getenv(key2);
    }

    private class ConstructEnv
    extends AbstractConstruct {
        private ConstructEnv() {
        }

        @Override
        public Object construct(Node node) {
            String val = EnvScalarConstructor.this.constructScalar((ScalarNode)node);
            Matcher matcher = ENV_FORMAT.matcher(val);
            matcher.matches();
            String name2 = matcher.group("name");
            String value2 = matcher.group("value");
            String separator = matcher.group("separator");
            return EnvScalarConstructor.this.apply(name2, separator, value2 != null ? value2 : "", EnvScalarConstructor.this.getEnv(name2));
        }
    }
}

