/*
 * Decompiled with CFR 0.152.
 */
package org.yaml.snakeyaml.introspector;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.introspector.BeanAccess;
import org.yaml.snakeyaml.introspector.FieldProperty;
import org.yaml.snakeyaml.introspector.MethodProperty;
import org.yaml.snakeyaml.introspector.MissingProperty;
import org.yaml.snakeyaml.introspector.Property;
import org.yaml.snakeyaml.util.PlatformFeatureDetector;

public class PropertyUtils {
    private final Map<Class<?>, Map<String, Property>> propertiesCache = new HashMap();
    private final Map<Class<?>, Set<Property>> readableProperties = new HashMap();
    private BeanAccess beanAccess = BeanAccess.DEFAULT;
    private boolean allowReadOnlyProperties = false;
    private boolean skipMissingProperties = false;
    private PlatformFeatureDetector platformFeatureDetector;
    private static final String TRANSIENT = "transient";

    public PropertyUtils() {
        this(new PlatformFeatureDetector());
    }

    PropertyUtils(PlatformFeatureDetector platformFeatureDetector) {
        this.platformFeatureDetector = platformFeatureDetector;
        if (platformFeatureDetector.isRunningOnAndroid()) {
            this.beanAccess = BeanAccess.FIELD;
        }
    }

    protected Map<String, Property> getPropertiesMap(Class<?> type2, BeanAccess bAccess) {
        if (this.propertiesCache.containsKey(type2)) {
            return this.propertiesCache.get(type2);
        }
        LinkedHashMap<String, Property> properties = new LinkedHashMap<String, Property>();
        boolean inaccessableFieldsExist = false;
        switch (bAccess) {
            case FIELD: {
                for (Class<?> c = type2; c != null; c = c.getSuperclass()) {
                    for (Field field2 : c.getDeclaredFields()) {
                        int modifiers2 = field2.getModifiers();
                        if (Modifier.isStatic(modifiers2) || Modifier.isTransient(modifiers2) || properties.containsKey(field2.getName())) continue;
                        properties.put(field2.getName(), new FieldProperty(field2));
                    }
                }
                break;
            }
            default: {
                try {
                    for (PropertyDescriptor property : Introspector.getBeanInfo(type2).getPropertyDescriptors()) {
                        Method readMethod = property.getReadMethod();
                        if (readMethod != null && readMethod.getName().equals("getClass") || this.isTransient(property)) continue;
                        properties.put(property.getName(), new MethodProperty(property));
                    }
                }
                catch (IntrospectionException e) {
                    throw new YAMLException(e);
                }
                for (Class<?> c = type2; c != null; c = c.getSuperclass()) {
                    for (Field field3 : c.getDeclaredFields()) {
                        int modifiers3 = field3.getModifiers();
                        if (Modifier.isStatic(modifiers3) || Modifier.isTransient(modifiers3)) continue;
                        if (Modifier.isPublic(modifiers3)) {
                            properties.put(field3.getName(), new FieldProperty(field3));
                            continue;
                        }
                        inaccessableFieldsExist = true;
                    }
                }
            }
        }
        if (properties.isEmpty() && inaccessableFieldsExist) {
            throw new YAMLException("No JavaBean properties found in " + type2.getName());
        }
        this.propertiesCache.put(type2, properties);
        return properties;
    }

    private boolean isTransient(FeatureDescriptor fd) {
        return Boolean.TRUE.equals(fd.getValue(TRANSIENT));
    }

    public Set<Property> getProperties(Class<? extends Object> type2) {
        return this.getProperties(type2, this.beanAccess);
    }

    public Set<Property> getProperties(Class<? extends Object> type2, BeanAccess bAccess) {
        if (this.readableProperties.containsKey(type2)) {
            return this.readableProperties.get(type2);
        }
        Set<Property> properties = this.createPropertySet(type2, bAccess);
        this.readableProperties.put(type2, properties);
        return properties;
    }

    protected Set<Property> createPropertySet(Class<? extends Object> type2, BeanAccess bAccess) {
        TreeSet<Property> properties = new TreeSet<Property>();
        Collection<Property> props = this.getPropertiesMap(type2, bAccess).values();
        for (Property property : props) {
            if (!property.isReadable() || !this.allowReadOnlyProperties && !property.isWritable()) continue;
            properties.add(property);
        }
        return properties;
    }

    public Property getProperty(Class<? extends Object> type2, String name2) {
        return this.getProperty(type2, name2, this.beanAccess);
    }

    public Property getProperty(Class<? extends Object> type2, String name2, BeanAccess bAccess) {
        Map<String, Property> properties = this.getPropertiesMap(type2, bAccess);
        Property property = properties.get(name2);
        if (property == null && this.skipMissingProperties) {
            property = new MissingProperty(name2);
        }
        if (property == null) {
            throw new YAMLException("Unable to find property '" + name2 + "' on class: " + type2.getName());
        }
        return property;
    }

    public void setBeanAccess(BeanAccess beanAccess) {
        if (this.platformFeatureDetector.isRunningOnAndroid() && beanAccess != BeanAccess.FIELD) {
            throw new IllegalArgumentException("JVM is Android - only BeanAccess.FIELD is available");
        }
        if (this.beanAccess != beanAccess) {
            this.beanAccess = beanAccess;
            this.propertiesCache.clear();
            this.readableProperties.clear();
        }
    }

    public void setAllowReadOnlyProperties(boolean allowReadOnlyProperties) {
        if (this.allowReadOnlyProperties != allowReadOnlyProperties) {
            this.allowReadOnlyProperties = allowReadOnlyProperties;
            this.readableProperties.clear();
        }
    }

    public boolean isAllowReadOnlyProperties() {
        return this.allowReadOnlyProperties;
    }

    public void setSkipMissingProperties(boolean skipMissingProperties) {
        if (this.skipMissingProperties != skipMissingProperties) {
            this.skipMissingProperties = skipMissingProperties;
            this.readableProperties.clear();
        }
    }

    public boolean isSkipMissingProperties() {
        return this.skipMissingProperties;
    }
}

