/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.json.resource.descriptor.examples.model;

import java.util.HashSet;
import java.util.Set;
import javax.validation.constraints.NotNull;
import org.forgerock.api.annotations.Description;
import org.forgerock.api.annotations.Title;
import org.forgerock.api.annotations.UniqueItems;
import org.forgerock.json.resource.descriptor.examples.model.Device;

@Title(value="User")
@Description(value="User with device sub-resources")
public final class User {
    @NotNull
    @Title(value="User ID")
    @Description(value="Unique user identifier")
    private final String uid;
    @NotNull
    @Title(value="User name")
    @Description(value="The user name")
    private final String name;
    @NotNull
    @Title(value="Password")
    @Description(value="Password of the user")
    private String password;
    @Title(value="Devices")
    @Description(value="Devices belonging to this user")
    @UniqueItems
    private Set<Device> devices = new HashSet();

    public User(String uid, String name, String password) {
        this.uid = uid;
        this.name = name;
        this.password = password;
    }

    public String getUid() {
        return this.uid;
    }

    public String getName() {
        return this.name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Set<Device> getDevices() {
        return this.devices;
    }

    public void setDevices(Set<Device> devices) {
        this.devices = devices;
    }

    public void addDevices(Device device) {
        this.devices.add(device);
    }
}

