/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.anonymous;

import com.sun.identity.authentication.modules.anonymous.AnonymousAuthPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.PagePropertiesCallback;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import java.io.IOException;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class Anonymous
extends AMLoginModule {
    private static Debug debug = null;
    private static final int DEFAULT_ANONYMOUS_AUTH_LEVEL = 0;
    private static final String amAuthAnonymous = "amAuthAnonymous";
    private ResourceBundle bundle = null;
    private Map sharedState;
    private String userTokenId;
    private String defaultAnonUser;
    private Set validAnonUsernames;
    private int authLevel;
    private String errorMsg = null;
    private String usernameParam = null;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private AnonymousAuthPrincipal userPrincipal;
    private CallbackHandler callbackHandler;
    private boolean isCaseSensitive = false;
    boolean useSharedstate = false;

    public void init(Subject subject, Map sharedState, Map options) {
        if (debug == null) {
            debug = Debug.getInstance((String)amAuthAnonymous);
        }
        this.sharedState = sharedState;
        Locale locale = this.getLoginLocale();
        this.bundle = amCache.getResBundle(amAuthAnonymous, locale);
        if (debug.messageEnabled()) {
            debug.message("Anonymous resbundle locale=" + locale);
        }
        try {
            this.validAnonUsernames = (Set)options.get("iplanet-am-auth-anonymous-users-list");
            if (this.validAnonUsernames == null) {
                debug.error("No Anonymous Service Template Created");
                this.errorMsg = "AnonValidateEx";
            }
            this.defaultAnonUser = CollectionHelper.getMapAttr((Map)options, (String)"iplanet-am-auth-anonymous-default-user-name");
            String tmp = CollectionHelper.getMapAttr((Map)options, (String)"iplanet-am-auth-anonymous-auth-level");
            if (tmp == null || tmp.length() == 0) {
                this.authLevel = 0;
            } else {
                try {
                    this.authLevel = Integer.parseInt(tmp);
                }
                catch (Exception e) {
                    debug.error("Invalid auth level " + tmp);
                    this.authLevel = 0;
                }
            }
            this.callbackHandler = this.getCallbackHandler();
            this.isCaseSensitive = Boolean.valueOf(CollectionHelper.getMapAttr((Map)options, (String)"iplanet-am-auth-anonymous-case-sensitive", (String)"false"));
            if (debug.messageEnabled()) {
                debug.message("isCaseSensitive: " + this.isCaseSensitive);
            }
        }
        catch (Exception ex) {
            if (debug.messageEnabled()) {
                debug.message("possible exception is ", (Throwable)ex);
            }
            debug.error("Failed getting anonymous attributes for organization ");
            this.errorMsg = "AnonValidateEx";
        }
    }

    public int process(Callback[] callbacks, int state) throws AuthLoginException {
        if (this.errorMsg != null) {
            throw new AuthLoginException(amAuthAnonymous, this.errorMsg, null);
        }
        this.useSharedstate = this.isSharedStateEnabled();
        try {
            if (this.useSharedstate) {
                this.usernameParam = (String)this.sharedState.get(this.getUserKey());
                if (this.processAnonUser(this.usernameParam)) {
                    this.setAuthLevel(this.authLevel);
                    return -1;
                }
            }
            if (callbacks != null && callbacks.length > 0 && callbacks[0] instanceof NameCallback) {
                this.usernameParam = ((NameCallback)callbacks[0]).getName();
                if (debug.messageEnabled()) {
                    debug.message("Anonymous:process received NameCallback " + this.usernameParam);
                }
                if (this.processAnonUser(this.usernameParam)) {
                    this.setAuthLevel(this.authLevel);
                    return -1;
                }
            }
            this.usernameParam = this.validAnonUsernames != null && !this.validAnonUsernames.isEmpty() ? this.sendCallback() : this.defaultAnonUser;
            this.storeUsernamePasswd(this.usernameParam, null);
            this.processAnonUser(this.usernameParam);
            this.setAuthLevel(this.authLevel);
            if (debug.messageEnabled()) {
                debug.message("Set auth level: " + this.authLevel + "\nAnonymous userid: " + this.userTokenId);
            }
        }
        catch (Exception e) {
            debug.error("login: User not found in valid Anon List");
            this.setFailureID(this.usernameParam);
            throw new AuthLoginException(amAuthAnonymous, "AnonValidateEx", null);
        }
        return -1;
    }

    private boolean isValidAnonUserName() {
        if (this.isCaseSensitive) {
            return this.validAnonUsernames.contains(this.usernameParam);
        }
        for (String name : this.validAnonUsernames) {
            if (name == null || !name.equalsIgnoreCase(this.usernameParam)) continue;
            this.usernameParam = name;
            return true;
        }
        return false;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new AnonymousAuthPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    public void destroyModuleState() {
        this.userTokenId = null;
        this.userPrincipal = null;
    }

    public void nullifyUsedVars() {
        this.bundle = null;
        this.sharedState = null;
        this.defaultAnonUser = null;
        this.validAnonUsernames = null;
        this.errorMsg = null;
        this.usernameParam = null;
        this.callbackHandler = null;
    }

    private String sendCallback() throws AuthLoginException {
        if (this.callbackHandler == null) {
            throw new AuthLoginException(amAuthAnonymous, "NoCallbackHandler", null);
        }
        String username = null;
        try {
            Callback[] callbacks = new Callback[2];
            String header = this.bundle.getString("moduleHeader");
            PagePropertiesCallback ppc = new PagePropertiesCallback(null, header, null, 0, null, false, null);
            callbacks[0] = ppc;
            callbacks[1] = new NameCallback(this.bundle.getString("username"));
            if (debug.messageEnabled()) {
                debug.message("Callback 0 is.. :" + callbacks[0]);
                debug.message("Callback 1 is.. :" + callbacks[1]);
            }
            this.callbackHandler.handle(callbacks);
            username = ((NameCallback)callbacks[1]).getName();
            return username;
        }
        catch (IllegalArgumentException ill) {
            debug.message("message type missing");
            throw new AuthLoginException(amAuthAnonymous, "IllegalArgs", null);
        }
        catch (IOException ioe) {
            throw new AuthLoginException((Throwable)ioe);
        }
        catch (UnsupportedCallbackException uce) {
            throw new AuthLoginException(amAuthAnonymous, "NoCallbackHandler", null);
        }
    }

    private boolean processAnonUser(String usernameParam) throws AuthLoginException {
        if (usernameParam == null || usernameParam.length() == 0) {
            debug.message("User Name entered is either NULL or Empty");
            if (this.useSharedstate) {
                return false;
            }
            throw new AuthLoginException(amAuthAnonymous, "UserError", null);
        }
        if (usernameParam.equalsIgnoreCase(this.defaultAnonUser)) {
            debug.message("User Type: default Anon User");
            if (this.isCaseSensitive && !usernameParam.equals(this.defaultAnonUser)) {
                if (this.useSharedstate) {
                    return false;
                }
                this.setFailureID(usernameParam);
                throw new AuthLoginException(amAuthAnonymous, "AnonValidateEx", null);
            }
            this.userTokenId = usernameParam;
        } else if (this.validAnonUsernames != null && this.isValidAnonUserName()) {
            debug.message("user is in anonymoususer's list");
            debug.message("UserType: non default Anon User");
            this.userTokenId = usernameParam;
        } else {
            if (this.useSharedstate) {
                return false;
            }
            this.setFailureID(usernameParam);
            throw new AuthLoginException(amAuthAnonymous, "AnonValidateEx", null);
        }
        return true;
    }
}

