/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.authentication.modules.scripted;

import com.iplanet.sso.SSOException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.shared.debug.Debug;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.forgerock.openam.scripting.api.ScriptedIdentity;
import org.forgerock.util.Reject;

public class ScriptIdentityRepository {
    private static final Debug DEBUG = Debug.getInstance((String)"ScriptedModuleIdentityRepository");
    private AMIdentityRepository identityRepository;

    public ScriptIdentityRepository(AMIdentityRepository identityRepository) {
        Reject.ifNull((Object)identityRepository);
        this.identityRepository = identityRepository;
    }

    public Set getAttribute(String userName, String attributeName) {
        ScriptedIdentity amIdentity = this.getIdentity(userName);
        if (amIdentity != null) {
            return amIdentity.getAttribute(attributeName);
        }
        return new HashSet();
    }

    public void setAttribute(String userName, String attributeName, String[] attributeValues) {
        ScriptedIdentity amIdentity = this.getIdentity(userName);
        if (amIdentity != null) {
            amIdentity.setAttribute(attributeName, (Object[])attributeValues);
            amIdentity.store();
        }
    }

    public void addAttribute(String userName, String attributeName, String attributeValue) {
        ScriptedIdentity amIdentity = this.getIdentity(userName);
        if (amIdentity != null) {
            amIdentity.addAttribute(attributeName, attributeValue);
            amIdentity.store();
        }
    }

    private ScriptedIdentity getIdentity(String userName) {
        ScriptedIdentity amIdentity = null;
        IdSearchControl idsc = new IdSearchControl();
        idsc.setAllReturnAttributes(true);
        idsc.setMaxResults(0);
        Set results = Collections.emptySet();
        try {
            IdSearchResults searchResults = this.identityRepository.searchIdentities(IdType.USER, userName, idsc);
            if (searchResults != null) {
                results = searchResults.getSearchResults();
            }
            if (results.isEmpty()) {
                DEBUG.error("ScriptedModule.getIdentity : User " + userName + " is not found");
            } else if (results.size() > 1) {
                DEBUG.error("ScriptedModule.getIdentity : More than one user found for the userName " + userName);
            } else {
                amIdentity = new ScriptedIdentity((AMIdentity)results.iterator().next());
            }
        }
        catch (IdRepoException e) {
            DEBUG.error("ScriptedModule.getIdentity : Error searching Identities with username : " + userName, (Throwable)e);
        }
        catch (SSOException e) {
            DEBUG.error("ScriptedModule.getIdentity : Module exception : ", (Throwable)e);
        }
        return amIdentity;
    }
}

