/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.authentication.modules.scripted;

import com.google.inject.Key;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.sun.identity.authentication.callbacks.HiddenValueCallback;
import com.sun.identity.authentication.callbacks.ScriptTextOutputCallback;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.shared.debug.Debug;
import java.lang.annotation.Annotation;
import java.security.Principal;
import java.util.Map;
import javax.script.Bindings;
import javax.script.SimpleBindings;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.login.LoginException;
import org.forgerock.guice.core.InjectorHolder;
import org.forgerock.http.client.RestletHttpClient;
import org.forgerock.http.client.request.HttpClientRequest;
import org.forgerock.http.client.request.HttpClientRequestFactory;
import org.forgerock.openam.authentication.modules.scripted.ScriptHttpRequestWrapper;
import org.forgerock.openam.authentication.modules.scripted.ScriptIdentityRepository;
import org.forgerock.openam.authentication.modules.scripted.ScriptedClientUtilityFunctions;
import org.forgerock.openam.authentication.modules.scripted.ScriptedPrinciple;
import org.forgerock.openam.scripting.ScriptConstants;
import org.forgerock.openam.scripting.ScriptEvaluator;
import org.forgerock.openam.scripting.ScriptException;
import org.forgerock.openam.scripting.ScriptObject;
import org.forgerock.openam.scripting.ScriptingLanguage;
import org.forgerock.openam.scripting.SupportedScriptingLanguage;
import org.forgerock.openam.scripting.service.ScriptConfiguration;
import org.forgerock.openam.scripting.service.ScriptingService;
import org.forgerock.openam.scripting.service.ScriptingServiceFactory;

public class Scripted
extends AMLoginModule {
    private static final String ATTR_NAME_PREFIX = "iplanet-am-auth-scripted-";
    private static final String CLIENT_SCRIPT_ATTR_NAME = "iplanet-am-auth-scripted-client-script";
    private static final String CLIENT_SCRIPT_ENABLED_ATTR_NAME = "iplanet-am-auth-scripted-client-script-enabled";
    private static final String SERVER_SCRIPT_ATTRIBUTE_NAME = "iplanet-am-auth-scripted-server-script";
    private static final int STATE_RUN_SCRIPT = 2;
    public static final String STATE_VARIABLE_NAME = "authState";
    private static final String SUCCESS_ATTR_NAME = "SUCCESS";
    public static final int SUCCESS_VALUE = -1;
    private static final String FAILED_ATTR_NAME = "FAILED";
    public static final int FAILURE_VALUE = -2;
    public static final String USERNAME_VARIABLE_NAME = "username";
    public static final String HTTP_CLIENT_VARIABLE_NAME = "httpClient";
    public static final String LOGGER_VARIABLE_NAME = "logger";
    public static final String IDENTITY_REPOSITORY = "idRepository";
    public static final String CLIENT_SCRIPT_OUTPUT_DATA_PARAMETER_NAME = "clientScriptOutputData";
    public static final String CLIENT_SCRIPT_OUTPUT_DATA_VARIABLE_NAME = "clientScriptOutputData";
    public static final String REQUEST_DATA_VARIABLE_NAME = "requestData";
    public static final String SHARED_STATE = "sharedState";
    private String userName;
    private boolean clientSideScriptEnabled;
    private ScriptEvaluator scriptEvaluator;
    private ScriptingService scriptingService;
    public Map moduleConfiguration;
    private static final Debug DEBUG = Debug.getInstance((String)"amScript");
    final HttpClientRequestFactory httpClientRequestFactory = (HttpClientRequestFactory)InjectorHolder.getInstance(HttpClientRequestFactory.class);
    private RestletHttpClient httpClient;
    private ScriptIdentityRepository identityRepository;
    protected Map<String, Object> sharedState;

    public void init(Subject subject, Map sharedState, Map options) {
        this.sharedState = sharedState;
        this.userName = (String)sharedState.get(this.getUserKey());
        this.moduleConfiguration = options;
        this.scriptingService = this.initialiseScriptingService();
        this.scriptEvaluator = this.getScriptEvaluator();
        this.clientSideScriptEnabled = this.getClientSideScriptEnabled();
        this.httpClient = this.getHttpClient();
        this.identityRepository = this.getScriptIdentityRepository();
    }

    private ScriptIdentityRepository getScriptIdentityRepository() {
        return new ScriptIdentityRepository(this.getAmIdentityRepository());
    }

    private AMIdentityRepository getAmIdentityRepository() {
        return this.getAMIdentityRepository(this.getRequestOrg());
    }

    private ScriptingService initialiseScriptingService() {
        ScriptingServiceFactory scriptingServiceFactory = (ScriptingServiceFactory)InjectorHolder.getInstance((Key)Key.get((TypeLiteral)new TypeLiteral<ScriptingServiceFactory>(){}));
        return scriptingServiceFactory.create(this.getRequestOrg());
    }

    public int process(Callback[] callbacks, int state) throws LoginException {
        switch (state) {
            case 1: {
                this.substituteUIStrings();
                return 2;
            }
            case 2: {
                SimpleBindings scriptVariables = new SimpleBindings();
                scriptVariables.put(REQUEST_DATA_VARIABLE_NAME, (Object)this.getScriptHttpRequestWrapper());
                String clientScriptOutputData = this.getClientScriptOutputData(callbacks);
                scriptVariables.put("clientScriptOutputData", (Object)clientScriptOutputData);
                scriptVariables.put(LOGGER_VARIABLE_NAME, (Object)DEBUG);
                scriptVariables.put(STATE_VARIABLE_NAME, (Object)state);
                scriptVariables.put(SHARED_STATE, (Object)this.sharedState);
                scriptVariables.put(USERNAME_VARIABLE_NAME, (Object)this.userName);
                scriptVariables.put(SUCCESS_ATTR_NAME, (Object)-1);
                scriptVariables.put(FAILED_ATTR_NAME, (Object)-2);
                scriptVariables.put(HTTP_CLIENT_VARIABLE_NAME, (Object)this.httpClient);
                scriptVariables.put(IDENTITY_REPOSITORY, (Object)this.identityRepository);
                try {
                    this.scriptEvaluator.evaluateScript(this.getServerSideScript(), (Bindings)scriptVariables);
                }
                catch (javax.script.ScriptException e) {
                    DEBUG.message("Error running server side scripts", (Throwable)e);
                    throw new AuthLoginException("Error running script", (Throwable)e);
                }
                state = ((Number)scriptVariables.get(STATE_VARIABLE_NAME)).intValue();
                this.userName = (String)scriptVariables.get(USERNAME_VARIABLE_NAME);
                this.sharedState.put("clientScriptOutputData", clientScriptOutputData);
                if (state != -1) {
                    throw new AuthLoginException("Authentication failed");
                }
                return state;
            }
        }
        throw new AuthLoginException("Invalid state");
    }

    private String getClientScriptOutputData(Callback[] callbacks) {
        String clientScriptOutputData = ((HiddenValueCallback)callbacks[0]).getValue();
        if (clientScriptOutputData == null) {
            clientScriptOutputData = this.getScriptHttpRequestWrapper().getParameter("clientScriptOutputData");
        }
        return clientScriptOutputData;
    }

    private ScriptObject getServerSideScript() throws AuthLoginException {
        String serverSideScriptId = this.getConfigValue(SERVER_SCRIPT_ATTRIBUTE_NAME);
        try {
            if ("[Empty]".equals(serverSideScriptId)) {
                return new ScriptObject("DefaultScript", "", (ScriptingLanguage)SupportedScriptingLanguage.JAVASCRIPT);
            }
            ScriptConfiguration config = this.scriptingService.get(serverSideScriptId);
            return new ScriptObject(config.getName(), config.getScript(), (ScriptingLanguage)config.getLanguage());
        }
        catch (ScriptException e) {
            DEBUG.error("Error retrieving server side script", (Throwable)e);
            throw new AuthLoginException("Error retrieving script", (Throwable)e);
        }
    }

    private ScriptEvaluator getScriptEvaluator() {
        return (ScriptEvaluator)InjectorHolder.getInstance((Key)Key.get(ScriptEvaluator.class, (Annotation)Names.named((String)ScriptConstants.ScriptContext.AUTHENTICATION_SERVER_SIDE.name())));
    }

    private RestletHttpClient getHttpClient() {
        SupportedScriptingLanguage scriptType = this.getScriptType();
        if (scriptType == null) {
            return null;
        }
        return (RestletHttpClient)InjectorHolder.getInstance((Key)Key.get(RestletHttpClient.class, (Annotation)Names.named((String)scriptType.name())));
    }

    private HttpClientRequest getHttpRequest() {
        return this.httpClientRequestFactory.createRequest();
    }

    private String getClientSideScript() {
        String script = "";
        if (!this.clientSideScriptEnabled) {
            return script;
        }
        String clientSideScriptId = this.getConfigValue(CLIENT_SCRIPT_ATTR_NAME);
        if ("[Empty]".equals(clientSideScriptId)) {
            return script;
        }
        try {
            script = this.scriptingService.get(clientSideScriptId).getScript();
        }
        catch (ScriptException e) {
            DEBUG.error("Error retrieving client side script", (Throwable)e);
        }
        return script;
    }

    private String getConfigValue(String attributeName) {
        return CollectionHelper.getMapAttr((Map)this.moduleConfiguration, (String)attributeName);
    }

    private ScriptHttpRequestWrapper getScriptHttpRequestWrapper() {
        return new ScriptHttpRequestWrapper(this.getHttpServletRequest());
    }

    private void substituteUIStrings() throws AuthLoginException {
        this.replaceCallback(2, 1, this.createClientSideScriptAndSelfSubmitCallback());
    }

    private Callback createClientSideScriptAndSelfSubmitCallback() {
        String clientSideScriptExecutorFunction = ScriptedClientUtilityFunctions.createClientSideScriptExecutorFunction(this.getClientSideScript(), "clientScriptOutputData", this.getClientSideScriptEnabled());
        ScriptTextOutputCallback scriptAndSelfSubmitCallback = new ScriptTextOutputCallback(clientSideScriptExecutorFunction);
        return scriptAndSelfSubmitCallback;
    }

    private SupportedScriptingLanguage getScriptType() {
        try {
            return (SupportedScriptingLanguage)this.getServerSideScript().getLanguage();
        }
        catch (AuthLoginException e) {
            DEBUG.error("Error retrieving server side scripting language", (Throwable)e);
            return null;
        }
    }

    private boolean getClientSideScriptEnabled() {
        String clientSideScriptEnabled = this.getConfigValue(CLIENT_SCRIPT_ENABLED_ATTR_NAME);
        return Boolean.parseBoolean(clientSideScriptEnabled);
    }

    public Principal getPrincipal() {
        if (this.userName == null) {
            DEBUG.message("Warning: username is null");
        }
        return new ScriptedPrinciple(this.userName);
    }
}

