/*
 * Decompiled with CFR 0.152.
 */
package org.openidentityplatform.openam.cassandra.embedded;

import com.datastax.oss.driver.api.core.AllNodesFailedException;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.CqlSessionBuilder;
import com.iplanet.am.util.SystemProperties;
import java.io.Closeable;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.service.CassandraDaemon;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements Runnable,
Closeable {
    static final Logger logger = LoggerFactory.getLogger((String)Server.class.getName());
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private CassandraDaemon cassandraDaemon;

    @Override
    public void run() {
        block49: {
            try {
                if (SystemProperties.get((String)"datastax-java-driver.basic.load-balancing-policy.local-datacenter") != null || SystemProperties.get((String)"datastax-java-driver.basic.contact-points.0") != null) {
                    return;
                }
                File path = new File(System.getProperty("cassandra.storagedir", System.getProperty("java.io.tmpdir") + File.separator + "embeddedCassandra"));
                path.mkdirs();
                System.setProperty("cassandra-foreground", "true");
                System.setProperty("cassandra.storagedir", path.getPath());
                if (!Files.exists(Paths.get("target", new String[0]), new LinkOption[0])) {
                    Files.createDirectory(Paths.get("target", new String[0]), new FileAttribute[0]);
                }
                if (!Files.exists(Paths.get("target" + File.separator + "embedded_keystore", new String[0]), new LinkOption[0])) {
                    Files.copy(this.getClass().getResourceAsStream("/embedded_keystore"), Paths.get("target" + File.separator + "embedded_keystore", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                }
                Files.copy(this.getClass().getResourceAsStream("/cassandra.yaml"), Paths.get("target" + File.separator + "cassandra.yaml", new String[0]), StandardCopyOption.REPLACE_EXISTING);
                System.setProperty("cassandra.config", "" + Paths.get("target" + File.separator + "cassandra.yaml", new String[0]).toUri());
                this.cassandraDaemon = new CassandraDaemon(true);
                this.cassandraDaemon.activate();
                System.setProperty("datastax-java-driver.basic.contact-points.0", DatabaseDescriptor.getRpcAddress().getHostAddress() + ":" + DatabaseDescriptor.getNativeTransportPort());
                System.setProperty("datastax-java-driver.basic.load-balancing-policy.local-datacenter", DatabaseDescriptor.getLocalDataCenter());
                if ("cassandra".equalsIgnoreCase(System.getProperty("datastax-java-driver.advanced.auth-provider.username"))) {
                    while (true) {
                        try {
                            CqlSession session = (CqlSession)((CqlSessionBuilder)CqlSession.builder().withApplicationName("OpenAM Embedded")).build();
                            Throwable throwable = null;
                            if (session == null) break;
                            if (throwable != null) {
                                try {
                                    session.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break;
                            }
                            session.close();
                        }
                        catch (AllNodesFailedException e) {
                            logger.info("wait: Created default superuser role 'cassandra'");
                            Thread.sleep(1000L);
                            continue;
                        }
                        break;
                    }
                }
                String dataSetLocation = System.getProperty(Server.class.getPackage().getName() + ".import", "cassandra/import.cql");
                InputStream inputStream = this.getClass().getResourceAsStream("/" + dataSetLocation);
                if (inputStream == null) {
                    throw new AssertionError((Object)("cannot get resource " + dataSetLocation));
                }
                try (CqlSession session = (CqlSession)((CqlSessionBuilder)CqlSession.builder().withApplicationName("OpenAM Embedded")).build();){
                    for (String statement : Arrays.asList(StringUtils.normalizeSpace((String)IOUtils.toString((InputStream)inputStream, (String)"UTF-8")).split(";"))) {
                        try {
                            session.execute(StringUtils.normalizeSpace((String)statement));
                            logger.info("{}", (Object)StringUtils.normalizeSpace((String)statement));
                        }
                        catch (Exception e) {
                            logger.error("{}: {}", (Object)StringUtils.normalizeSpace((String)statement), (Object)e.getMessage());
                            assert (false) : "error in import.cql" + e.getMessage();
                        }
                    }
                    session.close();
                }
                dataSetLocation = System.getProperty(Server.class.getPackage().getName() + ".import.test");
                if (dataSetLocation == null) break block49;
                inputStream = this.getClass().getResourceAsStream("/" + dataSetLocation);
                if (inputStream == null) {
                    throw new AssertionError((Object)("cannot get resource " + dataSetLocation));
                }
                session = (CqlSession)((CqlSessionBuilder)CqlSession.builder().withApplicationName("OpenAM Embedded")).build();
                var5_8 = null;
                try {
                    for (String statement : Arrays.asList(StringUtils.normalizeSpace((String)IOUtils.toString((InputStream)inputStream, (String)"UTF-8")).split(";"))) {
                        try {
                            session.execute(StringUtils.normalizeSpace((String)statement));
                            logger.info("{}", (Object)StringUtils.normalizeSpace((String)statement));
                        }
                        catch (Exception e) {
                            logger.error("{}: {}", (Object)StringUtils.normalizeSpace((String)statement), (Object)e.getMessage());
                            assert (false) : "error in import.cql" + e.getMessage();
                        }
                    }
                    session.close();
                }
                catch (Throwable throwable) {
                    var5_8 = throwable;
                    throw throwable;
                }
                finally {
                    if (session != null) {
                        if (var5_8 != null) {
                            try {
                                session.close();
                            }
                            catch (Throwable throwable) {
                                var5_8.addSuppressed(throwable);
                            }
                        } else {
                            session.close();
                        }
                    }
                }
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void close() {
        if (this.cassandraDaemon != null) {
            this.cassandraDaemon.stop();
            this.cassandraDaemon = null;
        }
    }

    public static void main(String[] args) {
        Server s = new Server();
        s.run();
        s.close();
        System.exit(0);
    }
}

