/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.docs.ssoadm;

import com.sun.identity.cli.annotation.Macro;
import com.sun.identity.cli.annotation.SubCommandInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.forgerock.openam.docs.ssoadm.SubCommandXML;

@SupportedAnnotationTypes(value={"*"})
public class SsoadmAP
extends AbstractProcessor {
    Map<String, Macro> macros = new TreeMap<String, Macro>();
    Set<String> subcommands = new TreeSet<String>();

    public Set<String> getSubcommands() {
        return this.subcommands;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        String name;
        for (Element element : roundEnv.getElementsAnnotatedWith(Macro.class)) {
            name = element.getSimpleName().toString().replaceAll("_", "-");
            this.macros.put(name, element.getAnnotation(Macro.class));
        }
        for (Element element : roundEnv.getElementsAnnotatedWith(SubCommandInfo.class)) {
            name = element.getSimpleName().toString().replaceAll("_", "-");
            SubCommandInfo info = element.getAnnotation(SubCommandInfo.class);
            String description = info.description();
            TreeSet<String> mandatory = new TreeSet<String>();
            mandatory.addAll(Arrays.asList(info.mandatoryOptions()));
            TreeSet<String> optional = new TreeSet<String>();
            optional.addAll(Arrays.asList(info.optionalOptions()));
            Macro macro = this.macros.get(info.macro());
            if (macro != null) {
                mandatory.addAll(Arrays.asList(macro.mandatoryOptions()));
                optional.addAll(Arrays.asList(macro.optionalOptions()));
            }
            this.subcommands.add(SubCommandXML.parseSubCommandInfo(name, description, mandatory, optional));
        }
        StringBuilder content = SsoadmAP.readFileFromClassPath("/man-ssoadm-1.header");
        for (String subCommand : this.subcommands) {
            content.append(subCommand);
        }
        content.append((CharSequence)SsoadmAP.readFileFromClassPath("/man-ssoadm-1.footer"));
        SsoadmAP.writeFile(this.processingEnv.getOptions().get("outputFile"), content.toString());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder readFileFromClassPath(String path) {
        BufferedReader br = null;
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            br = new BufferedReader(new InputStreamReader(SsoadmAP.class.getResourceAsStream(path)));
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeFile(String path, String content) {
        File file = new File(path);
        file.getParentFile().mkdirs();
        try (PrintWriter pw = null;){
            pw = new PrintWriter(path);
            pw.println(content);
        }
    }
}

