/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.samples.authentication;

import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class Login {
    private String loginIndexName;
    private String orgName;
    private String locale;

    private Login(String loginIndexName, String orgName) {
        this.loginIndexName = loginIndexName;
        this.orgName = orgName;
    }

    private Login(String loginIndexName, String orgName, String locale) {
        this.loginIndexName = loginIndexName;
        this.orgName = orgName;
        this.locale = locale;
    }

    protected AuthContext getAuthContext() throws AuthLoginException {
        AuthContext lc = new AuthContext(this.orgName);
        AuthContext.IndexType indexType = AuthContext.IndexType.MODULE_INSTANCE;
        if (this.locale == null || this.locale.length() == 0) {
            lc.login(indexType, this.loginIndexName);
        } else {
            lc.login(indexType, this.loginIndexName, this.locale);
        }
        Login.debugMessage(this.loginIndexName + ": Obtained login context");
        return lc;
    }

    private void addLoginCallbackMessage(Callback[] callbacks) throws UnsupportedCallbackException {
        int i = 0;
        try {
            for (i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof TextOutputCallback) {
                    this.handleTextOutputCallback((TextOutputCallback)callbacks[i]);
                    continue;
                }
                if (callbacks[i] instanceof NameCallback) {
                    this.handleNameCallback((NameCallback)callbacks[i]);
                    continue;
                }
                if (callbacks[i] instanceof PasswordCallback) {
                    this.handlePasswordCallback((PasswordCallback)callbacks[i]);
                    continue;
                }
                if (callbacks[i] instanceof TextInputCallback) {
                    this.handleTextInputCallback((TextInputCallback)callbacks[i]);
                    continue;
                }
                if (!(callbacks[i] instanceof ChoiceCallback)) continue;
                this.handleChoiceCallback((ChoiceCallback)callbacks[i]);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new UnsupportedCallbackException(callbacks[i], e.getMessage());
        }
    }

    private void handleTextOutputCallback(TextOutputCallback toc) {
        Login.debugMessage("Got TextOutputCallback");
        switch (toc.getMessageType()) {
            case 0: {
                Login.debugMessage(toc.getMessage());
                break;
            }
            case 2: {
                Login.debugMessage("ERROR: " + toc.getMessage());
                break;
            }
            case 1: {
                Login.debugMessage("WARNING: " + toc.getMessage());
                break;
            }
            case 4: {
                Login.debugMessage("SCRIPT: " + toc.getMessage());
                break;
            }
            default: {
                Login.debugMessage("Unsupported message type: " + toc.getMessageType());
            }
        }
    }

    private void handleNameCallback(NameCallback nc) throws IOException {
        System.out.print(nc.getPrompt());
        System.out.flush();
        nc.setName(new BufferedReader(new InputStreamReader(System.in)).readLine());
    }

    private void handleTextInputCallback(TextInputCallback tic) throws IOException {
        System.out.print(tic.getPrompt());
        System.out.flush();
        tic.setText(new BufferedReader(new InputStreamReader(System.in)).readLine());
    }

    private void handlePasswordCallback(PasswordCallback pc) throws IOException {
        System.out.print(pc.getPrompt());
        System.out.flush();
        String passwd = new BufferedReader(new InputStreamReader(System.in)).readLine();
        pc.setPassword(passwd.toCharArray());
    }

    private void handleChoiceCallback(ChoiceCallback cc) throws IOException {
        System.out.print(cc.getPrompt());
        String[] strChoices = cc.getChoices();
        for (int j = 0; j < strChoices.length; ++j) {
            System.out.print("choice[" + j + "] : " + strChoices[j]);
        }
        System.out.flush();
        cc.setSelectedIndex(Integer.parseInt(new BufferedReader(new InputStreamReader(System.in)).readLine()));
    }

    protected boolean login(AuthContext lc) throws UnsupportedCallbackException {
        boolean succeed = false;
        Callback[] callbacks = null;
        while (lc.hasMoreRequirements()) {
            callbacks = lc.getRequirements();
            if (callbacks == null) continue;
            this.addLoginCallbackMessage(callbacks);
            lc.submitRequirements(callbacks);
        }
        if (lc.getStatus() == AuthContext.Status.SUCCESS) {
            System.out.println("Login succeeded.");
            succeed = true;
        } else if (lc.getStatus() == AuthContext.Status.FAILED) {
            System.out.println("Login failed.");
        } else {
            System.out.println("Unknown status: " + lc.getStatus());
        }
        return succeed;
    }

    protected void logout(AuthContext lc) throws AuthLoginException {
        lc.logout();
        System.out.println("Logged Out!!");
    }

    static void debugMessage(String msg) {
        System.out.println(msg);
    }

    public static void main(String[] args) {
        try {
            System.out.print("Realm (e.g. /): ");
            String orgName = new BufferedReader(new InputStreamReader(System.in)).readLine();
            System.out.print("Login module name (e.g. DataStore or LDAP): ");
            String moduleName = new BufferedReader(new InputStreamReader(System.in)).readLine();
            System.out.print("Login locale (e.g. en_US or fr_FR): ");
            String locale = new BufferedReader(new InputStreamReader(System.in)).readLine();
            Login login = new Login(moduleName, orgName, locale);
            AuthContext lc = login.getAuthContext();
            if (login.login(lc)) {
                login.logout(lc);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (AuthLoginException e) {
            e.printStackTrace();
        }
        catch (UnsupportedCallbackException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

