/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.samples.clientsdk.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdType;
import com.sun.identity.samples.clientsdk.idrepo.IdRepoSampleCreateId;
import com.sun.identity.samples.clientsdk.idrepo.IdRepoSampleDeleteId;
import com.sun.identity.samples.clientsdk.idrepo.IdRepoSampleSearchIds;
import com.sun.identity.samples.clientsdk.idrepo.IdRepoSampleSubRealm;
import com.sun.identity.samples.clientsdk.idrepo.IdRepoSampleUtils;
import java.util.Set;

public class IdRepoSample {
    static final String DEF_USERNAME = "amAdmin";
    static final String DEF_USERPWD = "openssoxxx";
    static final String DEF_REALM = "/";
    SSOToken ssoToken = null;
    String currentRealm = "/";
    Set currentSubRealms = null;
    AMIdentityRepository idRepo = null;
    IdRepoSampleUtils sampleUtils = new IdRepoSampleUtils();

    private int printIdRepoMenu() {
        System.out.println("\nCurrently in realm '" + this.currentRealm + "'.");
        this.sampleUtils.printResultsRealm("Realm '" + this.currentRealm + "'", this.currentSubRealms, "subrealms");
        System.out.println("  AMIdentityRepository operations\n\t0:  Select (sub)Realm           1:  Create Identity\n\t2:  Delete Identity             3:  Get Allowed Operations\n\t4:  Get Supported IdTypes       5:  Search/Select Identities\n\t6:  Return to / realm           7:  Exit\n");
        String sval = this.sampleUtils.getLine("Enter selection: ");
        return this.sampleUtils.getIntValue(sval);
    }

    private void doCurrentRealm() {
        String currentAMIdName = null;
        String currentRealmAMIdName = null;
        try {
            this.idRepo = new AMIdentityRepository(this.ssoToken, this.currentRealm);
            AMIdentity currentRealmAMId = this.idRepo.getRealmIdentity();
            currentRealmAMIdName = currentRealmAMId.getRealm();
            currentAMIdName = currentRealmAMId.getName();
        }
        catch (IdRepoException ire) {
            System.err.println("doCurrentRealm:IdRepoException getting AMIdentityRepository object for '" + this.currentRealm + "': " + ire.getMessage());
            System.exit(7);
        }
        catch (SSOException sse) {
            System.err.println("doCurrentRealm: SSOException getting AMIdentityRepository object for '" + this.currentRealm + "': " + sse.getMessage());
            System.exit(8);
        }
        System.out.println("AMIdentity realm name for realm '" + this.currentRealm + "' is '" + currentRealmAMIdName + "'");
        System.out.println("getting subrealms");
        try {
            this.currentSubRealms = this.idRepo.searchIdentities(IdType.REALM, "*", new IdSearchControl()).getSearchResults();
        }
        catch (SSOException ssoe) {
            System.err.println("doCurrentRealm: SSOException getting subrealms for '" + this.currentRealm + "': " + ssoe.getMessage());
        }
        catch (IdRepoException ire) {
            System.err.println("doCurrentRealm: IdRepoException getting subrealms for '" + this.currentRealm + "': " + ire.getMessage());
        }
        this.sampleUtils.printResultsRealm("Realm '" + this.currentRealm + "'", this.currentSubRealms, "subrealms");
    }

    private void idRepoProcessing() {
        String userSID = this.sampleUtils.getLine("Userid", DEF_USERNAME);
        String userPWD = this.sampleUtils.getLine("Userid " + userSID + "'s password", DEF_USERPWD);
        String realmName = this.sampleUtils.getLine("Realm", DEF_REALM);
        try {
            this.ssoToken = this.sampleUtils.realmLogin(userSID, userPWD, realmName);
        }
        catch (SSOException ssoe) {
            System.err.println("idRepoProcessing: could not get SSOToken: " + ssoe.getMessage());
            System.exit(3);
        }
        catch (AuthLoginException ale) {
            System.err.println("idRepoProcessing: could not authenticate: " + ale.getMessage());
            System.exit(4);
        }
        catch (Exception e) {
            System.err.println("idRepoProcessing: exception getting SSOToken: " + e.getMessage());
            System.exit(5);
        }
        this.currentRealm = realmName;
        this.doCurrentRealm();
        int i = -1;
        boolean doMore = true;
        Object ans = null;
        int ians = -1;
        block22: while (doMore) {
            i = this.printIdRepoMenu();
            switch (i) {
                case 0: {
                    IdRepoSampleSubRealm issr = new IdRepoSampleSubRealm(this.currentRealm);
                    String nextSubRealm = issr.selectSubRealm(this.currentSubRealms);
                    if (nextSubRealm == this.currentRealm) continue block22;
                    this.currentRealm = nextSubRealm;
                    this.idRepo = new AMIdentityRepository(this.currentRealm, this.ssoToken);
                    this.doCurrentRealm();
                    continue block22;
                }
                case 1: {
                    IdRepoSampleCreateId isci = new IdRepoSampleCreateId(this.idRepo);
                    isci.createAMId();
                    continue block22;
                }
                case 2: {
                    IdRepoSampleDeleteId isdi = new IdRepoSampleDeleteId(this.idRepo);
                    isdi.deleteAMId();
                    continue block22;
                }
                case 3: {
                    Set types;
                    try {
                        types = this.idRepo.getSupportedIdTypes();
                        IdType itype2 = null;
                        Set ops = null;
                        for (IdType itype2 : types) {
                            ops = this.idRepo.getAllowedIdOperations(itype2);
                            this.sampleUtils.printResults("IdType '" + itype2.getName() + "'", ops, "allowed Identity Operations");
                        }
                        continue block22;
                    }
                    catch (IdRepoException ire) {
                        System.err.println("idRepoProcessing:IdRepoException: " + ire.getMessage());
                        continue block22;
                    }
                    catch (SSOException ssoe) {
                        System.err.println("idRepoProcessing:SSOException: " + ssoe.getMessage());
                        continue block22;
                    }
                }
                case 4: {
                    Set types;
                    try {
                        types = this.idRepo.getSupportedIdTypes();
                        this.sampleUtils.printIdTypeResults("This deployment", types, "supported IdTypes");
                    }
                    catch (IdRepoException ire) {
                        System.err.println("idRepoProcessing:IdRepoException: " + ire.getMessage());
                    }
                    catch (SSOException ssoe) {
                        System.err.println("idRepoProcessing:SSOException: " + ssoe.getMessage());
                    }
                    continue block22;
                }
                case 5: {
                    IdRepoSampleSearchIds issi = new IdRepoSampleSearchIds(this.idRepo);
                    issi.searchAMIds();
                    continue block22;
                }
                case 6: {
                    this.currentRealm = DEF_REALM;
                    this.doCurrentRealm();
                    continue block22;
                }
                case 7: {
                    doMore = false;
                    continue block22;
                }
            }
            System.err.println("Invalid selection; try again.");
        }
        try {
            this.sampleUtils.logout();
        }
        catch (AuthLoginException alexc) {
            System.err.println("idRepoProcessing: logout failed for user '" + userSID + "'");
            alexc.printStackTrace();
            System.exit(10);
        }
        System.out.println("idRepoProcessing: user '" + userSID + "' logged out");
    }

    public static void main(String[] args) {
        IdRepoSample idRS = new IdRepoSample();
        idRS.idRepoProcessing();
        System.exit(0);
    }
}

