/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.samples.clientsdk.idrepo;

import com.iplanet.sso.SSOException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.samples.clientsdk.idrepo.IdRepoSampleUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IdRepoSampleCreateId {
    IdRepoSampleUtils sampleUtils = new IdRepoSampleUtils();
    AMIdentityRepository idRepo = null;
    private static final String AGENT_TYPE_ATTR = "AgentType";
    private static final String WSP_ENDPOINT = "WSPEndpoint";

    public IdRepoSampleCreateId(AMIdentityRepository idrepo) {
        this.idRepo = idrepo;
    }

    public void createAMId() {
        IdType idtype = this.sampleUtils.getIdTypeToCreateOrDelete();
        if (idtype == null) {
            return;
        }
        IdType tmpIdtype = idtype;
        if (idtype.equals((Object)IdType.AGENT)) {
            tmpIdtype = IdType.AGENTONLY;
        }
        try {
            String tmpS;
            IdSearchResults adRes = this.idRepo.searchIdentities(tmpIdtype, "*", new IdSearchControl());
            Set adResSet = adRes.getSearchResults();
            if (!adResSet.isEmpty()) {
                System.out.println("    Current list of " + idtype.getName() + "s:");
                Iterator it = adResSet.iterator();
                while (it.hasNext()) {
                    System.out.println("\t" + ((AMIdentity)it.next()).getName());
                }
            } else {
                System.out.println("    No " + idtype.getName() + "s found.");
            }
            String idName = this.sampleUtils.getLine("Enter idName to create: ");
            HashMap attrs = new HashMap();
            HashSet<String> vals = new HashSet<String>();
            AMIdentity tmpId = null;
            if (idtype.equals((Object)IdType.AGENT)) {
                tmpS = this.sampleUtils.getLine(idName + "'s password: ");
                vals = new HashSet();
                vals.add(tmpS);
                attrs.put("userpassword", vals);
                tmpId = this.idRepo.createIdentity(IdType.AGENTONLY, idName, attrs);
                idtype = IdType.AGENTONLY;
            } else if (idtype.equals((Object)IdType.AGENTONLY) || idtype.equals((Object)IdType.AGENTGROUP)) {
                tmpS = this.sampleUtils.getLine(idName + "'s agentType: ");
                vals.add(tmpS);
                attrs.put(AGENT_TYPE_ATTR, vals);
                tmpS = this.sampleUtils.getLine(idName + "'s password: ");
                vals = new HashSet();
                vals.add(tmpS);
                attrs.put("userpassword", vals);
                tmpId = this.idRepo.createIdentity(idtype, idName, attrs);
            } else if (idtype.equals((Object)IdType.USER)) {
                tmpS = this.sampleUtils.getLine(idName + "'s password: ");
                vals.add(tmpS);
                attrs.put("userpassword", vals);
                vals = new HashSet();
                tmpS = this.sampleUtils.getLine(idName + "'s last name: ");
                vals.add(tmpS);
                attrs.put("sn", vals);
                vals = new HashSet();
                vals.add(idName + " " + tmpS);
                attrs.put("cn", vals);
                vals = new HashSet();
                vals.add(idName);
                attrs.put("givenname", vals);
                tmpId = this.idRepo.createIdentity(IdType.USER, idName, attrs);
            } else if (idtype.equals((Object)IdType.REALM)) {
                tmpS = this.sampleUtils.getLine(idName + " active/inactive [a,i]: ");
                String actVal = "Active";
                if (tmpS.startsWith("i")) {
                    actVal = "Inactive";
                }
                vals.add(actVal);
                attrs.put("sunOrganizationStatus", vals);
                tmpId = this.idRepo.createIdentity(IdType.REALM, idName, attrs);
            }
            if (tmpId != null) {
                System.out.println("    Created " + idtype.getName() + " identity '" + idName + "' isExists = " + tmpId.isExists());
                adRes = this.idRepo.searchIdentities(idtype, "*", new IdSearchControl());
                adResSet = adRes.getSearchResults();
                if (!adResSet.isEmpty()) {
                    System.out.println("    Current list of " + idtype.getName() + "s:");
                    Iterator it = adResSet.iterator();
                    while (it.hasNext()) {
                        System.out.println("\t" + ((AMIdentity)it.next()).getName());
                    }
                } else {
                    System.out.println("    Odd, no " + idtype.getName() + "s found.");
                }
                IdSearchControl WSCcontrol = new IdSearchControl();
                String providerName = idName;
                WSCcontrol.setAllReturnAttributes(true);
                IdSearchResults WSCresults = this.idRepo.searchIdentities(IdType.AGENTONLY, providerName, WSCcontrol);
                Set agents = WSCresults.getSearchResults();
                System.out.println("WSC Agents before removeMember: " + agents);
                if (idtype.equals((Object)IdType.AGENTONLY) || idtype.equals((Object)IdType.AGENTGROUP)) {
                    String POLLINT = "com.sun.am.policy.am.polling.interval";
                    Map attrMap = null;
                    String name = null;
                    Object type = null;
                    name = tmpId.getName();
                    attrMap = tmpId.getAttributes();
                    if (!attrMap.isEmpty()) {
                        Set keySet = attrMap.keySet();
                        for (String key : keySet) {
                            if (key.equalsIgnoreCase(POLLINT)) {
                                System.out.println("Value before removeAttribute: " + POLLINT + "=" + attrMap.get(POLLINT));
                                HashSet<String> attrNameSet = null;
                                attrNameSet = new HashSet<String>();
                                attrNameSet.add(key);
                                System.out.println("Attribute to remove :" + key);
                                tmpId.removeAttributes(attrNameSet);
                            }
                            if (!key.equalsIgnoreCase("userpassword")) continue;
                            System.out.println("Value check for pwd userpassword =" + attrMap.get("userpassword"));
                        }
                    } else {
                        System.out.println(name + " has no attributes.");
                    }
                    attrMap = tmpId.getAttributes();
                    if (!attrMap.isEmpty()) {
                        System.out.println("Has key after removeAttribute : " + POLLINT + " : true/false :" + attrMap.keySet().contains(POLLINT));
                        if (attrMap.keySet().contains(POLLINT)) {
                            System.out.println("Value after removeAttribute : " + POLLINT + "=" + attrMap.get(POLLINT));
                        }
                    }
                    vals = new HashSet();
                    vals.add("WebAgent");
                    attrs.put(AGENT_TYPE_ATTR, vals);
                    AMIdentity agroupIdentity = null;
                    if (!tmpId.getType().equals((Object)IdType.AGENTGROUP)) {
                        System.out.println("\nChecking membership operations");
                        IdSearchResults res = this.idRepo.searchIdentities(IdType.AGENTGROUP, "myagrp", new IdSearchControl());
                        Set resSet = res.getSearchResults();
                        if (!resSet.isEmpty()) {
                            Iterator iter = resSet.iterator();
                            if (iter.hasNext()) {
                                agroupIdentity = (AMIdentity)iter.next();
                            }
                        } else {
                            agroupIdentity = this.idRepo.createIdentity(IdType.AGENTGROUP, "myagrp", attrs);
                        }
                        System.out.println("Obtained agent group =" + agroupIdentity.getName());
                        System.out.println("\nAdding member to agent group: " + tmpId.getName());
                        agroupIdentity.addMember(tmpId);
                        System.out.println("\nGetting member from agent group: " + agroupIdentity.getMembers(IdType.AGENTONLY));
                        Set agentgroupsOfAgent = tmpId.getMemberships(IdType.AGENTGROUP);
                        System.out.println("Agent's agentGroup memberships = ");
                        for (AMIdentity id : agentgroupsOfAgent) {
                            System.out.println("AgentGroup of agent = " + id.getName());
                            System.out.println("AgentGroup of agent isExists: " + id.isExists());
                        }
                        System.out.println("\nRemoving member from agent group: " + tmpId.getName());
                        agroupIdentity.removeMember(tmpId);
                        System.out.println("\nAfter removeMember : Getting member from agent group: " + agroupIdentity.getMembers(IdType.AGENTONLY));
                    }
                }
                IdSearchControl WSCcnt = new IdSearchControl();
                WSCcnt.setAllReturnAttributes(true);
                IdSearchResults WSCres = this.idRepo.searchIdentities(IdType.AGENTONLY, providerName, WSCcnt);
                Set wscagents = WSCres.getSearchResults();
                System.out.println("WSC Agents after removeMember: " + wscagents);
                IdSearchControl avcontrol = new IdSearchControl();
                avcontrol.setAllReturnAttributes(true);
                avcontrol.setTimeOut(0);
                HashMap kvPairMap = new HashMap();
                HashSet<String> avset = new HashSet<String>();
                avset.add("WSCAgent");
                kvPairMap.put(AGENT_TYPE_ATTR, avset);
                avcontrol.setSearchModifiers(IdSearchOpModifier.OR, kvPairMap);
                IdSearchResults avresults = this.idRepo.searchIdentities(IdType.AGENTONLY, "*", avcontrol);
                Set avagents = avresults.getSearchResults();
                System.out.println("WSC Agents with avpairs as filter: " + avagents);
                IdSearchControl wspcontrol = new IdSearchControl();
                wspcontrol.setAllReturnAttributes(true);
                wspcontrol.setTimeOut(0);
                HashMap wspkvPairMap = new HashMap();
                HashSet<String> wspset = new HashSet<String>();
                wspset.add("WSPAgent");
                wspkvPairMap.put(AGENT_TYPE_ATTR, wspset);
                wspset = new HashSet();
                String endpoint = "testendpoint1";
                wspset.add(endpoint);
                wspkvPairMap.put(WSP_ENDPOINT, wspset);
                wspcontrol.setSearchModifiers(IdSearchOpModifier.OR, wspkvPairMap);
                IdSearchResults wspresults = this.idRepo.searchIdentities(IdType.AGENTONLY, "*", wspcontrol);
                Set wspagents = wspresults.getSearchResults();
                System.out.println("WSP Agents with avpairs as filter: " + wspagents);
            }
        }
        catch (IdRepoException ire) {
            System.err.println("idRepoProcessing IdRepoException creating '" + idtype + "': " + ire.getMessage());
        }
        catch (SSOException ssoe) {
            System.err.println("idRepoProcessing: SSOException creating '" + idtype + "': " + ssoe.getMessage());
        }
    }
}

