/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.samples.clientsdk.idrepo;

import com.iplanet.sso.SSOException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.samples.clientsdk.idrepo.IdRepoSampleUtils;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class IdRepoSampleDeleteId {
    IdRepoSampleUtils sampleUtils = new IdRepoSampleUtils();
    AMIdentityRepository idRepo = null;

    public IdRepoSampleDeleteId(AMIdentityRepository idrepo) {
        this.idRepo = idrepo;
    }

    public void deleteAMId() {
        IdType idtype = this.sampleUtils.getIdTypeToCreateOrDelete();
        if (idtype == null) {
            return;
        }
        if (idtype.equals((Object)IdType.AGENT)) {
            System.out.println("Use IdType 'agentonly' for deletion of agents.\nOnly operation supported for IdType 'agent' is READ");
            return;
        }
        try {
            IdSearchResults adRes = this.idRepo.searchIdentities(idtype, "*", new IdSearchControl());
            Set adResSet = adRes.getSearchResults();
            System.out.println("Found " + adResSet.size() + " entries of type " + idtype.getName() + ".");
            AMIdentity amid = null;
            if (adResSet.size() > 0) {
                int i;
                String ans = null;
                Object[] ids = adResSet.toArray();
                System.out.println("AMIdentities:");
                for (i = 0; i < ids.length; ++i) {
                    amid = (AMIdentity)ids[i];
                    System.out.println("\t" + i + ": " + amid.getName());
                }
                System.out.println("\t" + i + ": No selection");
                ans = this.sampleUtils.getLine("Select id: [0.." + ids.length + "]: ");
                i = this.sampleUtils.getIntValue(ans);
                if (i == ids.length) {
                    return;
                }
                if (i < 0 || i > ids.length) {
                    System.err.println(ans + " is an invalid selection.");
                    return;
                }
                amid = (AMIdentity)ids[i];
                boolean doAnyway = false;
                String tmpS = amid.getName().toLowerCase();
                if (amid.getType().equals((Object)IdType.USER)) {
                    if (tmpS.equals("dsameuser") || tmpS.equals("amadmin") || tmpS.equals("amservice-urlaccessagent") || tmpS.equals("anonymous")) {
                        System.out.println("VERY BAD idea deleting user " + amid.getName());
                    } else {
                        doAnyway = true;
                    }
                } else {
                    doAnyway = amid.getType().equals((Object)IdType.REALM) ? true : true;
                }
                if (doAnyway) {
                    HashSet<AMIdentity> tmpSet = new HashSet<AMIdentity>();
                    tmpSet.add(amid);
                    this.idRepo.deleteIdentities(tmpSet);
                } else {
                    System.out.println("Not deleting " + amid.getName());
                }
            } else {
                System.out.println("No identities of type " + idtype.getName() + " found.");
            }
            adRes = this.idRepo.searchIdentities(idtype, "*", new IdSearchControl());
            adResSet = adRes.getSearchResults();
            System.out.print("    Current list of " + idtype.getName() + "s");
            if (!adResSet.isEmpty()) {
                System.out.println(":");
                Iterator it = adResSet.iterator();
                while (it.hasNext()) {
                    System.out.println("\t" + ((AMIdentity)it.next()).getName());
                }
            } else {
                System.out.println(" is empty");
            }
        }
        catch (IdRepoException ire) {
            System.err.println("idRepoProcessing: IdRepoException Deleting Identity: " + ire.getMessage());
        }
        catch (SSOException ssoe) {
            System.err.println("idRepoProcessing: SSOException Deleting Identity: " + ssoe.getMessage());
        }
    }
}

