/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.samples.clientsdk.logging;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import java.io.IOException;
import java.util.Hashtable;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;

public class LogSampleUtils {
    public SSOToken realmLogin(String userid, String password, AuthContext ac) throws SSOException, AuthLoginException, Exception {
        SSOToken ssoToken = null;
        String userID = null;
        try {
            ac.login();
        }
        catch (AuthLoginException le) {
            System.err.println("LogSampleUtils: Failed to start login for default auth module.");
            throw le;
        }
        userID = userid;
        Callback[] callbacks = null;
        Hashtable<String, String> values = new Hashtable<String, String>();
        values.put("NameCallback", userid);
        values.put("PasswordCallback", password);
        while (ac.hasMoreRequirements()) {
            callbacks = ac.getRequirements();
            try {
                this.fillCallbacks(callbacks, values);
                ac.submitRequirements(callbacks);
            }
            catch (Exception e) {
                System.err.println("Failed to submit callbacks!");
                e.printStackTrace();
                return null;
            }
        }
        AuthContext.Status istat = ac.getStatus();
        if (istat == AuthContext.Status.SUCCESS) {
            System.out.println("==>Authentication SUCCESSFUL for user " + userid);
        } else if (istat == AuthContext.Status.COMPLETED) {
            System.out.println("==>Authentication Status for user " + userid + " = " + istat);
            return null;
        }
        try {
            ssoToken = ac.getSSOToken();
        }
        catch (Exception e) {
            System.err.println("Failed to get SSO token!");
            throw e;
        }
        return ssoToken;
    }

    protected void fillCallbacks(Callback[] callbacks, Hashtable values) throws Exception {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                nc.setName((String)values.get("NameCallback"));
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(((String)values.get("PasswordCallback")).toCharArray());
                continue;
            }
            if (callbacks[i] instanceof TextInputCallback) {
                TextInputCallback tic = (TextInputCallback)callbacks[i];
                tic.setText((String)values.get("TextInputCallback"));
                continue;
            }
            if (!(callbacks[i] instanceof ChoiceCallback)) continue;
            ChoiceCallback cc = (ChoiceCallback)callbacks[i];
            cc.setSelectedIndex(Integer.parseInt((String)values.get("ChoiceCallback")));
        }
    }

    public String getLine() {
        StringBuffer buf = new StringBuffer(80);
        try {
            int c;
            while ((c = System.in.read()) != -1) {
                char ch = (char)c;
                if (ch == '\r') continue;
                if (ch != '\n') {
                    buf.append(ch);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.err.println("getLine: " + e.getMessage());
        }
        return buf.toString();
    }

    public String getLine(String prompt) {
        System.out.print(prompt);
        return this.getLine();
    }

    public String getLine(String prompt, String defaultVal) {
        System.out.print(prompt + " [" + defaultVal + "]: ");
        String tmp = this.getLine();
        if (tmp.length() == 0) {
            tmp = defaultVal;
        }
        return tmp;
    }

    public int getIntValue(String sVal) {
        int i = -1;
        try {
            i = Integer.parseInt(sVal);
        }
        catch (NumberFormatException e) {
            System.err.println("'" + sVal + "' does not appear to be an integer.");
        }
        return i;
    }
}

