/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.samples.sso;

import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class CommandLineSSO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        String orgName = args[0];
        System.out.println("Organization: " + orgName);
        SSOTokenManager manager = SSOTokenManager.getInstance();
        AuthContext lc = CommandLineSSO.getAuthcontext(orgName);
        if (lc.getStatus() == AuthContext.Status.SUCCESS) {
            System.out.println("Successful authentication ...");
            SSOToken token = lc.getSSOToken();
            String userDN = token.getPrincipal().getName();
            System.out.println("User Name: " + userDN);
            try {
                AMIdentity userIdentity = IdUtils.getIdentity((SSOToken)token);
                Map attrs = userIdentity.getAttributes();
                System.out.println("User Attributes: ");
                for (String attrName : attrs.keySet()) {
                    Set values = (Set)attrs.get(attrName);
                    System.out.println(attrName + "=" + values);
                }
            }
            catch (IdRepoException e) {
                e.printStackTrace();
            }
            finally {
                manager.destroyToken(token);
            }
        } else {
            System.out.println("Authentication Failed ....... ");
        }
        System.exit(0);
    }

    private static AuthContext getAuthcontext(String orgName) throws AuthLoginException, IOException {
        AuthContext lc = new AuthContext(orgName);
        AuthContext.IndexType indexType = AuthContext.IndexType.MODULE_INSTANCE;
        String indexName = "DataStore";
        System.out.println("DataStore: Obtained login context");
        lc.login(indexType, indexName);
        Callback[] callback = lc.getRequirements();
        for (int i = 0; i < callback.length; ++i) {
            if (callback[i] instanceof NameCallback) {
                NameCallback name = (NameCallback)callback[i];
                System.out.print(name.getPrompt());
                name.setName(new BufferedReader(new InputStreamReader(System.in)).readLine());
                continue;
            }
            if (!(callback[i] instanceof PasswordCallback)) continue;
            PasswordCallback pass = (PasswordCallback)callback[i];
            System.out.print(pass.getPrompt());
            String password = new BufferedReader(new InputStreamReader(System.in)).readLine();
            pass.setPassword(password.toCharArray());
        }
        lc.submitRequirements(callback);
        return lc;
    }
}

