/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.samples.clientsdk.idrepo;

import com.iplanet.sso.SSOException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.samples.clientsdk.idrepo.IdRepoSampleUtils;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IdRepoSampleGetSpecialIds {
    IdRepoSampleUtils sampleUtils = new IdRepoSampleUtils();
    AMIdentityRepository idRepo = null;

    public IdRepoSampleGetSpecialIds(AMIdentityRepository idrepo) {
        this.idRepo = idrepo;
    }

    public void getSpecialIds() {
        try {
            IdSearchResults isr = null;
            Set isrSet = null;
            Map isrMap = null;
            isr = this.idRepo.getSpecialIdentities(IdType.ROLE);
            isrSet = isr.getSearchResults();
            isrMap = isr.getResultAttributes();
            this.processSpecialIdentity(isrMap, isrSet, "Special Roles");
            this.sampleUtils.waitForReturn("Hit <return> to get special users: ");
            isr = this.idRepo.getSpecialIdentities(IdType.USER);
            isrSet = isr.getSearchResults();
            isrMap = isr.getResultAttributes();
            this.processSpecialIdentity(isrMap, isrSet, "Special Users");
            this.sampleUtils.waitForReturn("Hit <return> to get special groups: ");
            isr = this.idRepo.getSpecialIdentities(IdType.GROUP);
            isrSet = isr.getSearchResults();
            isrMap = isr.getResultAttributes();
            this.processSpecialIdentity(isrMap, isrSet, "Special Groups");
            this.sampleUtils.waitForReturn("Hit <return> to get special agents: ");
            isr = this.idRepo.getSpecialIdentities(IdType.AGENT);
            isrSet = isr.getSearchResults();
            isrMap = isr.getResultAttributes();
            this.processSpecialIdentity(isrMap, isrSet, "Special Agents");
            this.sampleUtils.waitForReturn("Hit <return> to get special realms: ");
            isr = this.idRepo.getSpecialIdentities(IdType.REALM);
            isrSet = isr.getSearchResults();
            isrMap = isr.getResultAttributes();
            this.processSpecialIdentity(isrMap, isrSet, "Special Realms");
            this.sampleUtils.waitForReturn("Hit <return> to get special filtered roles: ");
            isr = this.idRepo.getSpecialIdentities(IdType.FILTEREDROLE);
            isrSet = isr.getSearchResults();
            isrMap = isr.getResultAttributes();
            this.processSpecialIdentity(isrMap, isrSet, "Special Filtered Roles");
        }
        catch (IdRepoException ire) {
            System.err.println("idRepoProcessing:IdRepoException: " + ire.getMessage());
        }
        catch (SSOException ssoe) {
            System.err.println("idRepoProcessing:SSOException: " + ssoe.getMessage());
        }
    }

    private void processSpecialIdentity(Map isrMap, Set isrSet, String title) {
        this.printMap(isrMap, title + " (" + isrMap.size() + ")");
        System.out.println("");
        this.sampleUtils.waitForReturn("Hit <return> to continue display of " + title + ": ");
        if (!isrSet.isEmpty()) {
            System.out.println(title + ":");
            AMIdentity am_id = null;
            Iterator it = isrSet.iterator();
            while (it.hasNext()) {
                try {
                    am_id = (AMIdentity)it.next();
                    System.out.println("  For '" + am_id.getName() + "':");
                    System.out.println("    realm: " + am_id.getRealm() + "\n    type: " + am_id.getType() + "\n    universalId: " + am_id.getUniversalId() + "\n    active: " + am_id.isActive() + "\n    exists: " + am_id.isExists() + "\n");
                }
                catch (IdRepoException ire) {
                    System.err.println("processSpecialIdentity:IdRepoException: " + ire.getMessage());
                }
                catch (SSOException ssoe) {
                    System.err.println("processSpecialIdentity:SSOException: " + ssoe.getMessage());
                }
            }
        } else {
            System.out.println("No " + title);
        }
    }

    private void printMap(Map theMap, String title) {
        if (theMap == null) {
            System.out.println("Null Map of " + title);
        } else if (theMap.isEmpty()) {
            System.out.println("Map of " + title + " is empty");
        } else {
            Set keySet = theMap.keySet();
            System.out.println(title);
            Object obj2 = null;
            Object val = null;
            AMIdentity ami = null;
            Map vMap = null;
            Set vSet = null;
            for (Object obj2 : keySet) {
                ami = obj2;
                System.out.println("  " + ami.getName());
                val = theMap.get(ami);
                if (val != null) {
                    vMap = val;
                    vSet = vMap.keySet();
                    System.out.println("    Attributes for " + ami.getName() + ":");
                    Object obj222 = null;
                    Object obj3 = null;
                    Object obj42 = null;
                    Set o3Set = null;
                    for (Object obj222 : vSet) {
                        System.out.println("    " + obj222);
                        obj3 = vMap.get(obj222);
                        o3Set = obj3;
                        System.out.println("      Value(s) for " + obj222 + ":");
                        if (o3Set.isEmpty()) {
                            System.out.println("      [NONE]");
                        }
                        for (Object obj42 : o3Set) {
                            System.out.println("      " + obj42);
                        }
                    }
                    continue;
                }
                System.out.println("theMap.get(ami) rtns null");
            }
        }
    }
}

