/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.samples.clientsdk.idrepo;

import com.iplanet.sso.SSOException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdSearchControl;
import com.sun.identity.idm.IdSearchOpModifier;
import com.sun.identity.idm.IdSearchResults;
import com.sun.identity.idm.IdType;
import com.sun.identity.samples.clientsdk.idrepo.IdRepoSampleUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class IdRepoSampleSearchIds {
    IdRepoSampleUtils sampleUtils = new IdRepoSampleUtils();
    AMIdentityRepository idRepo = null;

    public IdRepoSampleSearchIds(AMIdentityRepository idrepo) {
        this.idRepo = idrepo;
    }

    public void searchAMIds() {
        IdType idtype = this.sampleUtils.getIdType(this.idRepo);
        if (idtype == null) {
            return;
        }
        IdSearchControl isc = new IdSearchControl();
        isc.setAllReturnAttributes(true);
        String pattern = this.sampleUtils.getLine("    Enter search pattern", "*");
        try {
            IdSearchResults adRes = this.idRepo.searchIdentities(idtype, pattern, isc);
            Set adResSet = adRes.getSearchResults();
            this.processType(idtype, adResSet);
            IdSearchControl control = new IdSearchControl();
            control.setAllReturnAttributes(true);
            control.setTimeOut(0);
            HashMap kvPairMap = new HashMap();
            HashSet<String> set = new HashSet<String>();
            set.add("STSAgent");
            kvPairMap.put("AgentType", set);
            control.setSearchModifiers(IdSearchOpModifier.OR, kvPairMap);
            IdSearchResults results = this.idRepo.searchIdentities(IdType.AGENTONLY, "*", control);
            Set agents = results.getSearchResults();
            System.out.println("Listing agents for STSAgent " + agents);
        }
        catch (IdRepoException ire) {
            System.err.println("idRepoProcessing: IdRepoException Searching Identities for '" + idtype + "' and pattern '" + pattern + "': " + ire.getMessage());
        }
        catch (SSOException ssoe) {
            System.err.println("idRepoProcessing: SSOException Searching Identities for '" + idtype + "' and pattern '" + pattern + "': " + ssoe.getMessage());
        }
    }

    private void processType(IdType idtype, Set idSet) {
        Object[] objs = idSet.toArray();
        AMIdentity amid = null;
        Object amid2 = null;
        int setsize = idSet.size();
        if (setsize > 0) {
            int i;
            System.out.println("Search returns " + setsize + " entries of type " + idtype.getName() + ".");
            for (i = 0; i < setsize; ++i) {
                amid = (AMIdentity)objs[i];
                System.out.println("\t" + i + ": " + amid.getName());
            }
            System.out.println("\t" + i + ": No selection");
            String answer = this.sampleUtils.getLine("Select identity: [0.." + setsize + "]: ");
            int ians = this.sampleUtils.getIntValue(answer);
            try {
                if (ians < 0 || ians >= setsize) {
                    if (ians == setsize) {
                        return;
                    }
                    System.err.println("'" + answer + "' is invalid.");
                    return;
                }
                amid = (AMIdentity)objs[ians];
                System.out.println(" universalId for " + amid.getName() + " of IdType " + idtype.getName() + " = " + amid.getUniversalId());
                if (idtype.equals((Object)IdType.GROUP)) {
                    System.out.println("Members of IdType User of Group '" + amid.getName() + "':");
                    this.printMembers(amid, IdType.USER);
                    this.printAttrs(amid);
                } else if (idtype.equals((Object)IdType.ROLE)) {
                    this.printAttrs(amid);
                } else if (idtype.equals((Object)IdType.USER)) {
                    String thisUser = amid.getName();
                    System.out.println("User '" + thisUser + "' is active: " + amid.isActive());
                    if (thisUser.equalsIgnoreCase("amadmin") || thisUser.equalsIgnoreCase("dsameuser") || thisUser.equalsIgnoreCase("amService-URLAccessAgent")) {
                        System.out.println("User '" + amid.getName() + "' exists: " + amid.isExists());
                        Set idtypes = amid.getType().canBeMemberOf();
                        System.out.println(amid.getName() + " can have (and has) membership in identities of the following types:");
                        IdType idTypeToUse2 = null;
                        Set memberships = null;
                        for (IdType idTypeToUse2 : idtypes) {
                            System.out.println("  can be member of " + idTypeToUse2.getName());
                            memberships = amid.getMemberships(idTypeToUse2);
                            this.printMemberships(amid, idTypeToUse2, memberships);
                        }
                        this.printAttrs(amid);
                    } else {
                        answer = this.sampleUtils.getLine("Set user active, inactive, or cancel [a,i,c]: ");
                        if (answer.startsWith("a")) {
                            if (amid.isActive()) {
                                System.out.println("User '" + thisUser + "' already active");
                            } else {
                                amid.setActiveStatus(true);
                                System.out.println("User '" + thisUser + "' is active: " + amid.isActive());
                            }
                        } else if (answer.startsWith("i")) {
                            if (!amid.isActive()) {
                                System.out.println("User '" + thisUser + "' already inactive");
                            } else {
                                amid.setActiveStatus(false);
                                System.out.println("User '" + thisUser + "' is active: " + amid.isActive());
                            }
                        }
                        System.out.println("User '" + amid.getName() + "' exists: " + amid.isExists());
                        Set idtypes = amid.getType().canBeMemberOf();
                        System.out.println(amid.getName() + " can have (and has) membership in identities of the following types:");
                        IdType idTypeToUse3 = null;
                        Set memberships = null;
                        for (IdType idTypeToUse3 : idtypes) {
                            System.out.println("  can be member of " + idTypeToUse3.getName());
                            memberships = amid.getMemberships(idTypeToUse3);
                            this.printMemberships(amid, idTypeToUse3, memberships);
                        }
                        this.printAttrs(amid);
                        System.out.println("Operations available on User '" + amid.getName() + "':");
                        System.out.println("\tl: List groups or roles\n\td: Display attributes\n\ts: Set attribute\n\te: No selection");
                        answer = this.sampleUtils.getLine("Enter selection [l, d, s, e]: ");
                        if (answer.toLowerCase().startsWith("d")) {
                            this.printAttrs(amid);
                        } else if (answer.toLowerCase().startsWith("s")) {
                            this.setAttribute(amid);
                        } else if (answer.toLowerCase().startsWith("l")) {
                            this.listGrpOrRoleOfUser(amid);
                        } else if (!answer.toLowerCase().startsWith("e")) {
                            System.err.println("'" + answer + "' is invalid.");
                        }
                    }
                } else if (idtype.equals((Object)IdType.AGENT) || idtype.equals((Object)IdType.AGENTONLY)) {
                    String thisAgent = amid.getName();
                    System.out.println("Agent '" + thisAgent + "' exists: " + amid.isExists());
                    System.out.println("Agent '" + thisAgent + "' is active: " + amid.isActive());
                    answer = this.sampleUtils.getLine("Set agent active, inactive, or cancel [a,i,c]: ");
                    if (answer.startsWith("a")) {
                        if (amid.isActive()) {
                            System.out.println("Agent '" + thisAgent + "' already active");
                        } else {
                            amid.setActiveStatus(true);
                            System.out.println("Agent '" + thisAgent + "' is active: " + amid.isActive());
                        }
                    } else if (answer.startsWith("i")) {
                        if (!amid.isActive()) {
                            System.out.println("Agent '" + thisAgent + "' already inactive");
                        } else {
                            amid.setActiveStatus(false);
                            System.out.println("Agent '" + thisAgent + "' is active: " + amid.isActive());
                        }
                    }
                    this.printAttrs(amid);
                    this.setAttribute(amid);
                }
            }
            catch (IdRepoException ire) {
                System.err.println("processType:IdRepoException: " + ire.getMessage());
            }
            catch (SSOException ssoe) {
                System.err.println("processType:SSOException: " + ssoe.getMessage());
            }
        } else {
            System.out.println("No identities of type '" + idtype.getName() + "' found to process.");
        }
    }

    private void printAttrs(AMIdentity amid) {
        block7: {
            Map attrMap = null;
            String name = null;
            String type = null;
            try {
                name = amid.getName();
                type = amid.getType().getName();
                attrMap = amid.getAttributes();
                if (!attrMap.isEmpty()) {
                    Set keySet = attrMap.keySet();
                    Set valSet = null;
                    System.out.println(type + ":" + name + "'s Attributes:");
                    for (String key : keySet) {
                        System.out.print("    attr '" + key + "' ");
                        valSet = (Set)attrMap.get(key);
                        if (valSet.size() > 0) {
                            System.out.println("=");
                            Iterator it2 = valSet.iterator();
                            while (it2.hasNext()) {
                                System.out.println("\t" + (String)it2.next());
                            }
                            continue;
                        }
                        System.out.println("has no values.");
                    }
                    break block7;
                }
                System.out.println(name + " has no attributes.");
            }
            catch (IdRepoException ire) {
                System.err.println("printAttrs:IdRepoException: " + ire.getMessage());
            }
            catch (SSOException ssoe) {
                System.err.println("printAttrs:SSOException: " + ssoe.getMessage());
            }
        }
    }

    private void printMembers(AMIdentity amid, IdType typeToGet) {
        try {
            IdType amidType = amid.getType();
            String amidTypeName = amidType.getName();
            Iterator it = amid.getMembers(typeToGet).iterator();
            if (it.hasNext()) {
                System.out.println(amidTypeName + " " + amid.getName() + "'s members:");
                while (it.hasNext()) {
                    System.out.println("   " + ((AMIdentity)it.next()).getName());
                }
            } else {
                System.out.println(amidType + " " + amid.getName() + " has no members.");
            }
        }
        catch (IdRepoException ire) {
            System.err.println("printMembers:IdRepoException: " + ire.getMessage());
        }
        catch (SSOException ssoe) {
            System.err.println("printMembers:SSOException: " + ssoe.getMessage());
        }
    }

    private void printMemberships(AMIdentity amid, IdType idTypeToUse, Set memberships) {
        if (memberships == null || memberships.size() == 0) {
            System.out.println("  " + amid.getName() + " has no memberships in identities of IdType " + idTypeToUse.getName());
            return;
        }
        Iterator it = memberships.iterator();
        if (it.hasNext()) {
            System.out.println("  " + amid.getName() + " has membership in identities of IdType " + idTypeToUse.getName() + " named: ");
            while (it.hasNext()) {
                System.out.println("   " + ((AMIdentity)it.next()).getName());
            }
        } else {
            System.out.println("  " + amid.getName() + " has no memberships in identities of IdType " + idTypeToUse.getName());
        }
    }

    private void setAttribute(AMIdentity amid) {
        Map attrMap = null;
        String name = null;
        String type = null;
        try {
            name = amid.getName();
            type = amid.getType().getName();
            attrMap = amid.getAttributes();
            if (!attrMap.isEmpty()) {
                Set keySet = attrMap.keySet();
                Object[] attrArray = keySet.toArray();
                int i = this.sampleUtils.selectFromArray(attrArray, type + ":" + name + "'s Attributes", "Select attribute to set");
                String attrToSet = null;
                if (i >= 0 && i < keySet.size()) {
                    attrToSet = (String)attrArray[i];
                    System.out.println("To set attribute " + attrToSet);
                    Set oldVal = amid.getAttribute(attrToSet);
                    System.out.print("  Current value = [");
                    if (oldVal.isEmpty()) {
                        System.out.println("Empty]");
                    } else {
                        Iterator it = oldVal.iterator();
                        while (it.hasNext()) {
                            System.out.print((String)it.next());
                            if (!it.hasNext()) continue;
                            System.out.print(" ");
                        }
                        System.out.println("]");
                    }
                    String newVal = this.sampleUtils.getLine("New value for " + attrToSet + ": ");
                    HashMap nattrs = new HashMap();
                    HashSet<String> valSet = new HashSet<String>();
                    valSet.add(newVal);
                    nattrs.put(attrToSet, valSet);
                    amid.setAttributes(nattrs);
                    amid.store();
                    oldVal = amid.getAttribute(attrToSet);
                    System.out.print("  Updated value = [");
                    if (oldVal.isEmpty()) {
                        System.out.println("Empty]");
                    } else {
                        Iterator it = oldVal.iterator();
                        while (it.hasNext()) {
                            System.out.print((String)it.next());
                            if (!it.hasNext()) continue;
                            System.out.print(" ");
                        }
                        System.out.println("]");
                    }
                }
            } else {
                System.out.println(name + " has no attributes.");
            }
        }
        catch (IdRepoException ire) {
            System.err.println("setAttrs:IdRepoException: " + ire.getMessage());
        }
        catch (SSOException ssoe) {
            System.err.println("setAttrs:SSOException: " + ssoe.getMessage());
        }
    }

    private void listGrpOrRoleOfUser(AMIdentity amid) {
        Object typeToGet = null;
        Set tSet = null;
        String hdr = null;
        String ans = this.sampleUtils.getLine("Groups, or Roles to list [g, r]: ");
        String ans2 = ans.toLowerCase();
        try {
            String trlr = null;
            hdr = "User " + amid.getName();
            if (ans2.startsWith("g")) {
                tSet = amid.getMemberships(IdType.GROUP);
                trlr = "group memberships";
            } else if (ans2.startsWith("r")) {
                tSet = amid.getMemberships(IdType.ROLE);
                trlr = "role memberships";
            }
            this.sampleUtils.printResults(hdr, tSet, trlr);
        }
        catch (IdRepoException ire) {
            System.err.println("listGrpOrRoleOfUser:IdRepoException: " + ire.getMessage());
        }
        catch (SSOException ssoe) {
            System.err.println("listGrpOrRoleOfUser:SSOException: " + ssoe.getMessage());
        }
    }
}

