/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.samples.clientsdk.idrepo;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.AMIdentityRepository;
import com.sun.identity.idm.IdRepoException;
import com.sun.identity.idm.IdType;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;

public class IdRepoSampleUtils {
    AuthContext lc = null;
    String userID = null;

    public SSOToken realmLogin(String userid, String password, String realm) throws SSOException, AuthLoginException, Exception {
        SSOToken ssoToken = null;
        AuthContext.IndexType authType = AuthContext.IndexType.MODULE_INSTANCE;
        try {
            this.lc = new AuthContext(realm);
        }
        catch (AuthLoginException le) {
            System.err.println("IdRepoSampleUtils: could not get AuthContext for realm " + realm);
            throw le;
        }
        try {
            this.lc.login();
        }
        catch (AuthLoginException le) {
            System.err.println("IdRepoSampleUtils: Failed to start login for default authmodule");
            throw le;
        }
        this.userID = userid;
        Callback[] callbacks = null;
        Hashtable<String, String> values = new Hashtable<String, String>();
        values.put("NameCallback", userid);
        values.put("PasswordCallback", password);
        while (this.lc.hasMoreRequirements()) {
            callbacks = this.lc.getRequirements();
            try {
                this.fillCallbacks(callbacks, values);
                this.lc.submitRequirements(callbacks);
            }
            catch (Exception e) {
                System.err.println("Failed to submit callbacks!");
                e.printStackTrace();
                return null;
            }
        }
        AuthContext.Status istat = this.lc.getStatus();
        if (istat == AuthContext.Status.SUCCESS) {
            System.out.println("==>Authentication SUCCESSFUL for user " + userid);
        } else if (istat == AuthContext.Status.COMPLETED) {
            System.out.println("==>Authentication Status for user " + userid + " = " + istat);
            return null;
        }
        try {
            ssoToken = this.lc.getSSOToken();
        }
        catch (Exception e) {
            System.err.println("Failed to get SSO token!  " + e.getMessage());
            throw e;
        }
        return ssoToken;
    }

    public void logout() throws AuthLoginException {
        try {
            this.lc.logout();
        }
        catch (AuthLoginException alexc) {
            System.err.println("IdRepoSampleUtils: logout failed for user '" + this.userID + "'");
            throw alexc;
        }
    }

    protected void fillCallbacks(Callback[] callbacks, Hashtable values) throws Exception {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof NameCallback) {
                NameCallback nc = (NameCallback)callbacks[i];
                nc.setName((String)values.get("NameCallback"));
                continue;
            }
            if (callbacks[i] instanceof PasswordCallback) {
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(((String)values.get("PasswordCallback")).toCharArray());
                continue;
            }
            if (callbacks[i] instanceof TextInputCallback) {
                TextInputCallback tic = (TextInputCallback)callbacks[i];
                tic.setText((String)values.get("TextInputCallback"));
                continue;
            }
            if (!(callbacks[i] instanceof ChoiceCallback)) continue;
            ChoiceCallback cc = (ChoiceCallback)callbacks[i];
            cc.setSelectedIndex(Integer.parseInt((String)values.get("ChoiceCallback")));
        }
    }

    public String getLine() {
        StringBuffer buf = new StringBuffer(80);
        try {
            int c;
            while ((c = System.in.read()) != -1) {
                char ch = (char)c;
                if (ch == '\r') continue;
                if (ch != '\n') {
                    buf.append(ch);
                    continue;
                }
                break;
            }
        }
        catch (IOException e) {
            System.err.println("getLine: " + e.getMessage());
        }
        return buf.toString();
    }

    public String getLine(String prompt) {
        System.out.print(prompt);
        return this.getLine();
    }

    public String getLine(String prompt, String defaultVal) {
        System.out.print(prompt + " [" + defaultVal + "]: ");
        String tmp = this.getLine();
        if (tmp.length() == 0) {
            tmp = defaultVal;
        }
        return tmp;
    }

    public int getIntValue(String sVal) {
        int i = -1;
        try {
            i = Integer.parseInt(sVal);
        }
        catch (NumberFormatException e) {
            System.err.println("'" + sVal + "' does not appear to be an integer.");
        }
        return i;
    }

    public IdType getIdTypeToCreateOrDelete() {
        IdType tType = null;
        System.out.println("    Supported IdTypes:\n\t0: user\n\t1: agent\n\t2: agentonly\n\t3: agentgroup\n\t4: realm\n\t5: No selection");
        String answer = this.getLine("Select type: [0..3]: ");
        int i = this.getIntValue(answer);
        switch (i) {
            case 0: {
                tType = IdType.USER;
                break;
            }
            case 1: {
                tType = IdType.AGENT;
                break;
            }
            case 2: {
                tType = IdType.AGENTONLY;
                break;
            }
            case 3: {
                tType = IdType.AGENTGROUP;
                break;
            }
            case 4: {
                tType = IdType.REALM;
                break;
            }
            case 5: {
                break;
            }
            default: {
                System.err.println(answer + " is an invalid selection.");
            }
        }
        return tType;
    }

    public IdType getIdType(AMIdentityRepository idRepo) {
        IdType tType = null;
        String realmName = null;
        try {
            realmName = idRepo.getRealmIdentity().getRealm();
            Set types = idRepo.getSupportedIdTypes();
            Object[] idtypes = types.toArray();
            System.out.println("    Supported IdTypes:");
            int i = 0;
            for (i = 0; i < idtypes.length; ++i) {
                tType = (IdType)idtypes[i];
                System.out.println("\t" + i + ": " + tType.getName());
            }
            System.out.println("\t" + i + ": No selection");
            String answer = this.getLine("Select type: [0.." + idtypes.length + "]: ");
            i = this.getIntValue(answer);
            tType = (IdType)idtypes[0];
            if (i == idtypes.length) {
                return null;
            }
            if (i < 0 || i >= idtypes.length) {
                System.err.println(answer + " is an invalid selection.");
                return null;
            }
            tType = (IdType)idtypes[i];
        }
        catch (IdRepoException ire) {
            System.err.println("getIdType: IdRepoException getting Supported IdTypes for '" + realmName + "': " + ire.getMessage());
        }
        catch (SSOException ssoe) {
            System.err.println("getIdType: SSOException getting Supported IdTypes for '" + realmName + "': " + ssoe.getMessage());
        }
        return tType;
    }

    public void printResults(String header, Set results, String trailer) {
        if (results.isEmpty()) {
            System.out.println(header + " has no " + trailer);
        } else {
            System.out.println(header + " has " + results.size() + " " + trailer + ":");
            Iterator it = results.iterator();
            while (it.hasNext()) {
                System.out.println("    " + it.next());
            }
        }
        System.out.println("");
    }

    public void printResultsRealm(String header, Set results, String trailer) {
        if (results.isEmpty()) {
            System.out.println(header + " has no " + trailer);
        } else {
            System.out.println(header + " has " + results.size() + " " + trailer + ":");
            for (AMIdentity amid : results) {
                System.out.println("    " + amid.getRealm());
            }
        }
        System.out.println("");
    }

    public void printIdTypeResults(String header, Set results, String trailer) {
        if (results.isEmpty()) {
            System.out.println(header + " has no " + trailer);
        } else {
            System.out.println(header + " has " + results.size() + " " + trailer + ":");
            IdType itype2 = null;
            Set idSet = null;
            for (IdType itype2 : results) {
                System.out.println("    IdType " + itype2.getName());
                idSet = itype2.canBeMemberOf();
                this.printIdTypeSet("BE a member of IdType(s):", idSet);
                idSet = itype2.canHaveMembers();
                this.printIdTypeSet("HAVE a member of IdType(s):", idSet);
                idSet = itype2.canAddMembers();
                this.printIdTypeSet("ADD members of IdType(s):", idSet);
            }
        }
        System.out.println("");
    }

    private void printIdTypeSet(String header, Set idSet) {
        System.out.print("\tcan " + header);
        if (idSet.size() > 0) {
            Iterator it = idSet.iterator();
            while (it.hasNext()) {
                System.out.print(" " + ((IdType)it.next()).getName());
            }
            System.out.print("\n");
        } else {
            System.out.println(" [NONE]");
        }
    }

    public int selectFromArray(Object[] objs, String hdr, String prompt) {
        AMIdentity amid = null;
        String ans = null;
        boolean isIdType = false;
        boolean isString = false;
        if (objs.length <= 0) {
            return -1;
        }
        System.out.println(hdr);
        int i = -1;
        String objclass = objs[0].getClass().getName();
        if (objclass.indexOf("AMIdentity") >= 0) {
            isIdType = true;
        } else if (objclass.indexOf("String") >= 0) {
            isString = true;
        }
        for (i = 0; i < objs.length; ++i) {
            if (isIdType) {
                amid = (AMIdentity)objs[i];
                System.out.println("\t" + i + ": " + amid.getName());
                continue;
            }
            if (isString) {
                System.out.println("\t" + i + ": " + (String)objs[i]);
                continue;
            }
            System.out.println("\t" + i + ": Class = " + objclass);
        }
        System.out.println("\t" + i + ": No Selection");
        ans = this.getLine(prompt + ": [0.." + objs.length + "]: ");
        i = this.getIntValue(ans);
        return i;
    }

    public Object selectFromSet(Set itemSet) {
        Object[] objs = itemSet.toArray();
        AMIdentity amid = null;
        Object amid2 = null;
        int setsize = itemSet.size();
        boolean isAMId = false;
        boolean isString = false;
        Object str = null;
        if (setsize <= 0) {
            return null;
        }
        String objclass = objs[0].getClass().getName();
        if (objclass.indexOf("AMIdentity") >= 0) {
            isAMId = true;
        } else if (objclass.indexOf("String") >= 0) {
            isString = true;
        }
        if (setsize > 0) {
            int i;
            System.out.println("Available selections:");
            for (i = 0; i < setsize; ++i) {
                if (isAMId) {
                    amid = (AMIdentity)objs[i];
                    System.out.println("\t" + i + ": " + amid.getName());
                    continue;
                }
                if (isString) {
                    System.out.println("\t" + i + ": " + (String)objs[i]);
                    continue;
                }
                System.out.println("\t" + i + ": Class = " + objclass);
            }
            System.out.println("\t" + i + ": No selection");
            String answer = this.getLine("Select identity: [0.." + setsize + "]: ");
            int ians = this.getIntValue(answer);
            if (ians >= 0 && ians < setsize) {
                return objs[ians];
            }
            if (ians != setsize) {
                System.err.println("'" + answer + "' is invalid.");
            }
        }
        return null;
    }

    public void waitForReturn() {
        this.waitForReturn("Hit <return> when ready: ");
        String answer = this.getLine();
    }

    public void waitForReturn(String prompt) {
        System.out.print(prompt);
        String answer = this.getLine();
    }
}

