/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.samples.clientsdk.logging;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.log.AMLogException;
import com.sun.identity.log.Logger;
import com.sun.identity.samples.clientsdk.logging.LogSampleUtils;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class LogSample {
    static final String DEF_REALM = "/";
    static final String DEF_USERNAME = "user1";
    static final String DEF_USERPSWD = "user1password";
    static final String DEF_LOGNAME = "TestLog";
    static final String DEF_LOGMSG = "Test Log Record";
    static final String DEF_LOGGEDBY = "amadmin";
    static final String DEF_LOGGEDBYPSWD = "amadminpswd";
    static final String DEF_MODULENAME = "MyModule";
    LogSampleUtils sampleUtils = new LogSampleUtils();
    SSOToken userSSOToken = null;
    SSOToken loggerSSOToken = null;
    AuthContext userAC = null;
    AuthContext loggerAC = null;

    public static void main(String[] args) {
        LogSample ls = new LogSample();
        ls.logWriteProcessing();
        System.exit(0);
    }

    private void logWriteProcessing() {
        String userSID = this.sampleUtils.getLine("Subject Userid", DEF_USERNAME);
        String userPWD = this.sampleUtils.getLine("Subject Userid " + userSID + "'s password", DEF_USERPSWD);
        String logName = this.sampleUtils.getLine("Log file", DEF_LOGNAME);
        String message = this.sampleUtils.getLine("Log message", DEF_LOGMSG);
        String loggedBySID = this.sampleUtils.getLine("LoggedBy Userid", DEF_LOGGEDBY);
        String loggedByPWD = this.sampleUtils.getLine("LoggedBy Userid's password", DEF_LOGGEDBYPSWD);
        String realmName = this.sampleUtils.getLine("Realm", DEF_REALM);
        try {
            this.userAC = new AuthContext(realmName);
            this.loggerAC = new AuthContext(realmName);
        }
        catch (AuthLoginException le) {
            System.err.println("LogSampleUtils: could not get AuthContext for realm " + realmName);
            System.exit(2);
        }
        try {
            this.userSSOToken = this.sampleUtils.realmLogin(userSID, userPWD, this.userAC);
            this.loggerSSOToken = this.sampleUtils.realmLogin(loggedBySID, loggedByPWD, this.loggerAC);
        }
        catch (SSOException ssoe) {
            System.err.println("logWriteProcessing: could not get SSOToken: " + ssoe.getMessage());
            System.exit(3);
        }
        catch (AuthLoginException ale) {
            System.err.println("logWriteProcessing: could not authenticate: " + ale.getMessage());
            System.exit(4);
        }
        catch (Exception e) {
            System.err.println("logWriteProcessing: exception getting SSOToken: " + e.getMessage());
            System.exit(5);
        }
        try {
            com.sun.identity.log.LogRecord logRecord = new com.sun.identity.log.LogRecord(Level.INFO, message, (Object)this.userSSOToken);
            logRecord.addLogInfo("ModuleName", (Object)DEF_MODULENAME);
            InetAddress ipAddr = InetAddress.getLocalHost();
            logRecord.addLogInfo("IPAddr", (Object)ipAddr.getHostAddress());
            Logger logger = (Logger)Logger.getLogger((String)logName);
            logger.log((LogRecord)logRecord, (Object)this.loggerSSOToken);
            System.out.println("LogSample: Logging Successful !!!");
            this.userAC.logout();
            this.loggerAC.logout();
        }
        catch (AMLogException amex) {
            System.err.println("LogSample: AMLogException: " + amex.getMessage());
            System.err.println("LogSample: Logging Failed; Is user '" + loggedBySID + "' a member of a Role or Group with log writing privileges?");
        }
        catch (Exception ssoe) {
            System.err.println("LogSample: Exception: " + ssoe.getMessage());
            System.err.println("LogSample: Logging Failed !!!");
        }
    }
}

