/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.samples.sso;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenID;
import com.iplanet.sso.SSOTokenManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.security.Principal;

public class SSOTokenSample {
    private SSOTokenManager manager;
    private SSOToken token;

    private SSOTokenSample(String tokenID) throws SSOException {
        if (this.validateToken(tokenID)) {
            this.setGetProperties(this.token);
        }
    }

    private boolean validateToken(String tokenID) throws SSOException {
        boolean validated = false;
        this.manager = SSOTokenManager.getInstance();
        this.token = this.manager.createSSOToken(tokenID);
        if (this.manager.isValidToken(this.token)) {
            String host = this.token.getHostName();
            Principal principal = this.token.getPrincipal();
            String authType = this.token.getAuthType();
            int level = this.token.getAuthLevel();
            InetAddress ipAddress = this.token.getIPAddress();
            long maxTime = this.token.getMaxSessionTime();
            long idleTime = this.token.getIdleTime();
            long maxIdleTime = this.token.getMaxIdleTime();
            System.out.println("SSOToken host name: " + host);
            System.out.println("SSOToken Principal name: " + principal.getName());
            System.out.println("Authentication type used: " + authType);
            System.out.println("IPAddress of the host: " + ipAddress.getHostAddress());
            validated = true;
        }
        return validated;
    }

    private void setGetProperties(SSOToken token) throws SSOException {
        this.manager.validateToken(token);
        System.out.println("SSO Token validation test Succeeded.");
        SSOTokenID id = token.getTokenID();
        String tokenId = id.toString();
        System.out.println("Token ID: " + tokenId);
        token.setProperty("TimeZone", "PST");
        token.setProperty("County", "SantaClara");
        String tZone = token.getProperty("TimeZone");
        String county = token.getProperty("County");
        System.out.println("Property: TimeZone: " + tZone);
        System.out.println("Property: County: " + county);
    }

    public static void main(String[] args) {
        try {
            System.out.print("Enter SSOToken ID: ");
            String ssoTokenID = new BufferedReader(new InputStreamReader(System.in)).readLine();
            new SSOTokenSample(ssoTokenID.trim());
        }
        catch (SSOException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.exit(0);
    }
}

