/*
 * Decompiled with CFR 0.152.
 */
package samples.policy;

import com.iplanet.sso.SSOToken;
import com.sun.identity.authentication.AuthContext;
import java.security.Principal;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.LoginException;

public class TokenUtils {
    public static SSOToken getToken(String orgName, String userId, String password) throws Exception {
        return TokenUtils.getSessionToken(orgName, userId, password);
    }

    public static SSOToken getSessionToken(String orgName, String userId, String password) throws Exception {
        return TokenUtils.getSessionToken(orgName, userId, password, null, -1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SSOToken getSessionToken(String orgName, String userId, String password, String module, int level) throws Exception {
        AuthContext ac = null;
        try {
            ac = new AuthContext(orgName);
            if (module != null) {
                ac.login(AuthContext.IndexType.MODULE_INSTANCE, module);
            } else if (level != -1) {
                ac.login(AuthContext.IndexType.LEVEL, String.valueOf(level));
            } else {
                ac.login();
            }
        }
        catch (LoginException le) {
            le.printStackTrace();
            return null;
        }
        try {
            Callback[] callbacks = null;
            if (!ac.hasMoreRequirements()) return ac.getSSOToken();
            callbacks = ac.getRequirements();
            if (callbacks == null) return ac.getSSOToken();
            TokenUtils.addLoginCallbackMessage(callbacks, userId, password);
            ac.submitRequirements(callbacks);
            if (ac.getStatus() == AuthContext.Status.SUCCESS) {
                Subject authSubject = ac.getSubject();
                if (authSubject == null) return ac.getSSOToken();
                for (Principal principal : authSubject.getPrincipals()) {
                }
                return ac.getSSOToken();
            }
            if (ac.getStatus() != AuthContext.Status.FAILED) return ac.getSSOToken();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ac.getSSOToken();
    }

    static void addLoginCallbackMessage(Callback[] callbacks, String userId, String password) throws UnsupportedCallbackException {
        int i = 0;
        try {
            for (i = 0; i < callbacks.length; ++i) {
                if (callbacks[i] instanceof NameCallback) {
                    NameCallback nc = (NameCallback)callbacks[i];
                    nc.setName(userId);
                    continue;
                }
                if (!(callbacks[i] instanceof PasswordCallback)) continue;
                PasswordCallback pc = (PasswordCallback)callbacks[i];
                pc.setPassword(password.toCharArray());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

