/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.notifications.integration;

import com.google.inject.Exposed;
import com.google.inject.PrivateModule;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Names;
import com.iplanet.am.util.SystemProperties;
import java.lang.annotation.Annotation;
import java.util.concurrent.ScheduledExecutorService;
import javax.inject.Inject;
import javax.inject.Named;
import org.forgerock.guice.core.GuiceModule;
import org.forgerock.openam.audit.context.AMExecutorServiceFactory;
import org.forgerock.openam.cts.CTSPersistentStore;
import org.forgerock.openam.notifications.LocalOnly;
import org.forgerock.openam.notifications.NotificationBroker;
import org.forgerock.openam.notifications.brokers.InMemoryNotificationBroker;
import org.forgerock.openam.notifications.integration.brokers.CTSNotificationBroker;

@GuiceModule
public class NotificationsGuiceModule
extends PrivateModule {
    protected void configure() {
        this.bind(NotificationBroker.class).annotatedWith(LocalOnly.class).to(InMemoryNotificationBroker.class).in(Singleton.class);
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"queueSize")).to(SystemProperties.getAsInt((String)"org.forgerock.openam.notifications.local.queueSize", (int)10000));
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"consumers")).to(SystemProperties.getAsInt((String)"org.forgerock.openam.notifications.local.consumers", (int)4));
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"tokenExpirySeconds")).to(SystemProperties.getAsLong((String)"org.forgerock.openam.notifications.cts.tokenExpirySeconds", (long)600L));
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"publishFrequencyMilliseconds")).to(SystemProperties.getAsLong((String)"org.forgerock.openam.notifications.cts.publishFrequencyMilliseconds", (long)100L));
        this.bindConstant().annotatedWith((Annotation)Names.named((String)"ctsQueueSize")).to(SystemProperties.getAsInt((String)"org.forgerock.openam.notifications.cts.queueSize", (int)10000));
        this.expose(NotificationBroker.class).annotatedWith(LocalOnly.class);
        this.expose(NotificationBroker.class);
    }

    @Provides
    @Inject
    @Exposed
    @Singleton
    @Named(value="webSocketScheduledExecutorService")
    ScheduledExecutorService scheduledExecutorService(AMExecutorServiceFactory factory) {
        return factory.createScheduledService(5, "NotificationsWebSocket");
    }

    @Provides
    @Exposed
    @Inject
    @Singleton
    NotificationBroker notificationBroker(CTSPersistentStore store, @LocalOnly NotificationBroker broker, @Named(value="ctsQueueSize") int queueSize, @Named(value="tokenExpirySeconds") long tokenExpirySeconds, @Named(value="publishFrequencyMilliseconds") long publishFrequencyMilliseconds, AMExecutorServiceFactory factory) {
        return new CTSNotificationBroker(store, broker, queueSize, tokenExpirySeconds, publishFrequencyMilliseconds, factory);
    }
}

