/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.notifications.websocket;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.websocket.DecodeException;
import javax.websocket.EncodeException;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.PongMessage;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.forgerock.json.JsonValue;
import org.forgerock.openam.notifications.Consumer;
import org.forgerock.openam.notifications.NotificationBroker;
import org.forgerock.openam.notifications.Subscription;
import org.forgerock.openam.notifications.Topic;
import org.forgerock.openam.notifications.websocket.JsonValueDecoder;
import org.forgerock.openam.notifications.websocket.JsonValueEncoder;
import org.forgerock.openam.notifications.websocket.NotificationsWebSocketConfigurator;
import org.forgerock.util.Reject;
import org.forgerock.util.time.TimeService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/notifications", encoders={JsonValueEncoder.class}, decoders={JsonValueDecoder.class}, configurator=NotificationsWebSocketConfigurator.class, subprotocols={"v1.notifications.forgerock.org"})
public final class NotificationsWebSocket {
    private static final Logger logger = LoggerFactory.getLogger(NotificationsWebSocket.class);
    private static final long TIMEOUT_MILLISECONDS = 60000L;
    private final NotificationBroker broker;
    private final TimeService timeService;
    private final ScheduledExecutorService executorService;
    private Subscription subscription;
    private long lastMessageTime;
    private ScheduledFuture<?> pingFuture;

    public NotificationsWebSocket() {
        this.broker = null;
        this.timeService = null;
        this.executorService = null;
    }

    @Inject
    public NotificationsWebSocket(NotificationBroker broker, TimeService timeService, @Named(value="webSocketScheduledExecutorService") ScheduledExecutorService executorService) {
        Reject.ifNull((Object)broker, (String)"Broker must not be null");
        this.broker = broker;
        this.timeService = timeService;
        this.executorService = executorService;
    }

    @OnOpen
    public void open(final Session session) {
        Reject.ifNull((Object)session, (String)"Session must not be null");
        this.subscription = this.broker.subscribe((Consumer)new WebSocketConsumer(session));
        session.setMaxIdleTimeout(60000L);
        this.lastMessageTime = this.timeService.now();
        this.pingFuture = this.executorService.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                try {
                    if (session.isOpen()) {
                        session.getAsyncRemote().sendPing(ByteBuffer.wrap("ping".getBytes()));
                    }
                }
                catch (IOException e) {
                    logger.info("Failed to send ping to client", (Throwable)e);
                }
            }
        }, 30000L, 30000L, TimeUnit.MILLISECONDS);
    }

    @OnClose
    public void close() {
        this.subscription.close();
        if (this.pingFuture != null) {
            this.pingFuture.cancel(true);
        }
    }

    @OnMessage
    public void message(Session session, JsonValue json) {
        Reject.ifNull((Object)session, (String)"Session must not be null");
        Reject.ifNull((Object)json, (String)"Json must not be null");
        this.lastMessageTime = this.timeService.now();
        if (json.isDefined("id") && !json.get("id").isString()) {
            this.sendError(session, null, "\"id\" must be a string");
            return;
        }
        String id = json.get("id").asString();
        if (!json.isDefined("action")) {
            this.sendError(session, id, "missing required field \"action\"");
            return;
        }
        if (!json.get("action").isString()) {
            this.sendError(session, id, "\"action\" must be a string");
            return;
        }
        String action = json.get("action").asString();
        if (!action.equals("subscribe")) {
            this.sendError(session, id, "unknown action \"" + action + "\"");
            return;
        }
        if (!json.isDefined("topic")) {
            this.sendError(session, id, "missing required field \"topic\"");
            return;
        }
        if (!json.get("topic").isString()) {
            this.sendError(session, id, "\"topic\" must be a string");
            return;
        }
        String topic = json.get("topic").asString();
        this.subscription.bindTo(Topic.of((String)topic));
        this.sendMessage(session, id, topic, "subscription registered");
    }

    @OnMessage
    public void pong(PongMessage message) {
        this.lastMessageTime = this.timeService.now();
    }

    @OnError
    public void error(Session session, Throwable error) {
        if (error instanceof DecodeException) {
            this.sendError(session, null, error.getMessage());
        } else {
            logger.info("WebSocket error", error);
        }
    }

    private void sendMessage(Session session, String id, String topic, String message) {
        try {
            JsonValue json = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"topic", (Object)topic), JsonValue.field((String)"message", (Object)message)}));
            if (id != null) {
                json.put("id", (Object)id);
            }
            session.getBasicRemote().sendObject((Object)json);
        }
        catch (IOException | EncodeException e) {
            logger.warn("Unable to send message to client. Message was \"" + message + "\"", e);
        }
    }

    private void sendError(Session session, String id, String message) {
        try {
            JsonValue json = JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"error", (Object)message)}));
            if (id != null) {
                json.put("id", (Object)id);
            }
            session.getBasicRemote().sendObject((Object)json);
        }
        catch (IOException | EncodeException e) {
            logger.warn("Unable to send error message to client. Error was \"" + message + "\"", e);
        }
    }

    private final class WebSocketConsumer
    implements Consumer {
        private final Session session;

        private WebSocketConsumer(Session session) {
            this.session = session;
        }

        public void accept(JsonValue notification) {
            Reject.ifNull((Object)notification);
            if (NotificationsWebSocket.this.timeService.since(NotificationsWebSocket.this.lastMessageTime) > 60000L) {
                try {
                    this.session.close();
                }
                catch (IOException e) {
                    logger.warn("Failed to close WebSocket connection", (Throwable)e);
                }
                return;
            }
            if (this.session.isOpen()) {
                this.session.getAsyncRemote().sendObject((Object)notification);
            }
        }
    }
}

