/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.script.Bindings;
import org.forgerock.util.Reject;

public final class ChainedBindings
implements Bindings {
    private final Bindings current;
    private final Bindings parent;

    public ChainedBindings(Bindings parent, Bindings current) {
        Reject.ifNull((Object[])new Bindings[]{parent, current});
        this.parent = parent;
        this.current = current;
    }

    @Override
    public Object put(String varName, Object value) {
        Object currentResult = this.current.put(varName, value);
        Object parentResult = this.parent.put(varName, value);
        return currentResult != null ? currentResult : parentResult;
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> map) {
        this.current.putAll(map);
    }

    @Override
    public void clear() {
        this.current.clear();
        this.parent.clear();
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>(this.current.keySet());
        keys.addAll(this.parent.keySet());
        return keys;
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>(this.current.values());
        values.addAll(this.parent.values());
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> entries = new HashSet<Map.Entry<String, Object>>(this.current.entrySet());
        entries.addAll(this.parent.entrySet());
        return entries;
    }

    @Override
    public int size() {
        return this.current.size() + this.parent.size();
    }

    @Override
    public boolean isEmpty() {
        return this.current.isEmpty() && this.parent.isEmpty();
    }

    @Override
    public boolean containsKey(Object o) {
        return this.current.containsKey(o) || this.parent.containsKey(o);
    }

    @Override
    public boolean containsValue(Object o) {
        return this.current.containsValue(o) || this.parent.containsValue(o);
    }

    @Override
    public Object get(Object o) {
        Object result = this.current.get(o);
        if (result == null) {
            result = this.parent.get(o);
        }
        return result;
    }

    @Override
    public Object remove(Object o) {
        Object result = this.current.remove(o);
        if (result == null) {
            result = this.parent.remove(o);
        }
        return result;
    }
}

