/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting;

import org.forgerock.openam.scripting.ScriptException;
import org.forgerock.openam.scripting.SupportedScriptingLanguage;

public final class ScriptConstants {
    public static final String RESOURCE_BUNDLE = "scripting";
    public static final String SCRIPT_NAME = "name";
    public static final String JSON_UUID = "_id";
    public static final String SCRIPT_TEXT = "script";
    public static final String SCRIPT_IS_DEFAULT = "default";
    public static final String SCRIPT_LANGUAGE = "language";
    public static final String SCRIPT_CONTEXT = "context";
    public static final String SCRIPT_DESCRIPTION = "description";
    public static final String SCRIPT_CREATED_BY = "createdBy";
    public static final String SCRIPT_CREATION_DATE = "creationDate";
    public static final String SCRIPT_LAST_MODIFIED_BY = "lastModifiedBy";
    public static final String SCRIPT_LAST_MODIFIED_DATE = "lastModifiedDate";
    public static final String SERVICE_NAME = "ScriptingService";
    public static final String SCRIPT_CONFIGURATION = "scriptConfiguration";
    public static final String SCRIPT_CONFIGURATIONS = "scriptConfigurations";
    public static final String EMPTY = "";
    public static final String EMPTY_SCRIPT_SELECTION = "[Empty]";
    public static final String SCRIPT_TIMEOUT = "serverTimeout";
    public static final String THREAD_POOL_CORE_SIZE = "coreThreads";
    public static final String THREAD_POOL_MAX_SIZE = "maxThreads";
    public static final String THREAD_POOL_QUEUE_SIZE = "queueSize";
    public static final String THREAD_POOL_IDLE_TIMEOUT = "idleTimeout";
    public static final String WHITE_LIST = "whiteList";
    public static final String BLACK_LIST = "blackList";
    public static final String USE_SECURITY_MANAGER = "useSecurityManager";
    public static final String ENGINE_CONFIGURATION = "EngineConfiguration";
    public static final int DEFAULT_CORE_THREADS = 10;
    public static final int DEFAULT_MAX_THREADS = 10;
    public static final int DEFAULT_QUEUE_SIZE = 10;
    public static final long DEFAULT_IDLE_TIMEOUT_SECONDS = 60L;
    public static final String LOGGER_NAME = "Scripting";
    public static final String AUTHENTICATION_SERVER_SIDE_NAME = "AUTHENTICATION_SERVER_SIDE";
    public static final String POLICY_CONDITION_NAME = "POLICY_CONDITION";
    public static final String OIDC_CLAIMS_NAME = "OIDC_CLAIMS";
    public static final String SCRIPTING_HTTP_CLIENT_NAME = "ScriptingHttpClient";

    private ScriptConstants() {
        throw new RuntimeException("Constructor for ScriptConstants is not supported.");
    }

    public static SupportedScriptingLanguage getLanguageFromString(String languageName) throws ScriptException {
        for (SupportedScriptingLanguage ssl : SupportedScriptingLanguage.values()) {
            if (!ssl.name().equalsIgnoreCase(languageName)) continue;
            return ssl;
        }
        throw new ScriptException(ScriptErrorCode.LANGUAGE_NOT_SUPPORTED, languageName);
    }

    public static ScriptContext getContextFromString(String context) throws ScriptException {
        for (ScriptContext sc : ScriptContext.values()) {
            if (!sc.name().equalsIgnoreCase(context)) continue;
            return sc;
        }
        throw new ScriptException(ScriptErrorCode.CONTEXT_NOT_RECOGNISED, context);
    }

    public static enum ScriptErrorCode {
        CONTEXT_NOT_RECOGNISED,
        LANGUAGE_NOT_SUPPORTED,
        FIND_BY_NAME_FAILED,
        FIND_BY_UUID_FAILED,
        DELETE_FAILED,
        RETRIEVE_FAILED,
        RETRIEVE_ALL_FAILED,
        SAVE_FAILED,
        MISSING_SCRIPT_UUID,
        MISSING_SCRIPT_NAME,
        MISSING_SCRIPT,
        MISSING_SCRIPTING_LANGUAGE,
        MISSING_SCRIPT_CONTEXT,
        SCRIPT_NAME_EXISTS,
        SCRIPT_UUID_EXISTS,
        SCRIPT_UUID_NOT_FOUND,
        FILTER_BOOLEAN_LITERAL_FALSE,
        FILTER_EXTENDED_MATCH,
        FILTER_GREATER_THAN,
        FILTER_GREATER_THAN_OR_EQUAL,
        FILTER_LESS_THAN,
        FILTER_LESS_THAN_OR_EQUAL,
        FILTER_NOT,
        FILTER_PRESENT,
        RESOURCE_FILTER_NOT_SUPPORTED,
        SCRIPT_DECODING_FAILED,
        DELETING_DEFAULT_SCRIPT,
        DELETING_SCRIPT_IN_USE_SINGULAR,
        DELETING_SCRIPT_IN_USE_PLURAL,
        INSUFFICIENT_PRIVILEGES;

    }

    public static enum GlobalScript {
        AUTH_MODULE_SERVER_SIDE("Scripted Module - Server Side", "7e3d7067-d50f-4674-8c76-a3e13a810c33", ScriptContext.AUTHENTICATION_SERVER_SIDE),
        AUTH_MODULE_CLIENT_SIDE("Scripted Module - Client Side", "c827d2b4-3608-4693-868e-bbcf86bd87c7", ScriptContext.AUTHENTICATION_CLIENT_SIDE),
        DEVICE_ID_MATCH_SERVER_SIDE("Device Id (Match) - Server Side", "703dab1a-1921-4981-98dd-b8e5349d8548", ScriptContext.AUTHENTICATION_SERVER_SIDE),
        DEVICE_ID_MATCH_CLIENT_SIDE("Device Id (Match) - Client Side", "157298c0-7d31-4059-a95b-eeb08473b7e5", ScriptContext.AUTHENTICATION_CLIENT_SIDE),
        OIDC_CLAIMS_SCRIPT("OIDC Claims Script", "36863ffb-40ec-48b9-94b1-9a99f71cc3b5", ScriptContext.OIDC_CLAIMS),
        POLICY_CONDITION_SCRIPT("Policy Condition", "9de3eb62-f131-4fac-a294-7bd170fd4acb", ScriptContext.POLICY_CONDITION);

        private final String displayName;
        private final String id;
        private final ScriptContext context;

        private GlobalScript(String displayName, String id, ScriptContext context) {
            this.displayName = displayName;
            this.id = id;
            this.context = context;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getId() {
            return this.id;
        }

        public ScriptContext getContext() {
            return this.context;
        }

        public static boolean isGlobalScript(String id) {
            for (GlobalScript script : GlobalScript.values()) {
                if (!script.id.equals(id)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum ScriptContext {
        AUTHENTICATION_SERVER_SIDE,
        AUTHENTICATION_CLIENT_SIDE,
        POLICY_CONDITION,
        OIDC_CLAIMS;

    }
}

