/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.forgerock.openam.scripting.ScriptEngineConfiguration;
import org.forgerock.openam.scripting.factories.GroovyEngineFactory;
import org.forgerock.openam.scripting.factories.RhinoScriptEngineFactory;
import org.forgerock.openam.scripting.sandbox.GroovySandboxValueFilter;
import org.forgerock.openam.scripting.sandbox.RhinoSandboxClassShutter;
import org.forgerock.openam.scripting.timeouts.ObservedContextFactory;
import org.forgerock.util.Reject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StandardScriptEngineManager
extends ScriptEngineManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardScriptEngineManager.class);
    private static final ScriptEngineConfiguration DEFAULT_CONFIGURATION = ScriptEngineConfiguration.builder().withTimeout(0L, TimeUnit.SECONDS).withSystemSecurityManager().build();
    private volatile ScriptEngineConfiguration configuration = DEFAULT_CONFIGURATION;
    private final Set<ConfigurationListener> listeners = Collections.synchronizedSet(new HashSet());

    @Inject
    public StandardScriptEngineManager() {
        super(null);
        RhinoScriptEngineFactory rhino = new RhinoScriptEngineFactory(new ObservedContextFactory(this));
        rhino.setOptimisationLevel(-1);
        RhinoSandboxClassShutter sandbox = new RhinoSandboxClassShutter(System.getSecurityManager(), Collections.emptyList(), Collections.emptyList());
        rhino.setClassShutter(sandbox);
        GroovyEngineFactory groovy = new GroovyEngineFactory();
        groovy.setSandbox(new GroovySandboxValueFilter(sandbox));
        this.addConfigurationListener(new SandboxConfigurationListener(rhino, groovy));
        this.registerEngineName("rhino", rhino);
        this.registerEngineName("groovy", (ScriptEngineFactory)((Object)groovy));
        this.setConfiguration(DEFAULT_CONFIGURATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfiguration(ScriptEngineConfiguration newConfiguration) {
        Reject.ifNull((Object)newConfiguration);
        Set<ConfigurationListener> set = this.listeners;
        synchronized (set) {
            this.configuration = newConfiguration;
            for (ConfigurationListener listener : this.listeners) {
                try {
                    listener.onConfigurationChange(newConfiguration);
                }
                catch (RuntimeException ex) {
                    LOGGER.error("Script configuration listener failed with exception", (Throwable)ex);
                }
            }
        }
    }

    public ScriptEngineConfiguration getConfiguration() {
        return this.configuration;
    }

    public boolean addConfigurationListener(ConfigurationListener listener) {
        Reject.ifNull((Object)listener);
        listener.onConfigurationChange(this.getConfiguration());
        return this.listeners.add(listener);
    }

    public boolean removeConfigurationListener(ConfigurationListener listener) {
        return this.listeners.remove(listener);
    }

    private static final class SandboxConfigurationListener
    implements ConfigurationListener {
        private final RhinoScriptEngineFactory rhinoScriptEngineFactory;
        private final GroovyEngineFactory groovyEngineFactory;

        private SandboxConfigurationListener(RhinoScriptEngineFactory rhinoScriptEngineFactory, GroovyEngineFactory groovy) {
            Reject.ifNull((Object[])new ScriptEngineFactory[]{rhinoScriptEngineFactory, groovy});
            this.rhinoScriptEngineFactory = rhinoScriptEngineFactory;
            this.groovyEngineFactory = groovy;
        }

        @Override
        public void onConfigurationChange(ScriptEngineConfiguration newConfiguration) {
            LOGGER.debug("Configuring sandbox: {}", (Object)newConfiguration);
            RhinoSandboxClassShutter sandbox = new RhinoSandboxClassShutter(newConfiguration.getSecurityManager(), newConfiguration.getClassWhiteList(), newConfiguration.getClassBlackList());
            this.rhinoScriptEngineFactory.setClassShutter(sandbox);
            this.groovyEngineFactory.setSandbox(new GroovySandboxValueFilter(sandbox));
        }
    }

    public static interface ConfigurationListener {
        public void onConfigurationChange(ScriptEngineConfiguration var1);
    }
}

