/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting;

import java.io.Writer;
import javax.script.Bindings;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import javax.script.SimpleScriptContext;
import org.codehaus.groovy.control.io.NullWriter;
import org.forgerock.openam.scripting.ChainedBindings;
import org.forgerock.openam.scripting.ScriptEvaluator;
import org.forgerock.openam.scripting.ScriptObject;
import org.forgerock.openam.scripting.StandardScriptEngineManager;
import org.forgerock.util.Reject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardScriptEvaluator
implements ScriptEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardScriptEvaluator.class);
    private final StandardScriptEngineManager scriptEngineManager;

    public StandardScriptEvaluator(StandardScriptEngineManager scriptEngineManager) {
        Reject.ifNull((Object)scriptEngineManager);
        this.scriptEngineManager = scriptEngineManager;
    }

    @Override
    public void bindVariableInGlobalScope(String name, Object object) {
        Reject.ifNull((Object[])new Object[]{name, object});
        this.scriptEngineManager.put(name, object);
    }

    @Override
    public <T> T evaluateScript(ScriptObject script, Bindings bindings) throws ScriptException {
        Reject.ifNull((Object)script);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Evaluating script: " + script);
        }
        ScriptEngine engine = this.getScriptEngineFor(script);
        Bindings variableBindings = this.mergeBindings(script.getBindings(), bindings);
        ScriptContext context = this.buildScriptContext(variableBindings);
        return (T)engine.eval(script.getScript(), context);
    }

    private ScriptEngine getScriptEngineFor(ScriptObject script) {
        Reject.ifNull((Object)script);
        ScriptEngine engine = script.getLanguage().getScriptEngine(this.scriptEngineManager);
        if (engine == null) {
            throw new IllegalStateException("Unable to get script engine for language: " + script.getLanguage());
        }
        return engine;
    }

    private Bindings mergeBindings(Bindings ... allBindings) {
        Bindings result = new SimpleBindings();
        for (Bindings scope : allBindings) {
            if (scope == null) continue;
            result = new ChainedBindings(result, scope);
        }
        return result;
    }

    private ScriptContext buildScriptContext(Bindings engineScope) {
        SimpleScriptContext context = new SimpleScriptContext();
        context.setBindings(engineScope, 100);
        context.setBindings(this.scriptEngineManager.getBindings(), 200);
        context.setReader(null);
        context.setWriter((Writer)NullWriter.DEFAULT);
        context.setErrorWriter((Writer)NullWriter.DEFAULT);
        return context;
    }
}

