/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.script.Bindings;
import javax.script.ScriptException;
import org.forgerock.openam.audit.context.AuditRequestContextPropagatingExecutorService;
import org.forgerock.openam.audit.context.ConfigurableExecutorService;
import org.forgerock.openam.audit.context.ExecutorServiceConfigurator;
import org.forgerock.openam.scripting.ScriptEngineConfiguration;
import org.forgerock.openam.scripting.ScriptEvaluator;
import org.forgerock.openam.scripting.ScriptObject;
import org.forgerock.openam.scripting.StandardScriptEngineManager;
import org.forgerock.openam.shared.concurrency.ResizableLinkedBlockingQueue;
import org.forgerock.util.Reject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public final class ThreadPoolScriptEvaluator
implements ScriptEvaluator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadPoolScriptEvaluator.class);
    private final StandardScriptEngineManager scriptEngineManager;
    private final ExecutorService threadPool;
    private final ScriptEvaluator delegate;

    @Inject
    public ThreadPoolScriptEvaluator(StandardScriptEngineManager scriptEngineManager, ExecutorService threadPool, ScriptEvaluator delegate) {
        Reject.ifNull((Object[])new Object[]{scriptEngineManager, threadPool, delegate});
        this.scriptEngineManager = scriptEngineManager;
        this.threadPool = threadPool;
        this.delegate = delegate;
        scriptEngineManager.addConfigurationListener(new ThreadPoolConfigurator(threadPool));
    }

    @Override
    public <T> T evaluateScript(ScriptObject script, Bindings bindings) throws ScriptException {
        Future future = this.threadPool.submit(new ScriptExecutorTask(script, bindings));
        long timeout = this.scriptEngineManager.getConfiguration().getScriptExecutionTimeout();
        try {
            if (timeout == 0L) {
                Object t = future.get();
                return t;
            }
            Object t = future.get(timeout, TimeUnit.SECONDS);
            return t;
        }
        catch (ExecutionException ex) {
            LOGGER.error("Script terminated with exception", (Throwable)ex);
            throw new ScriptException(ex);
        }
        catch (TimeoutException ex) {
            LOGGER.warn("Script timed out");
            throw new ScriptException(ex);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            LOGGER.debug("Interrupted while waiting for script result");
            throw new ScriptException(ex);
        }
        finally {
            future.cancel(true);
        }
    }

    @Override
    public void bindVariableInGlobalScope(String name, Object object) {
        this.delegate.bindVariableInGlobalScope(name, object);
    }

    private final class ScriptExecutorTask<T>
    implements Callable<T> {
        private final ScriptObject scriptObject;
        private final Bindings bindings;

        private ScriptExecutorTask(ScriptObject scriptObject, Bindings bindings) {
            Reject.ifNull((Object)scriptObject);
            this.scriptObject = scriptObject;
            this.bindings = bindings;
        }

        @Override
        public T call() throws ScriptException {
            return ThreadPoolScriptEvaluator.this.delegate.evaluateScript(this.scriptObject, this.bindings);
        }
    }

    private static final class ThreadPoolConfigurator
    implements StandardScriptEngineManager.ConfigurationListener {
        private final ExecutorService executorService;

        ThreadPoolConfigurator(ExecutorService executorService) {
            this.executorService = executorService;
        }

        @Override
        public void onConfigurationChange(ScriptEngineConfiguration newConfiguration) {
            ExecutorServiceConfigurator delegateConfigurator = this.getDelegateConfigurator(this.executorService);
            if (delegateConfigurator == null) {
                LOGGER.warn("Unable to reconfigure script evaluation thread pool - pool is not reconfigurable");
                return;
            }
            try {
                int newThreadPoolQueueSize = newConfiguration.getThreadPoolQueueSize();
                ResizableLinkedBlockingQueue currentQueue = (ResizableLinkedBlockingQueue)((ThreadPoolExecutor)((AuditRequestContextPropagatingExecutorService)this.executorService).getDelegate()).getQueue();
                int currentThreadPoolQueueSize = currentQueue.getMaximumQueueSize();
                if (newThreadPoolQueueSize != currentThreadPoolQueueSize) {
                    currentQueue.resizeQueue(newThreadPoolQueueSize);
                }
                if (delegateConfigurator.getCorePoolSize() != newConfiguration.getThreadPoolCoreSize() || delegateConfigurator.getMaximumPoolSize() != newConfiguration.getThreadPoolMaxSize() || delegateConfigurator.getKeepAliveTime(TimeUnit.SECONDS) != newConfiguration.getThreadPoolIdleTimeoutSeconds()) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Reconfiguring script evaluation thread pool. Core pool size: old={}, new={}. Max pool size: old={}, new={}. Idle timeout (seconds): old={}, new={}.", new Object[]{delegateConfigurator.getCorePoolSize(), newConfiguration.getThreadPoolCoreSize(), delegateConfigurator.getMaximumPoolSize(), newConfiguration.getThreadPoolMaxSize(), delegateConfigurator.getKeepAliveTime(TimeUnit.SECONDS), newConfiguration.getThreadPoolIdleTimeoutSeconds()});
                    }
                    delegateConfigurator.setMaximumPoolSize(newConfiguration.getThreadPoolMaxSize());
                    delegateConfigurator.setCorePoolSize(newConfiguration.getThreadPoolCoreSize());
                    delegateConfigurator.setKeepAliveTime(newConfiguration.getThreadPoolIdleTimeoutSeconds(), TimeUnit.SECONDS);
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.error("Attempt to configure script evaluation thread pool with invalid parameters", (Throwable)ex);
            }
        }

        private ExecutorServiceConfigurator getDelegateConfigurator(ExecutorService executorService) {
            ConfigurableExecutorService configurableExecutorService;
            if (executorService instanceof ThreadPoolExecutor) {
                return new ExecutorServiceConfigurator((ThreadPoolExecutor)executorService);
            }
            if (executorService instanceof ConfigurableExecutorService && (configurableExecutorService = (ConfigurableExecutorService)executorService).isConfigurable()) {
                return configurableExecutorService.getConfigurator();
            }
            return null;
        }
    }
}

