/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.api;

import com.iplanet.sso.SSOException;
import com.sun.identity.idm.AMIdentity;
import com.sun.identity.idm.IdRepoException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.forgerock.openam.utils.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedIdentity {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"Scripting");
    private final AMIdentity amIdentity;

    public ScriptedIdentity(AMIdentity amIdentity) {
        this.amIdentity = amIdentity;
    }

    public Set getAttribute(String attributeName) {
        try {
            return this.amIdentity.getAttribute(attributeName);
        }
        catch (IdRepoException e) {
            LOGGER.warn("Exception trying to get attribute", (Throwable)e);
        }
        catch (SSOException e) {
            LOGGER.warn("SSO Exception", (Throwable)e);
        }
        return null;
    }

    public void setAttribute(String attributeName, Object[] attributeValues) {
        Set attributeValuesAsSet = CollectionUtils.asSet((Object[])attributeValues);
        HashMap<String, Set> attributes = new HashMap<String, Set>();
        attributes.put(attributeName, attributeValuesAsSet);
        try {
            this.amIdentity.setAttributes(attributes);
        }
        catch (IdRepoException e) {
            LOGGER.warn("Exception trying to set attribute", (Throwable)e);
        }
        catch (SSOException e) {
            LOGGER.warn("SSO Exception", (Throwable)e);
        }
    }

    public void addAttribute(String attributeName, String attributeValue) {
        HashSet<String> currentAttributeValues = null;
        try {
            currentAttributeValues = this.amIdentity.getAttribute(attributeName);
        }
        catch (IdRepoException e) {
            LOGGER.warn("Attribute '" + attributeName + "' doesn't currently exist. Creating new attribute..");
        }
        catch (SSOException e) {
            LOGGER.warn("SSO Exception", (Throwable)e);
        }
        if (currentAttributeValues == null) {
            currentAttributeValues = new HashSet<String>();
        }
        currentAttributeValues.add(attributeValue);
        this.setAttribute(attributeName, currentAttributeValues.toArray());
    }

    public void store() {
        try {
            this.amIdentity.store();
        }
        catch (IdRepoException e) {
            LOGGER.warn("Exception persisting attribute", (Throwable)e);
        }
        catch (SSOException e) {
            LOGGER.warn("Exception persisting attribute", (Throwable)e);
        }
    }
}

