/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.factories;

import java.util.Arrays;
import java.util.List;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import org.forgerock.openam.scripting.factories.RhinoScriptEngine;
import org.forgerock.util.Reject;
import org.forgerock.util.Utils;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;

public class RhinoScriptEngineFactory
implements ScriptEngineFactory {
    public static final int INTERPRETED = -1;
    private final ContextFactory contextFactory;
    private final String version;
    private final String languageVersion;
    private volatile ClassShutter classShutter;
    private volatile int optimisationLevel = -1;

    public RhinoScriptEngineFactory(ContextFactory contextFactory) {
        Reject.ifNull((Object)contextFactory);
        this.contextFactory = contextFactory;
        Context context = contextFactory.enterContext();
        try {
            this.version = context.getImplementationVersion();
            this.languageVersion = String.valueOf(context.getLanguageVersion());
        }
        finally {
            Context.exit();
        }
    }

    public RhinoScriptEngineFactory() {
        this(new ContextFactory());
    }

    @Override
    public String getEngineName() {
        return "rhino";
    }

    @Override
    public String getEngineVersion() {
        return this.version;
    }

    @Override
    public List<String> getExtensions() {
        return Arrays.asList("js");
    }

    @Override
    public List<String> getMimeTypes() {
        return Arrays.asList("text/javascript", "application/javascript");
    }

    @Override
    public List<String> getNames() {
        return Arrays.asList(this.getEngineName());
    }

    @Override
    public String getLanguageName() {
        return "javascript";
    }

    @Override
    public String getLanguageVersion() {
        return this.languageVersion;
    }

    @Override
    public Object getParameter(String paramName) {
        if ("javax.script.language".equals(paramName)) {
            return this.getLanguageName();
        }
        if ("javax.script.engine".equals(paramName)) {
            return this.getEngineName();
        }
        if ("javax.script.name".equals(paramName)) {
            return this.getLanguageName();
        }
        if ("javax.script.language_version".equals(paramName)) {
            return this.getLanguageVersion();
        }
        if ("javax.script.engine_version".equals(paramName)) {
            return this.getEngineVersion();
        }
        return null;
    }

    @Override
    public String getMethodCallSyntax(String object, String method, String ... args) {
        return String.format("%s.%s(%s)", object, method, Utils.joinAsString((String)", ", (Object[])args));
    }

    @Override
    public String getOutputStatement(String s) {
        return String.format("logger.message(%s)", s);
    }

    @Override
    public String getProgram(String ... statements) {
        return Utils.joinAsString((String)";\n", (Object[])statements);
    }

    @Override
    public ScriptEngine getScriptEngine() {
        return new RhinoScriptEngine(this);
    }

    Context getContext() {
        Context context = this.contextFactory.enterContext();
        context.setOptimizationLevel(this.optimisationLevel);
        ClassShutter sandbox = this.classShutter;
        if (sandbox != null) {
            context.setClassShutter(sandbox);
        }
        return context;
    }

    void releaseContext(Context context) {
        Context.exit();
    }

    public void setOptimisationLevel(int optimisationLevel) {
        this.optimisationLevel = optimisationLevel;
    }

    public void setClassShutter(ClassShutter classShutter) {
        this.classShutter = classShutter;
    }

    public String toString() {
        return "RhinoScriptEngineFactory{contextFactory=" + this.contextFactory + ", version='" + this.version + '\'' + ", languageVersion='" + this.languageVersion + '\'' + ", classShutter=" + this.classShutter + ", optimisationLevel=" + this.optimisationLevel + '}';
    }
}

