/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.factories;

import java.io.Reader;
import javax.script.AbstractScriptEngine;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptException;
import org.forgerock.openam.scripting.factories.GroovyEngineFactory;
import org.forgerock.util.Reject;
import org.kohsuke.groovy.sandbox.GroovyValueFilter;

final class SandboxedGroovyScriptEngine
extends AbstractScriptEngine
implements Compilable {
    private final GroovyEngineFactory factory;
    private final ScriptEngine realEngine;
    private final GroovyValueFilter sandbox;

    SandboxedGroovyScriptEngine(GroovyEngineFactory factory, ScriptEngine realEngine, GroovyValueFilter sandbox) {
        Reject.ifNull((Object[])new Object[]{factory, realEngine, sandbox});
        this.realEngine = realEngine;
        this.sandbox = sandbox;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(String script, ScriptContext scriptContext) throws ScriptException {
        this.sandbox.register();
        try {
            Object object = this.realEngine.eval(script, scriptContext);
            return object;
        }
        finally {
            this.sandbox.unregister();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object eval(Reader reader, ScriptContext scriptContext) throws ScriptException {
        this.sandbox.register();
        try {
            Object object = this.realEngine.eval(reader, scriptContext);
            return object;
        }
        finally {
            this.sandbox.unregister();
        }
    }

    @Override
    public Bindings createBindings() {
        return this.realEngine.createBindings();
    }

    @Override
    public ScriptEngineFactory getFactory() {
        return this.factory;
    }

    @Override
    public CompiledScript compile(String script) throws ScriptException {
        return new SandboxedCompiledScript(((Compilable)((Object)this.realEngine)).compile(script));
    }

    @Override
    public CompiledScript compile(Reader reader) throws ScriptException {
        return new SandboxedCompiledScript(((Compilable)((Object)this.realEngine)).compile(reader));
    }

    GroovyValueFilter getSandbox() {
        return this.sandbox;
    }

    private final class SandboxedCompiledScript
    extends CompiledScript {
        private final CompiledScript realCompiledScript;

        private SandboxedCompiledScript(CompiledScript realCompiledScript) {
            Reject.ifNull((Object)realCompiledScript);
            this.realCompiledScript = realCompiledScript;
        }

        @Override
        public Object eval(ScriptContext scriptContext) throws ScriptException {
            SandboxedGroovyScriptEngine.this.sandbox.register();
            try {
                Object object = this.realCompiledScript.eval(scriptContext);
                return object;
            }
            finally {
                SandboxedGroovyScriptEngine.this.sandbox.unregister();
            }
        }

        @Override
        public ScriptEngine getEngine() {
            return SandboxedGroovyScriptEngine.this;
        }
    }
}

