/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.guice;

import com.google.inject.AbstractModule;
import com.google.inject.Provides;
import com.google.inject.Scopes;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.forgerock.guice.core.GuiceModule;
import org.forgerock.http.Client;
import org.forgerock.http.client.RestletHttpClient;
import org.forgerock.openam.audit.context.AMExecutorServiceFactory;
import org.forgerock.openam.scripting.ScriptConstants;
import org.forgerock.openam.scripting.ScriptEngineConfiguration;
import org.forgerock.openam.scripting.ScriptEvaluator;
import org.forgerock.openam.scripting.ScriptValidator;
import org.forgerock.openam.scripting.StandardScriptEngineManager;
import org.forgerock.openam.scripting.StandardScriptEvaluator;
import org.forgerock.openam.scripting.StandardScriptValidator;
import org.forgerock.openam.scripting.SupportedScriptingLanguage;
import org.forgerock.openam.scripting.ThreadPoolScriptEvaluator;
import org.forgerock.openam.scripting.api.http.GroovyHttpClient;
import org.forgerock.openam.scripting.api.http.JavaScriptHttpClient;
import org.forgerock.openam.shared.concurrency.ResizableLinkedBlockingQueue;
import org.forgerock.openam.shared.guice.CloseableHttpClientProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@GuiceModule
public class ScriptingGuiceModule
extends AbstractModule {
    private final Logger logger = LoggerFactory.getLogger((String)"Scripting");

    protected void configure() {
        this.bind(ScriptValidator.class).to(StandardScriptValidator.class);
        this.bind(Logger.class).annotatedWith((Annotation)Names.named((String)"ScriptLogger")).toInstance((Object)this.logger);
        this.bind(StandardScriptEngineManager.class).annotatedWith((Annotation)Names.named((String)ScriptConstants.ScriptContext.AUTHENTICATION_SERVER_SIDE.name())).toInstance((Object)new StandardScriptEngineManager());
        this.bind(StandardScriptEngineManager.class).annotatedWith((Annotation)Names.named((String)ScriptConstants.ScriptContext.POLICY_CONDITION.name())).toInstance((Object)new StandardScriptEngineManager());
        this.bind(StandardScriptEngineManager.class).annotatedWith((Annotation)Names.named((String)ScriptConstants.ScriptContext.OIDC_CLAIMS.name())).toInstance((Object)new StandardScriptEngineManager());
        this.bind(RestletHttpClient.class).annotatedWith((Annotation)Names.named((String)SupportedScriptingLanguage.JAVASCRIPT.name())).to(JavaScriptHttpClient.class);
        this.bind(RestletHttpClient.class).annotatedWith((Annotation)Names.named((String)SupportedScriptingLanguage.GROOVY.name())).to(GroovyHttpClient.class);
        this.bind(Client.class).annotatedWith((Annotation)Names.named((String)"ScriptingHttpClient")).toProvider(CloseableHttpClientProvider.class).in(Scopes.SINGLETON);
    }

    @Provides
    @Singleton
    @Inject
    @Named(value="AUTHENTICATION_SERVER_SIDE")
    ScriptEvaluator getAuthenticationServerSideScriptEvaluator(@Named(value="AUTHENTICATION_SERVER_SIDE") StandardScriptEngineManager scriptEngineManager, AMExecutorServiceFactory executorServiceFactory) {
        return this.createEvaluator(scriptEngineManager, executorServiceFactory);
    }

    @Provides
    @Singleton
    @Inject
    @Named(value="POLICY_CONDITION")
    ScriptEvaluator getPoliyConditionScriptEvaluator(@Named(value="POLICY_CONDITION") StandardScriptEngineManager scriptEngineManager, AMExecutorServiceFactory executorServiceFactory) {
        return this.createEvaluator(scriptEngineManager, executorServiceFactory);
    }

    @Provides
    @Singleton
    @Inject
    @Named(value="OIDC_CLAIMS")
    ScriptEvaluator getOidcClaimsScriptEvaluator(@Named(value="OIDC_CLAIMS") StandardScriptEngineManager scriptEngineManager, AMExecutorServiceFactory executorServiceFactory) {
        return this.createEvaluator(scriptEngineManager, executorServiceFactory);
    }

    private ThreadPoolScriptEvaluator createEvaluator(StandardScriptEngineManager scriptEngineManager, AMExecutorServiceFactory executorServiceFactory) {
        ScriptEngineConfiguration configuration = scriptEngineManager.getConfiguration();
        return new ThreadPoolScriptEvaluator(scriptEngineManager, executorServiceFactory.createThreadPool(configuration.getThreadPoolCoreSize(), configuration.getThreadPoolMaxSize(), configuration.getThreadPoolIdleTimeoutSeconds(), TimeUnit.SECONDS, this.getThreadPoolQueue(configuration.getThreadPoolQueueSize()), "ScriptEvaluator"), new StandardScriptEvaluator(scriptEngineManager));
    }

    private BlockingQueue<Runnable> getThreadPoolQueue(int size) {
        return size == -1 ? new ResizableLinkedBlockingQueue() : new ResizableLinkedBlockingQueue(size);
    }
}

