/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.rest;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.openam.errors.ExceptionMappingHandler;
import org.forgerock.openam.forgerockrest.utils.ServerContextUtils;
import org.forgerock.openam.scripting.ScriptConstants;
import org.forgerock.openam.scripting.ScriptException;
import org.forgerock.services.context.Context;

public class ScriptExceptionMappingHandler
implements ExceptionMappingHandler<ScriptException, ResourceException> {
    private static final Map<ScriptConstants.ScriptErrorCode, Integer> ERROR_CODE_MAP = new HashMap<ScriptConstants.ScriptErrorCode, Integer>();

    public ResourceException handleError(Context context, String debug, Request request, ScriptException error) {
        return ResourceException.getException((int)this.getResourceErrorCode(error.getScriptErrorCode()), (String)this.getLocalizedMessage(context, error), (Throwable)((Object)error));
    }

    public ResourceException handleError(String debug, Request request, ScriptException error) {
        return this.handleError(error);
    }

    public ResourceException handleError(Context context, Request request, ScriptException error) {
        return ResourceException.getException((int)this.getResourceErrorCode(error.getScriptErrorCode()), (String)this.getLocalizedMessage(context, error), (Throwable)((Object)error));
    }

    public ResourceException handleError(Request request, ScriptException error) {
        return this.handleError(error);
    }

    public ResourceException handleError(ScriptException error) {
        return ResourceException.getException((int)this.getResourceErrorCode(error.getScriptErrorCode()), (String)error.getMessage(), (Throwable)((Object)error));
    }

    private String getLocalizedMessage(Context context, ScriptException exception) {
        Locale local = ServerContextUtils.getLocaleFromContext((Context)context);
        if (local == null) {
            return exception.getMessage();
        }
        return exception.getL10NMessage(local);
    }

    private int getResourceErrorCode(ScriptConstants.ScriptErrorCode scriptErrorCode) {
        if (ERROR_CODE_MAP.isEmpty()) {
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.CONTEXT_NOT_RECOGNISED, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.LANGUAGE_NOT_SUPPORTED, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.FIND_BY_NAME_FAILED, 500);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.FIND_BY_UUID_FAILED, 500);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.DELETE_FAILED, 500);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.RETRIEVE_FAILED, 500);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.RETRIEVE_ALL_FAILED, 500);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.SAVE_FAILED, 500);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.INSUFFICIENT_PRIVILEGES, 403);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.MISSING_SCRIPT_UUID, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.MISSING_SCRIPT_NAME, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.MISSING_SCRIPT, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.MISSING_SCRIPTING_LANGUAGE, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.MISSING_SCRIPT_CONTEXT, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.SCRIPT_NAME_EXISTS, 409);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.SCRIPT_UUID_EXISTS, 500);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.SCRIPT_UUID_NOT_FOUND, 404);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.FILTER_BOOLEAN_LITERAL_FALSE, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.FILTER_EXTENDED_MATCH, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.FILTER_GREATER_THAN, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.FILTER_GREATER_THAN_OR_EQUAL, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.FILTER_LESS_THAN, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.FILTER_LESS_THAN_OR_EQUAL, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.FILTER_NOT, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.FILTER_PRESENT, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.RESOURCE_FILTER_NOT_SUPPORTED, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.SCRIPT_DECODING_FAILED, 400);
            ERROR_CODE_MAP.put(ScriptConstants.ScriptErrorCode.DELETING_DEFAULT_SCRIPT, 403);
        }
        return ERROR_CODE_MAP.containsKey((Object)scriptErrorCode) ? ERROR_CODE_MAP.get((Object)scriptErrorCode) : 500;
    }
}

