/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.rest;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.sun.identity.shared.encode.Base64;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.forgerock.api.annotations.Action;
import org.forgerock.api.annotations.ApiError;
import org.forgerock.api.annotations.CollectionProvider;
import org.forgerock.api.annotations.Create;
import org.forgerock.api.annotations.Delete;
import org.forgerock.api.annotations.Handler;
import org.forgerock.api.annotations.Operation;
import org.forgerock.api.annotations.Parameter;
import org.forgerock.api.annotations.Query;
import org.forgerock.api.annotations.Read;
import org.forgerock.api.annotations.Schema;
import org.forgerock.api.annotations.Update;
import org.forgerock.api.enums.QueryType;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Responses;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.openam.errors.ExceptionMappingHandler;
import org.forgerock.openam.rest.RealmAwareResource;
import org.forgerock.openam.rest.query.QueryByStringFilterConverter;
import org.forgerock.openam.rest.query.QueryResponsePresentation;
import org.forgerock.openam.scripting.ScriptConstants;
import org.forgerock.openam.scripting.ScriptError;
import org.forgerock.openam.scripting.ScriptException;
import org.forgerock.openam.scripting.ScriptObject;
import org.forgerock.openam.scripting.ScriptValidator;
import org.forgerock.openam.scripting.SupportedScriptingLanguage;
import org.forgerock.openam.scripting.service.ScriptConfiguration;
import org.forgerock.openam.scripting.service.ScriptingServiceFactory;
import org.forgerock.openam.utils.CollectionUtils;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.query.QueryFilterVisitor;
import org.slf4j.Logger;

@CollectionProvider(details=@Handler(title="i18n:api-descriptor/ScriptResource#title", description="i18n:api-descriptor/ScriptResource#description", mvccSupported=false, resourceSchema=@Schema(schemaResource="ScriptResource.schema.json")), pathParam=@Parameter(name="scriptId", type="string", description="i18n:api-descriptor/ScriptResource#pathparam.description"))
public class ScriptResource
extends RealmAwareResource {
    private final Logger logger;
    private final ScriptingServiceFactory serviceFactory;
    private final ExceptionMappingHandler<ScriptException, ResourceException> exceptionMappingHandler;
    private final ScriptValidator scriptValidator;

    @Inject
    public ScriptResource(@Named(value="ScriptLogger") Logger logger, ScriptingServiceFactory scriptConfigService, ExceptionMappingHandler<ScriptException, ResourceException> exceptionMappingHandler, ScriptValidator scriptValidator) {
        this.logger = logger;
        this.serviceFactory = scriptConfigService;
        this.exceptionMappingHandler = exceptionMappingHandler;
        this.scriptValidator = scriptValidator;
    }

    @Action(name="validate", operationDescription=@Operation(errors={@ApiError(code=400, description="i18n:api-descriptor/ScriptResource#error.missing.script"), @ApiError(code=400, description="i18n:api-descriptor/ScriptResource#error.script.decode"), @ApiError(code=400, description="i18n:api-descriptor/ScriptResource#error.script.language.not.supported")}, description="i18n:api-descriptor/ScriptResource#validate.action.description"), request=@Schema(schemaResource="ScriptResource.action.validate.request.schema.json"), response=@Schema(schemaResource="ScriptResource.action.validate.response.schema.json"))
    public Promise<ActionResponse, ResourceException> actionCollection(Context context, ActionRequest request) {
        if ("validate".equals(request.getAction())) {
            try {
                JsonValue json = request.getContent();
                SupportedScriptingLanguage language = ScriptConstants.getLanguageFromString(json.get("language").asString());
                String script = json.get("script").asString();
                if (script == null) {
                    throw new ScriptException(ScriptConstants.ScriptErrorCode.MISSING_SCRIPT, new String[0]);
                }
                List<ScriptError> scriptErrorList = this.scriptValidator.validateScript(new ScriptObject("", this.decodeScript(script), language, null));
                if (scriptErrorList.isEmpty()) {
                    return Promises.newResultPromise((Object)Responses.newActionResponse((JsonValue)JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"success", (Object)true)}))));
                }
                HashSet<Map> errors = new HashSet<Map>();
                for (ScriptError error : scriptErrorList) {
                    errors.add(JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"line", (Object)error.getLineNumber()), JsonValue.field((String)"column", (Object)error.getColumnNumber()), JsonValue.field((String)"message", (Object)error.getMessage())}));
                }
                return Promises.newResultPromise((Object)Responses.newActionResponse((JsonValue)JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"success", (Object)false), JsonValue.field((String)"errors", (Object)CollectionUtils.newList(errors))}))));
            }
            catch (ScriptException se) {
                return ((ResourceException)this.exceptionMappingHandler.handleError(context, (Request)request, (Exception)((Object)se))).asPromise();
            }
        }
        return new NotSupportedException().asPromise();
    }

    public Promise<ActionResponse, ResourceException> actionInstance(Context context, String resourceId, ActionRequest request) {
        return new NotSupportedException().asPromise();
    }

    public Promise<ResourceResponse, ResourceException> patchInstance(Context context, String resourceId, PatchRequest request) {
        return new NotSupportedException().asPromise();
    }

    @Create(operationDescription=@Operation(errors={@ApiError(code=400, description="i18n:api-descriptor/ScriptResource#error.script.decode")}, description="i18n:api-descriptor/ScriptResource#create.description"))
    public Promise<ResourceResponse, ResourceException> createInstance(Context context, CreateRequest request) {
        try {
            if (request.getNewResourceId() != null) {
                return new NotSupportedException("IDs for scripts are generated and cannot be provided").asPromise();
            }
            ScriptConfiguration sc = this.serviceFactory.create(this.getRealm(context)).create(this.fromJson(request.getContent()), this.getContextSubject(context));
            return Promises.newResultPromise((Object)Responses.newResourceResponse((String)sc.getId(), (String)String.valueOf(sc.hashCode()), (JsonValue)this.asJson(sc)));
        }
        catch (ScriptException se) {
            return ((ResourceException)this.exceptionMappingHandler.handleError(context, (Request)request, (Exception)((Object)se))).asPromise();
        }
    }

    @Delete(operationDescription=@Operation(errors={@ApiError(code=400, description="i18n:api-descriptor/ScriptResource#error.cannot.find.realm"), @ApiError(code=403, description="i18n:api-descriptor/ScriptResource#error.cannot.delete.default.script"), @ApiError(code=404, description="i18n:api-descriptor/ScriptResource#error.script.not.found"), @ApiError(code=500, description="i18n:api-descriptor/ScriptResource#error.delete.script.used.once"), @ApiError(code=500, description="i18n:api-descriptor/ScriptResource#error.delete.script.used.multiple"), @ApiError(code=500, description="i18n:api-descriptor/ScriptResource#error.delete.failed")}, description="i18n:api-descriptor/ScriptResource#delete.description"))
    public Promise<ResourceResponse, ResourceException> deleteInstance(Context context, String resourceId, DeleteRequest request) {
        try {
            this.serviceFactory.create(this.getRealm(context)).delete(resourceId);
            return Promises.newResultPromise((Object)Responses.newResourceResponse((String)resourceId, null, (JsonValue)JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[0]))));
        }
        catch (ScriptException se) {
            return ((ResourceException)this.exceptionMappingHandler.handleError(context, (Request)request, (Exception)((Object)se))).asPromise();
        }
    }

    @Query(operationDescription=@Operation(description="i18n:api-descriptor/ScriptResource#query.description"), type=QueryType.FILTER, queryableFields={"*"})
    public Promise<QueryResponse, ResourceException> queryCollection(Context context, QueryRequest request, QueryResourceHandler resultHandler) {
        QueryFilter filter = request.getQueryFilter();
        try {
            Set<ScriptConfiguration> configs;
            if (filter == null) {
                configs = this.serviceFactory.create(this.getRealm(context)).getAll();
            } else {
                QueryFilter stringQueryFilter = (QueryFilter)filter.accept((QueryFilterVisitor)new QueryByStringFilterConverter(), null);
                configs = this.serviceFactory.create(this.getRealm(context)).get((QueryFilter<String>)stringQueryFilter);
            }
            ArrayList<ResourceResponse> results = new ArrayList<ResourceResponse>();
            for (ScriptConfiguration configuration : configs) {
                String id = configuration.getId();
                results.add(Responses.newResourceResponse((String)id, null, (JsonValue)this.asJson(configuration)));
            }
            QueryResponsePresentation.enableDeprecatedRemainingQueryResponse((QueryRequest)request);
            return QueryResponsePresentation.perform((QueryResourceHandler)resultHandler, (QueryRequest)request, results);
        }
        catch (ScriptException se) {
            return ((ResourceException)this.exceptionMappingHandler.handleError(context, (Request)request, (Exception)((Object)se))).asPromise();
        }
    }

    @Read(operationDescription=@Operation(errors={@ApiError(code=400, description="i18n:api-descriptor/ScriptResource#error.script.not.found")}, description="i18n:api-descriptor/ScriptResource#read.description"))
    public Promise<ResourceResponse, ResourceException> readInstance(Context context, String resourceId, ReadRequest request) {
        try {
            return Promises.newResultPromise((Object)Responses.newResourceResponse((String)resourceId, null, (JsonValue)this.asJson(this.serviceFactory.create(this.getRealm(context)).get(resourceId))));
        }
        catch (ScriptException se) {
            return ((ResourceException)this.exceptionMappingHandler.handleError(context, (Request)request, (Exception)((Object)se))).asPromise();
        }
    }

    @Update(operationDescription=@Operation(errors={@ApiError(code=400, description="i18n:api-descriptor/ScriptResource#error.script.decode"), @ApiError(code=400, description="i18n:api-descriptor/ScriptResource#error.script.language.not.supported"), @ApiError(code=400, description="i18n:api-descriptor/ScriptResource#error.script.type.not.found"), @ApiError(code=404, description="i18n:api-descriptor/ScriptResource#error.script.not.found"), @ApiError(code=400, description="i18n:api-descriptor/ScriptResource#error.script.name.empty"), @ApiError(code=400, description="i18n:api-descriptor/ScriptResource#error.script.not.specified"), @ApiError(code=400, description="i18n:api-descriptor/ScriptResource#error.script.language.not.spec"), @ApiError(code=400, description="i18n:api-descriptor/ScriptResource#error.script.type.not.spec")}, description="i18n:api-descriptor/ScriptResource#update.description"))
    public Promise<ResourceResponse, ResourceException> updateInstance(Context context, String resourceId, UpdateRequest request) {
        try {
            return Promises.newResultPromise((Object)Responses.newResourceResponse((String)resourceId, null, (JsonValue)this.asJson(this.serviceFactory.create(this.getRealm(context)).update(this.fromJson(request.getContent(), resourceId), this.getContextSubject(context)))));
        }
        catch (ScriptException se) {
            return ((ResourceException)this.exceptionMappingHandler.handleError(context, (Request)request, (Exception)((Object)se))).asPromise();
        }
    }

    private JsonValue asJson(ScriptConfiguration scriptConfig) {
        return JsonValue.json((Object)JsonValue.object((Map.Entry[])new Map.Entry[]{JsonValue.field((String)"_id", (Object)scriptConfig.getId()), JsonValue.field((String)"name", (Object)scriptConfig.getName()), JsonValue.field((String)"description", (Object)scriptConfig.getDescription()), JsonValue.field((String)"script", (Object)Base64.encode((byte[])scriptConfig.getScript().getBytes(StandardCharsets.UTF_8))), JsonValue.field((String)"default", (Object)scriptConfig.isDefault()), JsonValue.field((String)"language", (Object)scriptConfig.getLanguage().name()), JsonValue.field((String)"context", (Object)scriptConfig.getContext().name()), JsonValue.field((String)"createdBy", (Object)scriptConfig.getCreatedBy()), JsonValue.field((String)"creationDate", (Object)scriptConfig.getCreationDate()), JsonValue.field((String)"lastModifiedBy", (Object)scriptConfig.getLastModifiedBy()), JsonValue.field((String)"lastModifiedDate", (Object)scriptConfig.getLastModifiedDate())}));
    }

    private ScriptConfiguration fromJson(JsonValue jsonValue, String uuid) throws ScriptException {
        String language = jsonValue.get("language").asString();
        String context = jsonValue.get("context").asString();
        ScriptConfiguration.Builder builder = ScriptConfiguration.builder().setId(uuid).setName(jsonValue.get("name").asString()).setDescription(jsonValue.get("description").asString()).setScript(this.decodeScript(jsonValue.get("script").asString())).setLanguage(language == null ? null : ScriptConstants.getLanguageFromString(language)).setContext(context == null ? null : ScriptConstants.getContextFromString(context));
        if (uuid == null) {
            builder.generateId();
        }
        return builder.build();
    }

    private ScriptConfiguration fromJson(JsonValue jsonValue) throws ScriptException {
        return this.fromJson(jsonValue, null);
    }

    private String decodeScript(String encodedScript) throws ScriptException {
        if (encodedScript == null) {
            return null;
        }
        byte[] decodedScript = Base64.decode((String)encodedScript);
        if (decodedScript == null) {
            throw ScriptException.createAndLogError(this.logger, ScriptConstants.ScriptErrorCode.SCRIPT_DECODING_FAILED, new String[0]);
        }
        return new String(decodedScript, StandardCharsets.UTF_8);
    }
}

