/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.rest.batch;

import com.sun.identity.shared.debug.Debug;
import javax.inject.Inject;
import javax.inject.Named;
import javax.script.SimpleBindings;
import org.forgerock.json.JsonPointer;
import org.forgerock.json.JsonValue;
import org.forgerock.json.resource.ActionRequest;
import org.forgerock.json.resource.ActionResponse;
import org.forgerock.json.resource.BadRequestException;
import org.forgerock.json.resource.CreateRequest;
import org.forgerock.json.resource.DeleteRequest;
import org.forgerock.json.resource.InternalServerErrorException;
import org.forgerock.json.resource.NotSupportedException;
import org.forgerock.json.resource.PatchRequest;
import org.forgerock.json.resource.QueryRequest;
import org.forgerock.json.resource.QueryResourceHandler;
import org.forgerock.json.resource.QueryResponse;
import org.forgerock.json.resource.ReadRequest;
import org.forgerock.json.resource.Request;
import org.forgerock.json.resource.ResourceException;
import org.forgerock.json.resource.ResourceResponse;
import org.forgerock.json.resource.Responses;
import org.forgerock.json.resource.UpdateRequest;
import org.forgerock.openam.errors.ExceptionMappingHandler;
import org.forgerock.openam.rest.RealmAwareResource;
import org.forgerock.openam.rest.RestUtils;
import org.forgerock.openam.scripting.ScriptEvaluator;
import org.forgerock.openam.scripting.ScriptException;
import org.forgerock.openam.scripting.ScriptObject;
import org.forgerock.openam.scripting.rest.batch.helpers.Requester;
import org.forgerock.openam.scripting.rest.batch.helpers.ScriptResponse;
import org.forgerock.openam.scripting.service.ScriptConfiguration;
import org.forgerock.openam.scripting.service.ScriptingServiceFactory;
import org.forgerock.services.context.Context;
import org.forgerock.util.promise.Promise;
import org.forgerock.util.promise.Promises;

public class BatchResource
extends RealmAwareResource {
    private static final String BATCH = "batch";
    private static final String PAYLOAD = "payload";
    private static final String CONTEXT = "context";
    private static final String LOGGER = "logger";
    private static final String REQUESTER = "requester";
    private static final String RESPONSE = "response";
    private static final JsonPointer SCRIPT_ID = new JsonPointer("/scriptId");
    private static final JsonPointer REQUESTS = new JsonPointer("/requests");
    private final ExceptionMappingHandler<ScriptException, ResourceException> exceptionMappingHandler;
    private final ScriptEvaluator scriptEvaluator;
    private final ScriptingServiceFactory scriptingServiceFactory;
    private final Debug debug;
    private final Requester requester;

    @Inject
    public BatchResource(ScriptEvaluator scriptEvaluator, ScriptingServiceFactory scriptingServiceFactory, @Named(value="frRest") Debug debug, ExceptionMappingHandler<ScriptException, ResourceException> exceptionMappingHandler, Requester requester) {
        this.scriptEvaluator = scriptEvaluator;
        this.scriptingServiceFactory = scriptingServiceFactory;
        this.debug = debug;
        this.exceptionMappingHandler = exceptionMappingHandler;
        this.requester = requester;
    }

    public Promise<ActionResponse, ResourceException> actionCollection(Context serverContext, ActionRequest actionRequest) {
        if (!actionRequest.getAction().equals(BATCH)) {
            String msg = "Action '" + actionRequest.getAction() + "' not implemented for this resource";
            NotSupportedException exception = new NotSupportedException(msg);
            this.debug.error(msg, (Throwable)exception);
            return exception.asPromise();
        }
        String scriptId = null;
        try {
            JsonValue scriptIdValue = actionRequest.getContent().get(SCRIPT_ID);
            if (scriptIdValue == null) {
                if (this.debug.errorEnabled()) {
                    this.debug.error("BatchResource :: actionCollection - ScriptId null. Default scripts not implemented.");
                }
                return new BadRequestException().asPromise();
            }
            scriptId = scriptIdValue.asString();
            JsonValue requests = actionRequest.getContent().get(REQUESTS);
            String realm = this.getRealm(serverContext);
            ScriptConfiguration scriptConfig = this.scriptingServiceFactory.create(realm).get(scriptId);
            ScriptObject script = new ScriptObject(scriptConfig.getName(), scriptConfig.getScript(), scriptConfig.getLanguage());
            ScriptResponse response = new ScriptResponse();
            SimpleBindings bindings = new SimpleBindings();
            bindings.put(PAYLOAD, (Object)requests);
            bindings.put(CONTEXT, (Object)serverContext);
            bindings.put(LOGGER, (Object)this.debug);
            bindings.put(REQUESTER, (Object)this.requester);
            bindings.put(RESPONSE, (Object)response);
            return Promises.newResultPromise((Object)Responses.newActionResponse((JsonValue)((JsonValue)this.scriptEvaluator.evaluateScript(script, bindings))));
        }
        catch (ScriptException e) {
            this.debug.error("BatchResource :: actionCollection - Error running script : {}", new Object[]{scriptId});
            return ((ResourceException)this.exceptionMappingHandler.handleError(serverContext, (Request)actionRequest, (Exception)((Object)e))).asPromise();
        }
        catch (javax.script.ScriptException e) {
            this.debug.error("BatchResource :: actionCollection - Error running script : {}", new Object[]{scriptId});
            return new InternalServerErrorException().asPromise();
        }
    }

    public Promise<ActionResponse, ResourceException> actionInstance(Context serverContext, String s, ActionRequest actionRequest) {
        return RestUtils.generateUnsupportedOperation();
    }

    public Promise<ResourceResponse, ResourceException> createInstance(Context serverContext, CreateRequest createRequest) {
        return RestUtils.generateUnsupportedOperation();
    }

    public Promise<ResourceResponse, ResourceException> deleteInstance(Context serverContext, String s, DeleteRequest deleteRequest) {
        return RestUtils.generateUnsupportedOperation();
    }

    public Promise<ResourceResponse, ResourceException> patchInstance(Context serverContext, String s, PatchRequest patchRequest) {
        return RestUtils.generateUnsupportedOperation();
    }

    public Promise<QueryResponse, ResourceException> queryCollection(Context serverContext, QueryRequest queryRequest, QueryResourceHandler queryResultHandler) {
        return RestUtils.generateUnsupportedOperation();
    }

    public Promise<ResourceResponse, ResourceException> readInstance(Context serverContext, String s, ReadRequest readRequest) {
        return RestUtils.generateUnsupportedOperation();
    }

    public Promise<ResourceResponse, ResourceException> updateInstance(Context serverContext, String s, UpdateRequest updateRequest) {
        return RestUtils.generateUnsupportedOperation();
    }
}

