/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.service;

import com.iplanet.sso.SSOException;
import com.sun.identity.sm.ChoiceValues;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfigManager;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.forgerock.openam.core.CoreWrapper;
import org.forgerock.openam.scripting.ScriptConstants;
import org.forgerock.openam.scripting.ScriptException;
import org.forgerock.openam.scripting.service.ScriptConfiguration;
import org.forgerock.openam.scripting.service.ScriptConfigurationService;
import org.forgerock.openam.scripting.service.ScriptingService;
import org.forgerock.openam.utils.CollectionUtils;
import org.forgerock.openam.utils.StringUtils;
import org.forgerock.util.query.QueryFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptChoiceValues
extends ChoiceValues {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)"Scripting");

    public Map getChoiceValues() {
        return this.getChoiceValues(Collections.EMPTY_MAP);
    }

    public Map getChoiceValues(Map envParams) {
        Map keyValues;
        String realm = null;
        String contextId = null;
        boolean globalOnly = false;
        if (envParams != null) {
            realm = (String)envParams.get("organization_name");
            contextId = (String)envParams.get("configuration_name");
        }
        if (StringUtils.isBlank(realm)) {
            realm = SMSEntry.getRootSuffix();
        }
        if (CollectionUtils.isNotEmpty((Map)(keyValues = this.getConfiguredKeyValues()))) {
            Set values = (Set)keyValues.get("ContextId");
            if (StringUtils.isBlank((String)contextId) && CollectionUtils.isNotEmpty((Collection)values)) {
                contextId = (String)values.iterator().next();
            }
            if (CollectionUtils.isNotEmpty((Collection)(values = (Set)keyValues.get("GlobalOnly")))) {
                globalOnly = Boolean.parseBoolean((String)values.iterator().next());
            }
        }
        LinkedHashMap<String, String> choiceValues = new LinkedHashMap<String, String>();
        if (globalOnly) {
            for (ScriptConstants.GlobalScript globalScript : ScriptConstants.GlobalScript.values()) {
                if (!StringUtils.isBlank((String)contextId) && !globalScript.getContext().name().equalsIgnoreCase(contextId)) continue;
                choiceValues.put(globalScript.getId(), globalScript.getDisplayName());
            }
        } else {
            ScriptingService scriptingService = this.getScriptingService(realm);
            try {
                Set<ScriptConfiguration> scriptConfigs = StringUtils.isBlank((String)contextId) ? scriptingService.getAll() : scriptingService.get((QueryFilter<String>)QueryFilter.equalTo((Object)"context", (Object)contextId));
                for (ScriptConfiguration config : scriptConfigs) {
                    choiceValues.put(config.getId(), config.getName());
                }
            }
            catch (ScriptException e) {
                LOGGER.error("Failed to retrieve scripts for " + contextId, (Throwable)((Object)e));
            }
        }
        choiceValues.put("[Empty]", "label.select.script");
        return choiceValues;
    }

    private ScriptingService getScriptingService(String realm) {
        CoreWrapper coreWrapper = new CoreWrapper();
        try {
            return new ScriptConfigurationService(LOGGER, realm, coreWrapper, new ServiceConfigManager("ScriptingService", coreWrapper.getAdminToken()));
        }
        catch (SSOException | SMSException e) {
            throw new IllegalStateException("Unable to get service config manager for scripting service", e);
        }
    }
}

