/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.service;

import java.util.UUID;
import org.forgerock.openam.scripting.ScriptConstants;
import org.forgerock.openam.scripting.ScriptException;
import org.forgerock.openam.scripting.SupportedScriptingLanguage;
import org.forgerock.openam.utils.StringUtils;

public class ScriptConfiguration {
    private final String id;
    private final String name;
    private final String script;
    private final boolean isDefault;
    private final SupportedScriptingLanguage language;
    private final ScriptConstants.ScriptContext context;
    private final String description;
    private final String createdBy;
    private final long creationDate;
    private final String lastModifiedBy;
    private final long lastModifiedDate;
    private volatile int hashCode = 0;

    private ScriptConfiguration(Builder builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.script = builder.script;
        this.isDefault = ScriptConstants.GlobalScript.isGlobalScript(this.id);
        this.language = builder.language;
        this.context = builder.context;
        this.description = builder.description;
        this.createdBy = builder.createdBy;
        this.creationDate = builder.creationDate;
        this.lastModifiedBy = builder.lastModifiedBy;
        this.lastModifiedDate = builder.lastModifiedDate;
    }

    public static final Builder builder() {
        return new Builder();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getScript() {
        return this.script;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public SupportedScriptingLanguage getLanguage() {
        return this.language;
    }

    public ScriptConstants.ScriptContext getContext() {
        return this.context;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public long getCreationDate() {
        return this.creationDate;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScriptConfiguration)) {
            return false;
        }
        ScriptConfiguration sc = (ScriptConfiguration)o;
        return sc.id.equals(this.id) && sc.name.equals(this.name) && StringUtils.isEqualTo((String)sc.script, (String)this.script) && sc.language.equals(this.language) && sc.context.equals((Object)this.context) && StringUtils.isEqualTo((String)sc.description, (String)this.description) && StringUtils.isEqualTo((String)sc.createdBy, (String)this.createdBy) && sc.creationDate == this.creationDate && StringUtils.isEqualTo((String)sc.lastModifiedBy, (String)this.lastModifiedBy) && sc.lastModifiedDate == this.lastModifiedDate;
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            int prime = 31;
            result = 17;
            result = prime * result + this.id.hashCode();
            result = prime * result + this.name.hashCode();
            result = prime * result + this.script.hashCode();
            result = prime * result + this.language.hashCode();
            result = prime * result + this.context.hashCode();
            result = prime * result + (this.description == null ? 0 : this.description.hashCode());
            result = prime * result + (this.createdBy == null ? 0 : this.createdBy.hashCode());
            result = prime * result + (int)(this.creationDate ^ this.creationDate >>> 32);
            result = prime * result + (this.lastModifiedBy == null ? 0 : this.lastModifiedBy.hashCode());
            this.hashCode = result = prime * result + (int)(this.lastModifiedDate ^ this.lastModifiedDate >>> 32);
        }
        return result;
    }

    public Builder populatedBuilder() {
        return ScriptConfiguration.builder().setId(this.id).setName(this.name).setContext(this.context).setLanguage(this.language).setScript(this.script).setDescription(this.description).setCreatedBy(this.createdBy).setCreationDate(this.creationDate).setLastModifiedBy(this.lastModifiedBy).setLastModifiedDate(this.lastModifiedDate);
    }

    public static class Builder {
        private String id;
        private String name;
        private String script;
        private SupportedScriptingLanguage language;
        private ScriptConstants.ScriptContext context;
        private String description;
        private String createdBy;
        private long creationDate;
        private String lastModifiedBy;
        private long lastModifiedDate;

        private Builder() {
        }

        public Builder generateId() {
            this.id = UUID.randomUUID().toString();
            return this;
        }

        public Builder setId(String id) {
            this.id = id;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setScript(String script) {
            this.script = script;
            return this;
        }

        public Builder setLanguage(SupportedScriptingLanguage language) {
            this.language = language;
            return this;
        }

        public Builder setContext(ScriptConstants.ScriptContext context) {
            this.context = context;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public Builder setCreationDate(long creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public Builder setLastModifiedBy(String lastModifiedBy) {
            this.lastModifiedBy = lastModifiedBy;
            return this;
        }

        public Builder setLastModifiedDate(long lastModifiedDate) {
            this.lastModifiedDate = lastModifiedDate;
            return this;
        }

        public ScriptConfiguration build() throws ScriptException {
            if (this.id == null) {
                throw new ScriptException(ScriptConstants.ScriptErrorCode.MISSING_SCRIPT_UUID, new String[0]);
            }
            if (this.name == null) {
                throw new ScriptException(ScriptConstants.ScriptErrorCode.MISSING_SCRIPT_NAME, new String[0]);
            }
            if (this.script == null) {
                throw new ScriptException(ScriptConstants.ScriptErrorCode.MISSING_SCRIPT, new String[0]);
            }
            if (this.language == null) {
                throw new ScriptException(ScriptConstants.ScriptErrorCode.MISSING_SCRIPTING_LANGUAGE, new String[0]);
            }
            if (this.context == null) {
                throw new ScriptException(ScriptConstants.ScriptErrorCode.MISSING_SCRIPT_CONTEXT, new String[0]);
            }
            return new ScriptConfiguration(this);
        }
    }
}

