/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.service;

import com.google.common.base.Predicate;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.forgerock.openam.scripting.service.ScriptConfiguration;
import org.forgerock.util.query.QueryFilter;
import org.forgerock.util.query.QueryFilterVisitor;

class ScriptConfigurationQueryFilterVisitor
implements QueryFilterVisitor<Set<ScriptConfiguration>, Set<ScriptConfiguration>, String> {
    private static final BeanInfo BEAN_INFO;

    ScriptConfigurationQueryFilterVisitor() {
    }

    public Set<ScriptConfiguration> visitAndFilter(Set<ScriptConfiguration> scriptConfigurations, List<QueryFilter<String>> subFilters) {
        HashSet<ScriptConfiguration> result = new HashSet<ScriptConfiguration>(scriptConfigurations);
        for (QueryFilter<String> filter : subFilters) {
            result.retainAll((Collection)filter.accept((QueryFilterVisitor)this, scriptConfigurations));
        }
        return result;
    }

    public Set<ScriptConfiguration> visitOrFilter(Set<ScriptConfiguration> scriptConfigurations, List<QueryFilter<String>> subFilters) {
        HashSet<ScriptConfiguration> result = new HashSet<ScriptConfiguration>();
        for (QueryFilter<String> filter : subFilters) {
            result.addAll((Collection)filter.accept((QueryFilterVisitor)this, scriptConfigurations));
        }
        return result;
    }

    public Set<ScriptConfiguration> visitBooleanLiteralFilter(Set<ScriptConfiguration> scriptConfigurations, boolean value) {
        return value ? scriptConfigurations : Collections.emptySet();
    }

    public Set<ScriptConfiguration> visitContainsFilter(Set<ScriptConfiguration> scriptConfigurations, String field, final Object valueAssertion) {
        final PropertyDescriptor descriptor = this.getField(field);
        return this.findMatching(scriptConfigurations, new Predicate<ScriptConfiguration>(){

            public boolean apply(@Nullable ScriptConfiguration configuration) {
                return ScriptConfigurationQueryFilterVisitor.this.getStringValue(descriptor, configuration).contains(valueAssertion.toString());
            }
        });
    }

    public Set<ScriptConfiguration> visitEqualsFilter(Set<ScriptConfiguration> scriptConfigurations, String field, final Object valueAssertion) {
        final PropertyDescriptor descriptor = this.getField(field);
        return this.findMatching(scriptConfigurations, new Predicate<ScriptConfiguration>(){

            public boolean apply(@Nullable ScriptConfiguration configuration) {
                return ScriptConfigurationQueryFilterVisitor.this.getValue(descriptor, configuration).equals(valueAssertion);
            }
        });
    }

    public Set<ScriptConfiguration> visitGreaterThanFilter(Set<ScriptConfiguration> scriptConfigurations, String field, final Object valueAssertion) {
        final PropertyDescriptor descriptor = this.getField(field);
        return this.findMatching(scriptConfigurations, new Predicate<ScriptConfiguration>(){

            public boolean apply(@Nullable ScriptConfiguration configuration) {
                Comparable comparableValue = ScriptConfigurationQueryFilterVisitor.this.getComparableValue(descriptor, configuration);
                return comparableValue.getClass().equals(valueAssertion.getClass()) && comparableValue.compareTo(valueAssertion) > 0;
            }
        });
    }

    public Set<ScriptConfiguration> visitGreaterThanOrEqualToFilter(Set<ScriptConfiguration> scriptConfigurations, String field, final Object valueAssertion) {
        final PropertyDescriptor descriptor = this.getField(field);
        return this.findMatching(scriptConfigurations, new Predicate<ScriptConfiguration>(){

            public boolean apply(@Nullable ScriptConfiguration configuration) {
                Comparable comparableValue = ScriptConfigurationQueryFilterVisitor.this.getComparableValue(descriptor, configuration);
                return comparableValue.getClass().equals(valueAssertion.getClass()) && comparableValue.compareTo(valueAssertion) >= 0;
            }
        });
    }

    public Set<ScriptConfiguration> visitLessThanFilter(Set<ScriptConfiguration> scriptConfigurations, String field, final Object valueAssertion) {
        final PropertyDescriptor descriptor = this.getField(field);
        return this.findMatching(scriptConfigurations, new Predicate<ScriptConfiguration>(){

            public boolean apply(@Nullable ScriptConfiguration configuration) {
                Comparable comparableValue = ScriptConfigurationQueryFilterVisitor.this.getComparableValue(descriptor, configuration);
                return comparableValue.getClass().equals(valueAssertion.getClass()) && comparableValue.compareTo(valueAssertion) < 0;
            }
        });
    }

    public Set<ScriptConfiguration> visitLessThanOrEqualToFilter(Set<ScriptConfiguration> scriptConfigurations, String field, final Object valueAssertion) {
        final PropertyDescriptor descriptor = this.getField(field);
        return this.findMatching(scriptConfigurations, new Predicate<ScriptConfiguration>(){

            public boolean apply(@Nullable ScriptConfiguration configuration) {
                Comparable comparableValue = ScriptConfigurationQueryFilterVisitor.this.getComparableValue(descriptor, configuration);
                return comparableValue.getClass().equals(valueAssertion.getClass()) && comparableValue.compareTo(valueAssertion) <= 0;
            }
        });
    }

    public Set<ScriptConfiguration> visitNotFilter(Set<ScriptConfiguration> scriptConfigurations, QueryFilter<String> subFilter) {
        HashSet<ScriptConfiguration> configurations = new HashSet<ScriptConfiguration>(scriptConfigurations);
        configurations.removeAll((Collection)subFilter.accept((QueryFilterVisitor)this, scriptConfigurations));
        return null;
    }

    public Set<ScriptConfiguration> visitPresentFilter(Set<ScriptConfiguration> scriptConfigurations, String field) {
        final PropertyDescriptor descriptor = this.getField(field);
        return this.findMatching(scriptConfigurations, new Predicate<ScriptConfiguration>(){

            public boolean apply(@Nullable ScriptConfiguration configuration) {
                return ScriptConfigurationQueryFilterVisitor.this.getValue(descriptor, configuration) != null;
            }
        });
    }

    public Set<ScriptConfiguration> visitStartsWithFilter(Set<ScriptConfiguration> scriptConfigurations, String field, final Object valueAssertion) {
        final PropertyDescriptor descriptor = this.getField(field);
        return this.findMatching(scriptConfigurations, new Predicate<ScriptConfiguration>(){

            public boolean apply(@Nullable ScriptConfiguration configuration) {
                return ScriptConfigurationQueryFilterVisitor.this.getStringValue(descriptor, configuration).startsWith(valueAssertion.toString());
            }
        });
    }

    private PropertyDescriptor getField(String field) {
        for (PropertyDescriptor pd : BEAN_INFO.getPropertyDescriptors()) {
            if (!pd.getName().equals(field)) continue;
            return pd;
        }
        throw new IllegalArgumentException("Unknown field: " + field);
    }

    private Object getValue(PropertyDescriptor pd, ScriptConfiguration configuration) {
        try {
            Object result = pd.getReadMethod().invoke((Object)configuration, new Object[0]);
            return result instanceof Enum ? ((Enum)result).name() : result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalArgumentException("Cannot get field: " + pd.getName(), e);
        }
    }

    private String getStringValue(PropertyDescriptor pd, ScriptConfiguration configuration) {
        Object result = this.getValue(pd, configuration);
        if (result instanceof Number) {
            throw new IllegalArgumentException("Field is not a string: " + pd.getName());
        }
        if (result instanceof Enum) {
            return ((Enum)result).name();
        }
        return result.toString();
    }

    private Comparable getComparableValue(PropertyDescriptor pd, ScriptConfiguration configuration) {
        Object result = this.getValue(pd, configuration);
        if (result instanceof Enum) {
            result = ((Enum)result).name();
        }
        if (!(result instanceof Comparable)) {
            throw new IllegalArgumentException("Field is not a comparable: " + pd.getName());
        }
        return (Comparable)result;
    }

    private Set<ScriptConfiguration> findMatching(Set<ScriptConfiguration> configurations, Predicate<ScriptConfiguration> test) {
        HashSet<ScriptConfiguration> result = new HashSet<ScriptConfiguration>();
        for (ScriptConfiguration sc : configurations) {
            if (!test.apply((Object)sc)) continue;
            result.add(sc);
        }
        return result;
    }

    public Set<ScriptConfiguration> visitExtendedMatchFilter(Set<ScriptConfiguration> scriptConfigurations, String field, String operator, Object valueAssertion) {
        throw new UnsupportedOperationException();
    }

    static {
        try {
            BEAN_INFO = Introspector.getBeanInfo(ScriptConfiguration.class);
        }
        catch (IntrospectionException e) {
            throw new IllegalStateException("Cannot get bean info for ScriptConfiguration", e);
        }
    }
}

