/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting.timeouts;

import java.util.concurrent.TimeUnit;
import org.forgerock.openam.scripting.StandardScriptEngineManager;
import org.forgerock.openam.utils.Time;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;

public class ObservedContextFactory
extends ContextFactory {
    private static final int OBSERVER_THRESHOLD = 1000;
    private final StandardScriptEngineManager manager;

    public ObservedContextFactory(StandardScriptEngineManager manager) {
        this.manager = manager;
    }

    protected Context makeContext() {
        return new ObservedJavaScriptContext(this);
    }

    protected void observeInstructionCount(Context cx, int instructionCount) {
        ObservedJavaScriptContext context = (ObservedJavaScriptContext)cx;
        long timeout = TimeUnit.MILLISECONDS.convert(this.manager.getConfiguration().getScriptExecutionTimeout(), TimeUnit.SECONDS);
        if (timeout > 0L && Time.currentTimeMillis() - context.getStartTime() > timeout) {
            throw new Error("Interrupt.");
        }
    }

    protected static class ObservedJavaScriptContext
    extends Context {
        private final long startTime = Time.currentTimeMillis();

        public ObservedJavaScriptContext(ObservedContextFactory factory) {
            super((ContextFactory)factory);
            this.setOptimizationLevel(-1);
            this.setInstructionObserverThreshold(1000);
        }

        public long getStartTime() {
            return this.startTime;
        }
    }
}

