/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.forgerock.util.Reject;

public final class ScriptEngineConfiguration {
    public static final long NO_TIMEOUT = 0L;
    public static final int UNBOUNDED_QUEUE_SIZE = -1;
    private final long scriptExecutionTimeout;
    private final List<Pattern> classWhiteList;
    private final List<Pattern> classBlackList;
    private final SecurityManager securityManager;
    private final int threadPoolCoreSize;
    private final int threadPoolMaxSize;
    private final int threadPoolQueueSize;
    private final long threadPoolIdleTimeout;

    ScriptEngineConfiguration(long scriptExecutionTimeout, List<Pattern> classWhiteList, List<Pattern> classBlackList, SecurityManager securityManager, int threadPoolCoreSize, int threadPoolMaxSize, int threadPoolQueueSize, long threadPoolIdleTimeout) {
        Reject.ifNull((Object[])new List[]{classWhiteList, classBlackList});
        Reject.ifTrue((scriptExecutionTimeout < 0L ? 1 : 0) != 0);
        Reject.ifTrue((threadPoolCoreSize < 1 ? 1 : 0) != 0);
        Reject.ifTrue((threadPoolMaxSize < 1 ? 1 : 0) != 0);
        Reject.ifTrue((threadPoolQueueSize < -1 ? 1 : 0) != 0);
        Reject.ifTrue((threadPoolIdleTimeout < 0L ? 1 : 0) != 0);
        this.scriptExecutionTimeout = scriptExecutionTimeout;
        this.classWhiteList = new ArrayList<Pattern>(classWhiteList);
        this.classBlackList = new ArrayList<Pattern>(classBlackList);
        this.securityManager = securityManager;
        this.threadPoolCoreSize = threadPoolCoreSize;
        this.threadPoolMaxSize = threadPoolMaxSize;
        this.threadPoolQueueSize = threadPoolQueueSize;
        this.threadPoolIdleTimeout = threadPoolIdleTimeout;
    }

    public long getScriptExecutionTimeout() {
        return this.scriptExecutionTimeout;
    }

    public List<Pattern> getClassWhiteList() {
        return Collections.unmodifiableList(this.classWhiteList);
    }

    public List<Pattern> getClassBlackList() {
        return Collections.unmodifiableList(this.classBlackList);
    }

    public SecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public int getThreadPoolCoreSize() {
        return this.threadPoolCoreSize;
    }

    public int getThreadPoolMaxSize() {
        return this.threadPoolMaxSize;
    }

    public int getThreadPoolQueueSize() {
        return this.threadPoolQueueSize;
    }

    public long getThreadPoolIdleTimeoutSeconds() {
        return this.threadPoolIdleTimeout;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        return "ScriptEngineConfiguration{scriptExecutionTimeout=" + this.scriptExecutionTimeout + ", threadPoolCoreSize=" + this.threadPoolCoreSize + ", threadPoolMaxSize=" + this.threadPoolMaxSize + ", threadPoolQueueSize=" + this.threadPoolQueueSize + ", threadPoolIdleTimeoutSeconds=" + this.threadPoolIdleTimeout + ", classWhiteList=" + this.classWhiteList + ", classBlackList=" + this.classBlackList + ", securityManager=" + this.securityManager + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScriptEngineConfiguration that = (ScriptEngineConfiguration)o;
        if (this.scriptExecutionTimeout != that.scriptExecutionTimeout) {
            return false;
        }
        if (this.threadPoolCoreSize != that.threadPoolCoreSize) {
            return false;
        }
        if (this.threadPoolMaxSize != that.threadPoolMaxSize) {
            return false;
        }
        if (this.threadPoolQueueSize != that.threadPoolQueueSize) {
            return false;
        }
        if (this.threadPoolIdleTimeout != that.threadPoolIdleTimeout) {
            return false;
        }
        if (!this.classBlackList.equals(that.classBlackList)) {
            return false;
        }
        if (!this.classWhiteList.equals(that.classWhiteList)) {
            return false;
        }
        return !(this.securityManager != null ? !this.securityManager.equals(that.securityManager) : that.securityManager != null);
    }

    public int hashCode() {
        int result = Long.valueOf(this.scriptExecutionTimeout).hashCode();
        result = 31 * result + this.classWhiteList.hashCode();
        result = 31 * result + this.classBlackList.hashCode();
        result = 31 * result + (this.securityManager != null ? this.securityManager.hashCode() : 0);
        result = 31 * result + this.threadPoolCoreSize;
        result = 31 * result + this.threadPoolMaxSize;
        result = 31 * result + this.threadPoolQueueSize;
        result = 31 * result + Long.valueOf(this.threadPoolIdleTimeout).hashCode();
        return result;
    }

    public static final class Builder {
        private long timeout = 0L;
        private List<Pattern> whiteList = new ArrayList<Pattern>();
        private List<Pattern> blackList = new ArrayList<Pattern>();
        private SecurityManager securityManager = null;
        private int coreSize = 1;
        private int maxSize = 1;
        private int queueSize = 10;
        private long idleTimeout = 60L;

        public Builder withTimeout(long timeout, TimeUnit unit) {
            Reject.ifFalse((timeout >= 0L ? 1 : 0) != 0, (String)"Timeout must be >= 0");
            this.timeout = TimeUnit.SECONDS.convert(timeout, unit);
            return this;
        }

        public Builder withWhiteList(List<Pattern> whiteList) {
            Reject.ifNull(whiteList);
            this.whiteList = whiteList;
            return this;
        }

        public Builder withBlackList(List<Pattern> blackList) {
            Reject.ifNull(blackList);
            this.blackList = blackList;
            return this;
        }

        public Builder withSecurityManager(SecurityManager securityManager) {
            this.securityManager = securityManager;
            return this;
        }

        public Builder withSystemSecurityManager() {
            return this.withSecurityManager(System.getSecurityManager());
        }

        public Builder withThreadPoolCoreSize(int coreSize) {
            Reject.ifTrue((coreSize < 1 ? 1 : 0) != 0, (String)"Must configure at least one thread");
            this.coreSize = coreSize;
            return this;
        }

        public Builder withThreadPoolMaxSize(int maxSize) {
            Reject.ifTrue((maxSize < 1 ? 1 : 0) != 0, (String)"Must configure at least one thread");
            this.maxSize = maxSize;
            return this;
        }

        public Builder withThreadPoolQueueSize(int queueSize) {
            Reject.ifTrue((queueSize < -1 ? 1 : 0) != 0, (String)"Queue size cannot be negative");
            this.queueSize = queueSize;
            return this;
        }

        public Builder withThreadPoolIdleTimeout(long timeout, TimeUnit units) {
            Reject.ifTrue((timeout < 0L ? 1 : 0) != 0, (String)"Idle timeout cannot be negative");
            this.idleTimeout = TimeUnit.SECONDS.convert(timeout, units);
            return this;
        }

        public ScriptEngineConfiguration build() {
            if (this.maxSize < this.coreSize) {
                throw new IllegalStateException("Maximum thread pool size is less than core size");
            }
            return new ScriptEngineConfiguration(this.timeout, this.whiteList, this.blackList, this.securityManager, this.coreSize, this.maxSize, this.queueSize, this.idleTimeout);
        }
    }
}

