/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting;

import com.google.inject.Key;
import com.google.inject.name.Names;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.security.AdminTokenAction;
import com.sun.identity.shared.datastruct.CollectionHelper;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceListener;
import java.lang.annotation.Annotation;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.forgerock.guice.core.InjectorHolder;
import org.forgerock.openam.scripting.ScriptConstants;
import org.forgerock.openam.scripting.ScriptEngineConfiguration;
import org.forgerock.openam.scripting.StandardScriptEngineManager;
import org.forgerock.openam.utils.StringUtils;
import org.slf4j.Logger;

@Singleton
public class ScriptEngineConfigurator
implements ServiceListener {
    private final Logger logger;
    private volatile boolean initialised = false;

    @Inject
    public ScriptEngineConfigurator(@Named(value="ScriptLogger") Logger logger) {
        this.logger = logger;
    }

    public void registerServiceListener() {
        if (!this.initialised) {
            try {
                String listenerId = new ServiceConfigManager("ScriptingService", this.getAdminToken()).addListener((ServiceListener)this);
                if (listenerId == null) {
                    throw new SMSException("Unable to register service config listener");
                }
                this.logger.info("Registered service config listener: {}", (Object)listenerId);
                this.updateConfig(ScriptConstants.ScriptContext.POLICY_CONDITION);
                this.updateConfig(ScriptConstants.ScriptContext.AUTHENTICATION_SERVER_SIDE);
                this.updateConfig(ScriptConstants.ScriptContext.OIDC_CLAIMS);
                this.initialised = true;
            }
            catch (SSOException | SMSException e) {
                this.logger.error("Unable to create ServiceConfigManager", e);
                throw new IllegalStateException(e);
            }
        }
    }

    public void schemaChanged(String serviceName, String version) {
    }

    public void organizationConfigChanged(String serviceName, String version, String orgName, String groupName, String serviceComponent, int type) {
    }

    public void globalConfigChanged(String serviceName, String version, String groupName, String serviceComponent, int type) {
        if (!"ScriptingService".equals(serviceName) || StringUtils.isEmpty((String)serviceComponent)) {
            return;
        }
        String[] components = (serviceComponent = serviceComponent.startsWith("/") ? serviceComponent.substring(1).trim() : serviceComponent).toUpperCase().split("/");
        if (components.length == 2 && "EngineConfiguration".equalsIgnoreCase(components[1])) {
            try {
                this.updateConfig(ScriptConstants.ScriptContext.valueOf(components[0]));
            }
            catch (IllegalArgumentException e) {
                this.logger.error("Script Context does not exist: " + components[0], (Throwable)e);
            }
        }
    }

    private StandardScriptEngineManager getScriptEngineManager(ScriptConstants.ScriptContext context) {
        return (StandardScriptEngineManager)InjectorHolder.getInstance((Key)Key.get(StandardScriptEngineManager.class, (Annotation)Names.named((String)context.name())));
    }

    protected void updateConfig(ScriptConstants.ScriptContext context) {
        Map<String, Set<String>> config = this.getEngineConfigurationSchema(context);
        int coreThreadSize = this.parseInt(CollectionHelper.getMapAttr(config, (String)"coreThreads"), 10);
        int maxThreadSize = this.parseInt(CollectionHelper.getMapAttr(config, (String)"maxThreads"), 10);
        int queueSize = this.parseInt(CollectionHelper.getMapAttr(config, (String)"queueSize"), 10);
        long idleTimeout = this.parseLong(CollectionHelper.getMapAttr(config, (String)"idleTimeout"), 60L);
        long scriptTimeout = this.parseLong(CollectionHelper.getMapAttr(config, (String)"serverTimeout"), 0L);
        boolean useSystemSecurityManager = CollectionHelper.getBooleanMapAttr(config, (String)"useSecurityManager", (boolean)true);
        SecurityManager securityManager = useSystemSecurityManager ? System.getSecurityManager() : null;
        Set<String> whiteList = config.get("whiteList");
        Set<String> blackList = config.get("blackList");
        ScriptEngineConfiguration configuration = ScriptEngineConfiguration.builder().withSecurityManager(securityManager).withThreadPoolCoreSize(coreThreadSize).withThreadPoolMaxSize(maxThreadSize).withThreadPoolQueueSize(queueSize).withThreadPoolIdleTimeout(idleTimeout, TimeUnit.SECONDS).withTimeout(scriptTimeout, TimeUnit.SECONDS).withWhiteList(this.compilePatternList(whiteList)).withBlackList(this.compilePatternList(blackList)).build();
        this.getScriptEngineManager(context).setConfiguration(configuration);
    }

    private SSOToken getAdminToken() {
        return (SSOToken)AccessController.doPrivileged(AdminTokenAction.getInstance());
    }

    private Map<String, Set<String>> getEngineConfigurationSchema(ScriptConstants.ScriptContext context) {
        try {
            ServiceConfig engineConfig;
            ServiceConfig contextConfig;
            ServiceConfig globalConfig = new ServiceConfigManager("ScriptingService", this.getAdminToken()).getGlobalConfig("default");
            if (globalConfig != null && (contextConfig = globalConfig.getSubConfig(context.name())) != null && (engineConfig = contextConfig.getSubConfig("EngineConfiguration")) != null) {
                return engineConfig.getAttributes();
            }
        }
        catch (SMSException e) {
            this.logger.error("ScriptEngineConfigurator.updateConfig", (Throwable)e);
        }
        catch (SSOException e) {
            this.logger.error("ScriptEngineConfigurator.updateConfig", (Throwable)e);
        }
        this.logger.error("No engine configuration called 'EngineConfiguration' found for context '" + context.name() + "' in service '" + "ScriptingService" + "'. Using default configuration.");
        return Collections.emptyMap();
    }

    protected List<Pattern> compilePatternList(Set<String> patterns) {
        ArrayList<Pattern> result = new ArrayList<Pattern>();
        if (patterns != null) {
            for (String pattern : patterns) {
                if (pattern.isEmpty()) continue;
                String regex = "\\Q" + pattern.replace("*", "\\E.*?\\Q") + "\\E";
                result.add(Pattern.compile(regex));
            }
        }
        return result;
    }

    private int parseInt(String value, int defaultValue) {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            this.logger.error("ScriptEngineConfigurator.parseInt", (Throwable)nfe);
            return defaultValue;
        }
    }

    private long parseLong(String value, long defaultValue) {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            this.logger.error("ScriptEngineConfigurator.parseLong", (Throwable)nfe);
            return defaultValue;
        }
    }
}

