/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openam.scripting;

import com.sun.identity.shared.locale.L10NMessageImpl;
import org.forgerock.openam.scripting.ScriptConstants;
import org.slf4j.Logger;

public class ScriptException
extends L10NMessageImpl {
    private final ScriptConstants.ScriptErrorCode scriptErrorCode;

    public ScriptException(ScriptConstants.ScriptErrorCode errorCode, Throwable cause, String ... arguments) {
        super("scripting", errorCode.name(), (Object[])arguments);
        this.initCause(cause);
        this.scriptErrorCode = errorCode;
    }

    public ScriptException(ScriptConstants.ScriptErrorCode errorCode, String ... arguments) {
        this(errorCode, (Throwable)null, arguments);
    }

    public ScriptConstants.ScriptErrorCode getScriptErrorCode() {
        return this.scriptErrorCode;
    }

    public static ScriptException createAndLogError(Logger logger, ScriptConstants.ScriptErrorCode errorCode, Throwable cause, String ... arguments) {
        ScriptException exception = new ScriptException(errorCode, cause, arguments);
        logger.error(exception.getMessage(), cause);
        return exception;
    }

    public static ScriptException createAndLogDebug(Logger logger, ScriptConstants.ScriptErrorCode errorCode, Throwable cause, String ... arguments) {
        ScriptException exception = new ScriptException(errorCode, cause, arguments);
        logger.debug(exception.getMessage(), cause);
        return exception;
    }

    public static ScriptException createAndLogError(Logger logger, ScriptConstants.ScriptErrorCode errorCode, String ... arguments) {
        ScriptException exception = new ScriptException(errorCode, arguments);
        logger.error(exception.getMessage());
        return exception;
    }

    public static ScriptException createAndLogDebug(Logger logger, ScriptConstants.ScriptErrorCode errorCode, String ... arguments) {
        ScriptException exception = new ScriptException(errorCode, arguments);
        logger.debug(exception.getMessage());
        return exception;
    }
}

